/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>

#include <qpainter.h>

#include <klistview.h>
#include <kmessagebox.h>

class NetListViewItem : public KListViewItem
{
public:
        //NetListViewItem(KListView *parent) : KListViewItem(parent) {}
        //NetListViewItem(KListView *parent, KListViewItem *after) : KListViewItem(parent, after) {}
        //NetListViewItem(KListView *parent, KListViewItem *after, QString essid, QString mode) : KListViewItem(parent, after, essid, mode) {}
        NetListViewItem(KListView *parent, QString essid, QString chan, int quality, bool enc, QString ap, bool hidden, bool connected = 0 )
                        : KListViewItem(parent, QString::null, QString::null, QString::null, QString::null, QString::null)
        {
                mEssid = essid;
                mChannel = chan;
                //mMode = mode;
                mQuality = quality;
                mEnc = enc;
                mAP = ap;
                mHidden = hidden;
                mConnected = connected;
                mInternet = false;
                mHeight = height();
        }

        ~NetListViewItem()
        {}

        void setEssid(const QString& theValue)
        {
                mEssid = theValue;
                setText(mEssidColumn, mEssid);
                //update();
        }
        QString essid() const
        {
                return mEssid;
        }

        QString channel() const
        {
                return mChannel;
        }

        /*QString mode() const
        {
                return mMode;
        }*/

        bool enc() const
        {
                return mEnc;
        }

        QString ap() const
        {
                return mAP;
        }

        bool hidden() const
        {
                return mHidden;
        }

        void setConnected(bool theValue)
        {
                mConnected = theValue;
                if (mConnected)
                        mHeight+=10;
                else {
                        mHeight-=10;
                        mInternet = false;	// no connection to AP implies no internet.
                }
                setHeight( mHeight );
                repaint();
        }


        bool isConnected() const
        {
                return mConnected;
        }

        void setQuality(const int& theValue)
        {
                if ( int(mQuality/8) != int(theValue/8) ) {	//repaint only if difference visible in quality stars
                        mQuality = theValue;
                        repaint();
                } else
                        mQuality = theValue;
        }


        int quality() const
        {
                return mQuality;
        }

	void setInternet(bool theValue)
	{
	        mInternet = theValue;
	        repaint();
	}
	

	bool isInternet() const
	{
	        return mInternet;
	}
	




private:
        virtual void paintCell (QPainter *p, const QColorGroup &cg, int column, int width, int alignment);
        virtual int width(const QFontMetrics &fm, const QListView *lv, int column) const;
        virtual QString key( int column, bool ascending ) const;

        QString mEssid;
        QString mChannel;
        //QString mMode;
        int mQuality;
        bool mEnc;
        QString mAP;
        bool mHidden;
        bool mConnected;
        bool mInternet;
        int mHeight;

        static const int mEssidColumn = 0;
        static const int mChanColumn = 1;
        static const int mQualityColumn = 2;
        static const int mEncColumn = 3;
        static const int mAPColumn = 4;

};
