/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iwlib.h>
class QStringList;

class WATools
{
public:
        static inline void setInterface( const char* new_ifname ) //sets default (fallback) interface
        {
                ifname = (char*)new_ifname;
        }
        static inline char* interface() //returns default (fallback) interface
        {
                return ifname;
        }
        static char* ap( const char* _ifname = 0 ); //returns current AP
        static int quality( const char* _ifname = 0 ); //returns current QUALITY
        static int txpower( const char* _ifname = 0 ); //returns current TXPOWER
        static bool isWireless( const char* _ifname ); //returns true if iface is a valid wireless interface
	static void cleanup(); //closes open socket etc.

private:
        static char* ifname;
	static int iw_socket;
};
