/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WLASSISTANT_H
#define WLASSISTANT_H

#include "ui_main.h"
#include "waconfig.h"

#include "netparams.h"

class QTimer;
class NetListViewItem;

class WirelessAssistant : public mainWindow
{
        Q_OBJECT

public:
        /*$PUBLIC_FUNCTIONS$*/
        WirelessAssistant(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
        ~WirelessAssistant();

        static QString getVal(const QString & str, const QString & rxs);

public slots:
        /*$PUBLIC_SLOTS$*/
        virtual void netConnect();
        virtual void netScan();
        virtual void netDisconnect( const bool & quiet = false);

protected:
        /*$PROTECTED_FUNCTIONS$*/
        void netScan( const WANetParams & np );
        void netConnect( const WANetParams & np );
        void setDNS( const WANetParams & np );
        void readConfig();
        void saveSettings();
        void setUi(int uiState);
        void setSingleClick(bool i);
        QString runCommand( const QStringList & cmd, int timeout = 0 );
        void setNetParamsFromList( QListViewItem* lvi );
        bool setNetParamsFromConfig( const QString & ap );
        QString matchEssidForAp( const QString & ap );
	bool radioEnabled();
	QListViewItem* getItemByAp( const QString & ap );
	void setConnectedItemByAp( const QString & ap );
	QString getGateway();
	bool dhcpClientRunning();
	QStringList interfaceList();
	
        QStringList NetParamsList;
        QStringList execsNotFound;
        NetListViewItem* connectedItem;
        /// settings saved in wlassistantrc
        bool autoQuit;
        int DhcpTimeout;
        /*QString dhcpcdInfoPath;
        QString dhclientInfoPath;
        QString dhcpcdPidPath;
        QString dhclientPidPath;*/
        /// end settings.

        WACommands Commands;
        WANetParams NetParams;
        QTimer* timerGui;
        QTimer* timerConnectionCheck;
        QTimer* timerFastConnectionCheck;

protected slots:
        /*$PROTECTED_SLOTS$*/
        virtual void init();
        virtual bool isConnected( const bool & gw = false );
        virtual void parseScan( const QString & output );
        virtual void setDev( const QString & ifname);
        virtual void setNetListColumns();
        virtual void updateConfiguration(int category = -1);
        virtual void updateConnectedItem();
        virtual void showItemContextMenu( QListViewItem* i, const QPoint& p, int c);
        virtual void editNetParams();
        virtual void removeNetParams();
        virtual void updateNetParams();
        virtual void itemAction();
        virtual void checkConnectionStatus();
        virtual void updateConnectButton(QListViewItem* lvi);
        virtual void setMouseBehaviour();
        virtual void togglePage(bool options );
        virtual void enableAllMessages();
        virtual bool close();
};

#endif
