/*
 *  misc.h
 *
 *  Copyright (C) 1998 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 2000/09/03 19:22:04 $
 *  $Author: hafner $
 *  $Revision: 1.26 $
 *  $State: Exp $
 */

#ifndef _MISC_H
#define _MISC_H

#if HAVE_STDLIB_H
#	include <stdlib.h>
#endif /* not HAVE_STDLIB_H */
#if HAVE_STRING_H
#	include <string.h>
#else /* not HAVE_STRING_H */
#	include <strings.h>
#endif /* not HAVE_STRING_H */
#include <gtk/gtk.h>
#include <proplist.h>

typedef unsigned bool_t;

void *
Calloc (size_t n, size_t size);
void
Free (void *ptr);
bool_t
delete_file_or_dir (const char *filename);
bool_t
make_directory (const char *dirname);
bool_t
rename_file_or_dir (const char *oldname, const char *newname);
bool_t
remove_directory (const char *directory);
bool_t
file_exists (const char *filename);
bool_t
shell_command (const char *command, const char *text);
char *
get_gnustep_path (const char *domain);
char *
expand_tilde (const char *name);
char *
preview_name (const char *name);
proplist_t *
read_proplist (const char *filename);
char *
get_temporary_file_name (void);
char *
protect_quotes (char *string);
bool_t
copy_file (const char *dst, const char *src);

#define strcaseeq(s1, s2)	(g_strcasecmp ((s1), (s2)) == 0)
#define strncaseeq(s1, s2, n)	(g_strncasecmp ((s1), (s2), (n)) == 0)
#define streq(str1, str2)	(strcmp ((str1), (str2)) == 0)
#define strneq(str1, str2, n)	(strncmp ((str1), (str2), (n)) == 0)
#define max(a, b)		((a) > (b) ? (a) : (b))
#define min(a, b)		((a) < (b) ? (a) : (b))

typedef struct node_
{
   struct node_* next;
   char*	 name;
   int		 length;
} node;

#endif /* not _MISC_H */

