/* Standard C function definition */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>

/* X-Window function definition */
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

/* ppxp function definition */
#include "ppxp.h"
#include "xcio.h"

/* ppxp exntern function */
extern int PPxPSetup( int* argc, char **argv );
extern int PPxPCommandv( int fd, xcmd_t type, ... );
extern int PPxPRead( int fd, unsigned int id, struct xcio_s *xc );
struct pppinfo_s pppinfo;
int ppxpFD;

/* include wmppxp definition */
#include "wmppxp-x.h"
#include "site.h"

#ifdef _USE_GTK
#include "wmppxp-util.h"
#endif  /* End of _USE_GTK */

/* Function prototype */
void WMPPxPRoutine( int argc, char *argv[] );
BOOL ConnectPPxP( int argc, char *argv[] );
BOOL DisconnectPPxP();
void CheckPPxPStat( struct xcio_s *xcio );

#ifdef _USE_GTK
void ParseArgument( int argc, char **argv );
#endif  /* End of _USE_GTK */

unsigned int baud_rate = BAUD_RATE;

#ifdef _USE_GTK
void ParseArgument( int argc, char **argv )
{
  int i;
  for( i=0; i<argc; i++ )
  {
    if( *argv[i] == '-' )
    {
    }
    else if( i != 0 )
    {
      isp_name = argv[i];
    }
  }
}
#endif  /* End of _USE_GTK */

int main( int argc, char *argv[] )
{
#ifdef _USE_GTK
  ParseArgument( argc, argv );
#endif  /* End of _USE_GTK */

  /* Create X-Window */
  CreateXWindow( argc, argv );

  /* wmppxp main command routine */
  WMPPxPRoutine( argc, argv );

  return 1;
}

void WMPPxPRoutine( int argc, char *argv[] )
{
  XEvent e;
  int i;
  struct xcio_s xcio;

  rgnCon.left   = 5;
  rgnCon.top    = 49;
  rgnCon.right  = 15;
  rgnCon.bottom = 59;

  rgnDis.left   = 16;
  rgnDis.top    = 49;
  rgnDis.right  = 26;
  rgnDis.bottom = 59;

  rgnPrp.left   = 27;
  rgnPrp.top    = 49;
  rgnPrp.right  = 37;
  rgnPrp.bottom = 59;

  IsConnect = FALSE;

  /* Setup PPxP */
  if( (ppxpFD = PPxPSetup( &argc, argv ) ) < 0 )
  {
    exit( 0 );
  }
  PPxPAutoUpdate( ppxpFD, TRUE );

  while( 1 )
  {
    if( IsConnect )
    {
      ShowXpm( BTN_CON_ON_X, BTN_CON_ON_Y, BUTTON_WIDTH, BUTTON_HEIGHT,
               rgnCon.left, rgnCon.top );
    }
    else
    {
      ShowXpm( BTN_CON_OFF_X, BTN_CON_OFF_Y, BUTTON_WIDTH, BUTTON_HEIGHT,
               rgnCon.left, rgnCon.top );
    }

    i = PPxPRead( ppxpFD, XID_ANY, &xcio );
    if( i > 0 )
    {
      CheckPPxPStat( &xcio );
    }

    memcpy( &pppInfo, &pppinfo, sizeof( pppinfo ) );

    while( XPending( display ) )
    {
      XNextEvent( display, &e );
      switch( e.type )
      {
        case ButtonPress:
          if( PtInButton( rgnCon, e.xbutton.x, e.xbutton.y ) )
          {
            if( !IsConnect )
            {
	      ShowXpm( BTN_CON_ON_X, BTN_CON_ON_Y, BUTTON_WIDTH, BUTTON_HEIGHT,
		       rgnCon.left, rgnCon.top );

              /* Require connection routine according to ppxp connection method */
	      if( ConnectPPxP( argc, argv ) )
              {
                IsConnect = TRUE;
	      }
              else
	      {
                IsConnect = FALSE;
	      }
	    }
 	  }
          else if( PtInButton( rgnDis, e.xbutton.x, e.xbutton.y ) )
	  {
            if( IsConnect )
	    {
              /* Change state of disconnect button to on */
              ShowXpm( BTN_DIS_ON_X, BTN_DIS_ON_Y, BUTTON_WIDTH, BUTTON_HEIGHT,
                       rgnDis.left, rgnDis.top );
              /* Change state of connect button to off */
              ShowXpm( BTN_CON_OFF_X, BTN_CON_OFF_Y, BUTTON_WIDTH, BUTTON_HEIGHT,
                       rgnCon.left, rgnCon.top );

              /* Require disconnection routine according to 
                 ppxp disconnection method */
              if( DisconnectPPxP() )
	      {
                IsConnect = FALSE;
                ShowXpm( DIS_X, DIS_Y, DIS_WIDTH, DIS_HEIGHT, 40, 50 );
	      }
	    }
	  }
          else if( PtInButton( rgnPrp, e.xbutton.x, e.xbutton.y ) )
          {
            ShowXpm( BTN_PROP_ON_X, BTN_PROP_ON_Y, BUTTON_WIDTH, BUTTON_HEIGHT,
                     rgnPrp.left, rgnPrp.top );
            if( fork() == 0 )
	    {
#ifdef _USE_GTK
              WMPPxPUtilMain( argc, argv );
#else
              execlp( TERMINAL, TERMINAL, "-e", "ppxp", NULL );
#endif
	    }
          }

          break;
        case ButtonRelease:
          if( PtInButton( rgnDis, e.xbutton.x, e.xbutton.y ) )
	  {
            ShowXpm( BTN_DIS_OFF_X, BTN_DIS_OFF_Y, BUTTON_WIDTH, BUTTON_HEIGHT,
                     rgnDis.left, rgnDis.top );
	  }
          else if( PtInButton( rgnPrp, e.xbutton.x, e.xbutton.y ) )
	  {
            ShowXpm( BTN_PROP_OFF_X, BTN_PROP_OFF_Y, BUTTON_WIDTH, BUTTON_HEIGHT,
                     rgnPrp.left, rgnPrp.top );
	  }
          break;
        case MotionNotify:
          break;
        case Expose:
          RedrawWindow();
          break;
        case DestroyNotify:
          if( IsConnect )
	  {
	    PPxPCommandv( ppxpFD, XCMD_QUIT, NULL );
	  }
          XcioClose( ppxpFD );
          XCloseDisplay( display );
          exit( 0 );
          break;
      }
    }

    usleep( 50000L );
  }
}

BOOL ConnectPPxP( int argc, char *argv[] )
{
  if( PPxPCommandv( ppxpFD, XCMD_CONNECT, NULL ) > 0 )
  {
    return TRUE;
  }

  return FALSE;
}

BOOL DisconnectPPxP()
{
  PPxPCommandv( ppxpFD, XCMD_DISCONNECT, NULL );

  return TRUE;
}

void CheckPPxPStat( struct xcio_s *xcio )
{
  int i;
  int input, output;

  if( xcio->type == XCIO_UP_INFO )
  {
    memcpy( &pppinfo, xcio->buf, sizeof( pppInfo ) );

    if( pppinfo.phase < PS_ESTABLISH )
    {
      ShowXpm( DIS_X, DIS_Y, DIS_WIDTH, DIS_HEIGHT, 40, 50 );
    }
    if( pppinfo.phase >= PS_ESTABLISH )
    {
    }
    if( pppinfo.l_stat & LSTAT_PPP )
    {
      ShowRunningTimeInArea( pppinfo.connect );
    }
    if( pppinfo.phase > PS_ESTABLISH )
    {
    }
    if( pppinfo.phase > PS_AUTHENTICATE )
    {
    }

    if( pppinfo.n_stat )
    {
      IsConnect = TRUE;
      ShowXpm( CON_X, CON_Y, CON_WIDTH, CON_HEIGHT, 40, 50 );
      ShowBaudRate( baud_rate );
    }

    input = pppinfo.r.nsize - pppInfo.r.nsize;
    output = pppinfo.s.nsize - pppInfo.s.nsize;

    ShowRSBar( baud_rate, input, output );
  }
}

