/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**********************************************************************

	--- Qt Architect generated file ---

	File: QADescEdit.cpp
	Last generated: Sat Nov 11 16:12:01 2000

 *********************************************************************/

#include "descEdit.h"
#include <qglobal.h>
#include <qwhatsthis.h>

#include "descEditData.cpp"
#include "descEditData.moc.cpp"

DescEdit::DescEdit
(
	QWidget* parent,
	const char* name
)
	:
	DescEditData( parent, name )
{
	desc->setFocus();

	QWhatsThis::add( desc, 
		_("You can type here what you want. This description will "
          "appear every time you select this dictionary.") );
}


DescEdit::~DescEdit()
{
	debug("Destruyendo DescEdit");
}

void DescEdit::setText( QStringList texto ) {
	desc->clear();
	for (unsigned int n=0; n < texto.count(); n++) 
		desc->append( texto[n] );

#if QT_VERSION >= 300
	desc->setCursorPosition(1,1);
#endif
}


QStringList DescEdit::getText() {
	QStringList texto;
	for (int n=0; n < desc->numLines(); n++) {
		texto.append( desc->textLine(n) );
	}
    return texto;
}

#include "descEdit.moc.cpp"

