
#include "wizard_babylon.h"
#include "QBabyDiccionario.h"
#include "intern.h"

#include <qfileinfo.h>


WizardBabylon::WizardBabylon() {
}

WizardBabylon::~WizardBabylon() {
}

bool WizardBabylon::analizeName(const QString & fichero) {
	QFileInfo fi(fichero);
	QString nombre = fi.baseName().upper();

	//qDebug("Nombre: '%s'", nombre.latin1());

	if (nombre.length() != 8) {
		emit message( _("<li>the filename is not 8 characters length.</li>"));
		return false;
	}

	if (nombre.left(5) == "ENGTO") {
		language1="English";

		QString lang= nombre.mid(5);

		if (lang=="SPA") language2="Spanish";
		else
		if (lang=="GER") language2="German";
		else
		if (lang=="ENG") language2="English";
		else
		if (lang=="FRE") language2="French";
		else
		if (lang=="HEB") language2="Hebrew";
		else
		if (lang=="ITA") language2="Italian";
		else
		if (lang=="PTG") language2="Portuguese";
		else
		language2=lang;

		qDebug("Segundo idioma: '%s'", language2.latin1());

		return true;
	}

	return false;
}

DiccionarioBase * WizardBabylon::examine(const QString & fichero) {
	setFile(fichero);

	QString m = 
		QString( 
		_("<qt><b>Trying to find out if file '%1' is a valid babylon dictionary:</b>")
		).arg(fichero);
	emit message(m);
	emit message("<ul>");

	QFileInfo fi(fichero);
	QString extension = fi.extension(TRUE).upper();
	//qDebug("extension= '%s'", extension.latin1());

	if (extension != "DIC") {
		emit message( _("<li>the extension of the file is not .dic. "
                      "Bad signal. Continuing anyway.</li>"));
	} else {
		emit message( _("<li>the extension of the file is .dic. Good.</li>"));
	}

	if (extension == "EXE") {
		emit message( _("<li>the extension of the file is .exe. "
                      "This could be a compressed file, did you "
                      "try to uncompress it with the 'unzip' command? "
                      "Won't continue with the rest of tests.</li>"));
		emit message("</ul>");
		return 0;
	}

	if (!analizeName(fichero)) {
		emit message( _("<li>the filename doesn't match the pattern "
                      "engto???.dic. It seems this isn't a babylon "
                      "dictionary.</li>"));
		//Ahora hay que ver si el fichero es el english.dic
		emit message("</ul>");
		return 0;
	} else {
		emit message( _("<li>the filename <b>does match</b> the pattern engto???. Good.</li>"));
	}

	emit message("</ul></qt>");
	return 0;
}

#include "wizard_babylon.moc.cpp"

