/* wconfig_layout.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef WCONFIG_LAYOUT_HH
#define WCONFIG_LAYOUT_HH

#include "wdefines.h"
#include "wconfig_panel.hh"
#include "wconfig.h"

class WConfig;

class LayoutPanel : public WConfigPanel
{
public:
  LayoutPanel( AWindow &basewin, WConfig &baseconfig );
  ~LayoutPanel();
  int create();
  int saveValues();

  /* gui elements callback */
  void run( Widget *, AGMessage &msg );
  
  typedef struct {
    Button *button;
    int pos;
    int ind;
  } confLayoutEntry_t;
  typedef struct { WConfig::layoutID_t id; int group; } layoutIDGrp_t;
protected:
  bool bv, lvv;
  ChooseButton *cb1, *cb2;
  int history;
  AContainer *ac1;
  AContainer *aclayout;

  std::list<confLayoutEntry_t> entries;

  static int getLayoutID(  bool buttonV, bool listviewV, int pos, layoutIDGrp_t &return_id );
  static int getNrOfLayoutModes();
  static int getNrOfLayoutElements();
  static int getNrOfUniques( bool bv, bool lvv );
  static int getSizeOfGroup( bool bv, bool lvv, int group );
  static std::string getDescrOfLayoutID( WConfig::layoutID_t id );
  int setupLayoutContainer();
  int updateLayoutButtonText();
};
 
#endif
