/* popupwindow.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef POPUPWINDOW_HH
#define POPUPWINDOW_HH

#include "awindow.h"

class PopUpWindow : public AWindow {
public:
    PopUpWindow( AGUIX *parent,
                 int x,
                 int y,
                 int width,
                 int height,
                 int bg,
                 std::string title,
                 int group_id );
    ~PopUpWindow();
    PopUpWindow( const PopUpWindow &other );
    PopUpWindow &operator=( const PopUpWindow &other );
    
    int getGroupID() const;
    void setGroupID( int g );
    void show();
    void hide();
    int create();
private:
    int m_group_id;
    static int group_id_counter;
};

#endif
