/* dndelement.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: dndelement.cc,v 1.7 2001/11/03 17:15:20 ralf Exp $ */

#include "dndelement.h"
#include "aguix.h"
#include "guielement.h"
#include "awindow.h"

DNDElement::DNDElement(AGUIX *parent,GUIElement *el,int x,int y,void *specialinfo)
{
  aguix=parent;
  Display *dsp=aguix->getDisplay();
  int scr=aguix->getScreen();
  Visual *vis=DefaultVisual(dsp,scr);
  unsigned long mask=CWEventMask|CWBackPixel|CWOverrideRedirect|CWSaveUnder;
  XSetWindowAttributes attr;
  attr.event_mask=ExposureMask|ButtonPressMask|ButtonReleaseMask|ButtonMotionMask|PointerMotionHintMask|KeyReleaseMask;
  attr.background_pixel=0;
  attr.override_redirect=true;
  attr.save_under=true;

  int xw,yw,xr,yr;
  Window root,child;
  unsigned int keys_button;
  XQueryPointer(dsp,RootWindow(dsp,scr),&root,&child,&xr,&yr,&xw,&yw,&keys_button);

  win=XCreateWindow(dsp,RootWindow(dsp,scr),xr,yr,1,1,0,aguix->getDepth(),InputOutput,vis,mask,&attr);
  XClearWindow(dsp,win);
  XFlush(dsp);

  AGMessage *agmsg=(AGMessage*)_allocsafe(sizeof(AGMessage));
  agmsg->dnd.element=el;
  agmsg->dnd.specialinfo=specialinfo;
  agmsg->dnd.window=NULL;
  agmsg->dnd.relx=x;
  agmsg->dnd.rely=y;
  agmsg->type=AG_DND_START;
  aguix->putAGMsg(agmsg);
  delx=0;
  dely=0;
}

DNDElement::~DNDElement()
{
  close();
}

void DNDElement::handler()
{
  create();
  bool ende,cancel;
  Message *tmsg;
  int tx,ty;
  int grabbed;
  grabbed=XGrabPointer(aguix->getDisplay(),
                       RootWindow(aguix->getDisplay(),aguix->getScreen()),
		       True,
		       ButtonMotionMask|ButtonReleaseMask|ButtonPressMask,
		       GrabModeAsync,
		       GrabModeAsync,
		       None,
		       None,
		       CurrentTime);
  cancel=false;
  for(ende=false;ende==false;) {
    tmsg=aguix->wait4mess(MES_WAIT,false);
    if(tmsg!=NULL) {
      if((tmsg->type==ButtonRelease)&&(tmsg->button==Button1)) {
        ende=true;
      } else if((tmsg->type==ButtonPress)&&(tmsg->button==Button3)) {
        ende=true;
        cancel=true;
      } else if(tmsg->type==MotionNotify) {
        aguix->queryRootPointer(&tx,&ty);
        XMoveWindow(aguix->getDisplay(),win,delx+tx,dely+ty);
	aguix->Flush();
      } else if(tmsg->type==Expose) {
        if(tmsg->window==win) redraw();
	else {
	  aguix->ExposeHandler(tmsg);
	}
      } else if(tmsg->type==KeyRelease) {
        if(tmsg->key==XK_Escape) {
	  ende=true;
	  cancel=true;
	}
      }
      _freesafe(tmsg);
    }
  }
  if(grabbed==GrabSuccess) {
    XUngrabPointer(aguix->getDisplay(),CurrentTime);
  }
  close();
  int xw,yw,xr,yr;
  Window root,child,rroot;
  unsigned int keys_button;
  Display *dsp=aguix->getDisplay();
  root=RootWindow(dsp,aguix->getScreen());
  for(;;) {
    XQueryPointer(dsp,root,&rroot,&child,&xr,&yr,&xw,&yw,&keys_button);
    if(child==0) break;
    root=child;
  }
  // Fenster finden, dass child enthaelt
  child=root;
  AWindow *awin=aguix->findAWindow(child);
  GUIElement *guiel=NULL;
  if(awin!=NULL) {
    guiel=awin->findGUIElement(child);
    if(guiel!=NULL) XQueryPointer(dsp,guiel->getWindow(),&root,&child,&xr,&yr,&xw,&yw,&keys_button);
  }
  AGMessage *agmsg=(AGMessage*)_allocsafe(sizeof(AGMessage));
  agmsg->dnd.element=guiel;
  agmsg->dnd.window=awin;
  agmsg->dnd.specialinfo=NULL;
  agmsg->dnd.relx=xw;
  agmsg->dnd.rely=yw;
  if(cancel==false) agmsg->type=AG_DND_END;
  else agmsg->type=AG_DND_CANCEL;
  aguix->putAGMsg(agmsg);
}

void DNDElement::redraw()
{
}

void DNDElement::close()
{
  if(win!=0) XDestroyWindow(aguix->getDisplay(),win);
  win=0;
}

void DNDElement::create()
{
  XMapRaised(aguix->getDisplay(),win);
}
