/* solidbutton.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: solidbutton.h,v 1.4 2001/11/03 17:15:55 ralf Exp $ */

#ifndef SOLIDBUTTON_H
#define SOLIDBUTTON_H

#include "aguixdefs.h"
#include "guielement.h"

class SolidButton:public GUIElement {
public:
  SolidButton(class AGUIX *aguix);
  SolidButton(class AGUIX *aguix,int x,int y,int width,
         const char *text,int fg,int bg,bool state);
  SolidButton(class AGUIX *aguix,int x,int y,int width,int height,
         const char *text,int fg,int bg,bool state);
  virtual ~SolidButton();
  const char *getText();
  void setText(const char *);
  void setFG(int);
  int getFG();
  void setBG(int);
  int getBG();
  bool getState();
  void setState(bool);
  virtual void redraw();
  virtual void flush();
  virtual bool handleMessage(XEvent *E,Message *msg);
  int setFont(char*);
  virtual const char *getType();
  virtual bool isType(const char *type);
private:
  char *text;
  int fg;
  int bg;
  int lastbg;
  bool state;
  class AGUIXFont *font;
  static const char *type;
};

#endif
