/* deleteop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: deleteop.cc,v 1.13 2002/03/22 23:12:42 ralf Exp $ */

#include "deleteop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *DeleteOp::name="DeleteOp";

DeleteOp::DeleteOp(Worker *tworker):FunctionProto(tworker)
{
  also_active = false;
}

DeleteOp::~DeleteOp()
{
}

DeleteOp*
DeleteOp::duplicate()
{
  DeleteOp *ta=new DeleteOp(worker);
  ta->also_active = also_active;
  return ta;
}

bool
DeleteOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
DeleteOp::getName()
{
  return name;
}

int
DeleteOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodedelete();
    }
  }
  return 0;
}

const char *
DeleteOp::getDescription()
{
  return catalog.getLocaleCom(25);
}

int
DeleteOp::normalmodedelete()
{
  struct NM_deleteorder delorder;
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  struct NM_specialsource *specialsource=NULL;
  
  if(startlister==NULL) return 1;
  lm1=startlister->getActiveMode();
  if(lm1==NULL) return 1;
  if(lm1->isType("NormalMode")!=true) return 1;
  nm1=(NormalMode*)lm1;
  
  if(am->mode==am->AM_MODE_NORMAL) {
    if ( also_active == true ) {
      delorder.source=delorder.NM_ALLENTRIES;
    } else {
      delorder.source=delorder.NM_ONLYSELECTED;
    }

    delorder.delmode=delorder.NM_DELMODE_NORMAL;
    delorder.dirdel=delorder.NM_DIRDELETE_NORMAL;
    delorder.dowin=new DeleteOpWin(worker->getAGUIX());
    nm1->deletef(&delorder);
    delete delorder.dowin;
    if(delorder.source==delorder.NM_SPECIAL) {
      if(specialsource!=NULL) _freesafe(specialsource);
      delete delorder.sources;
    }
  }
  return 0;
}

int DeleteOp::configure()
{
  int w,h,tw,ty,tx;
  int t1,t2;
  ChooseButton *cb;
  AGUIX *aguix=worker->getAGUIX();
  AWindow *win=new AWindow(aguix);
  char *tstr;

  w=h=10;
  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(25))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(25));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);
  
  ty=5;
  tx=5;

  cb=(ChooseButton*)win->add(new ChooseButton(aguix,tx,ty,20,20,(also_active==true)?1:0,
                                              catalog.getLocale(153),LABEL_RIGHT,1,0));
  ty+=cb->getHeight()+5;
  tw=cb->getWidth()+10;
  if(tw>w) w=tw;
  
  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMinSize(w,h);
  win->setMaxSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    also_active = ( cb->getState() == 1 ) ? true : false;
  }
  win->close();
  delete win;
  return (ende==1)?0:1;
}

bool DeleteOp::save(Datei *fh)
{
  fh->putInt( Datei::getUCharSize() );

  fh->putUChar( ( also_active == true ) ? 1 : 0 );
  return true;
}

int DeleteOp::load(Datei *fh)
{
  int chunksize = fh->getInt();
  if ( chunksize >= Datei::getUCharSize() ) {
    if ( fh->getUChar() == 1 ) also_active = true;
    else also_active = false;

    chunksize -= Datei::getUCharSize();
  }
  while ( chunksize > 0 ) {
    fh->getUChar();
    chunksize--;
  }
  return 0;
}

/*********************
 * Class DeleteOpWin *
 *********************/

DeleteOpWin::DeleteOpWin(AGUIX*taguix)
{
  this->aguix=taguix;
  source=dupstring("");
  deleted_files=0;
  files=0;
  deleted_dirs=0;
  dirs=0;
  
  window=NULL;
  melw = 0;
  filenamespace = 0;
}

DeleteOpWin::~DeleteOpWin()
{
  if(source!=NULL) _freesafe(source);
  if(window!=NULL) close();
}

int
DeleteOpWin::open()
{
  int w,h;
  int tx,ty;
  Text *ttext;

  close();
  window=new AWindow(aguix);
  w=400;
  h=10;
  window->create(NULL,10,10,w,h,0,catalog.getLocaleCom(25));
  tx=5;
  ty=5;
  sourcetext=(Text*)window->add(new Text(aguix,tx,ty,"",1));
  ty+=sourcetext->getHeight()+5;
  bb1=(BevelBox*)window->add(new BevelBox(aguix,tx,ty,w-2*tx,2,0));
  ty+=bb1->getHeight()+5;

  ttext=(Text*)window->add(new Text(aguix,tx,ty,catalog.getLocale(142),1));
  tx+=ttext->getWidth()+5;
  files2gotext=(Text*)window->add(new Text(aguix,tx,ty,"",1));
  tx=5;
  ty+=ttext->getHeight()+5;
  ttext=(Text*)window->add(new Text(aguix,tx,ty,catalog.getLocale(143),1));
  tx+=ttext->getWidth()+5;
  dirs2gotext=(Text*)window->add(new Text(aguix,tx,ty,"",1));
  tx=5;
  ty+=ttext->getHeight()+5;

  gsb=(SolidButton*)window->add(new SolidButton(aguix,tx+1,ty+1,w-2*(tx+1),"",2,3,0));
  bb2=(BevelBox*)window->add(new BevelBox(aguix,tx,ty,w-2*tx,gsb->getHeight()+2,1));
  gsb->toFront();
  sbw=gsb->getWidth();
  ty+=bb2->getHeight()+5;

  bb3=(BevelBox*)window->add(new BevelBox(aguix,tx,ty,w-2*tx,2,0));
  ty+=bb3->getHeight()+5;
  cb=(Button*)window->add(new Button(aguix,tx,ty,
                                     (strlen(catalog.getLocale(8))+2)*aguix->getCharWidth(),
                                     catalog.getLocale(8),1,0,0));
  cb->move(w/2-cb->getWidth()/2,cb->getY());
  ty+=cb->getHeight()+5;
  h=ty;
  window->resize(w,h);
  window->setMinSize(w,h);
  //window->setMaxSize(w,h);
  window->centerScreen();
  window->show();

  filenamespace = ( w - window->getBorderWidth() - sourcetext->getX() ) / aguix->getCharWidth();
  filenamespace -= strlen(catalog.getLocale(141)) - 2;

  return 0;
}

void
DeleteOpWin::close()
{
  if(window!=NULL) {
    window->close();
    delete window;
  }
  window=NULL;
}

void
DeleteOpWin::set_files_to_delete(long nfiles)
{
  if(nfiles>0) files=nfiles;
  else files=0;
  update_files2gotext=true;
}

void
DeleteOpWin::set_dirs_to_delete(long ndirs)
{
  if(ndirs>0) dirs=ndirs;
  else dirs=0;
  update_dirs2gotext=true;
}

void
DeleteOpWin::dir_finished()
{
  deleted_dirs++;
  update_dirs2gotext=true;
}

void
DeleteOpWin::file_finished()
{
  // inc counter
  deleted_files++;
  update_files2gotext=true;
}

void
DeleteOpWin::setfilename(char *name)
{
  if(source!=NULL) _freesafe(source);
  if(name!=NULL)
    source=dupstring(name);
  else
    source=dupstring("");
  update_sourcetext=true;
}

int
DeleteOpWin::redraw()
{ /* this functions will redraw the window AND process events for this window
   * returns values:
   *  0 for regular exit
   *  1 when clicked Cancel-Button or closed window
   *  other not implemented */
  int returnvalue=0;
  char tstr[1024],*tstr2, *tstr3;
  float rate;
  bool updategsb=false;
  int tm;
  bool doresize = false;

  aguix->Flush();
  if(update_sourcetext==true) {
    if ( source != NULL ) {
      tstr3 = Datei::shrinkFilename( source, filenamespace );
      if ( tstr3 == NULL)
        tstr3 = dupstring( source );
      tstr2 = (char*)_allocsafe( strlen( catalog.getLocale( 141 ) ) + strlen( tstr3 ) + 1 );
      sprintf( tstr2, catalog.getLocale( 141 ), tstr3 );
      _freesafe( tstr3 );
    } else {
      tstr2 = (char*)_allocsafe( strlen( catalog.getLocale( 141 ) ) + 1 );
      sprintf( tstr2, catalog.getLocale( 141 ), "" );
    }
    sourcetext->setText(tstr2);
    _freesafe(tstr2);
    /* no need for explicit redraw */
    update_sourcetext=false;
  }
  if(update_files2gotext==true) {
    sprintf(tstr,"%ld",files-deleted_files);
    files2gotext->setText(tstr);

    tm = files2gotext->getX() + files2gotext->getWidth() + window->getBorderWidth();
    if ( tm > melw ) {
      melw = tm;
      doresize = true;
    }

    update_files2gotext=false;
    updategsb=true;
  }
  if(update_dirs2gotext==true) {
    sprintf(tstr,"%ld",dirs-deleted_dirs);
    dirs2gotext->setText(tstr);

    tm = dirs2gotext->getX() + dirs2gotext->getWidth() + window->getBorderWidth();
    if ( tm > melw ) {
      melw = tm;
      doresize = true;
    }

    update_dirs2gotext=false;
    updategsb=true;
  }
  if(updategsb==true) {
    if((files+dirs)>0)
      rate=(float)(deleted_files+deleted_dirs)/(float)(files+dirs);
    else
      rate=0.0;
    if  ( rate < 0.01 )
      rate = 0.0;
    sprintf(tstr,"%.4g %%",rate*100);
    gsb->setText(tstr);
    gsb->resize( w_max( (int)( sbw * rate ), 2 ), gsb->getHeight() );
  }
  
  if ( doresize == true ) {
    // only resize if window is smaller
    if ( window->getWidth() < melw ) {
      window->resize ( melw,  window->getHeight() );
    }
    // anyway the min size has changed so set it again
    window->setMinSize( melw, bb3->getY() + bb3->getHeight() + 5 +
                              cb->getHeight() + window->getBorderWidth() );
  }
  
  /* update complete
     now check for X-messages */
  AGMessage *msg;
  do {
    msg=aguix->GetMessage(NULL);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==window->getWindow()) returnvalue=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==cb) returnvalue=1;
          break;
        case AG_SIZECHANGED:
          bb1->resize( msg->size.neww - 2 * window->getBorderWidth(), bb1->getHeight() );
          sbw = bb1->getWidth() - 2;
          bb2->resize( msg->size.neww - 2 * window->getBorderWidth(), bb2->getHeight() );
          bb3->resize( msg->size.neww - 2 * window->getBorderWidth(), bb3->getHeight() );
          cb->move( msg->size.neww / 2 - cb->getWidth() / 2,
                    msg->size.newh - window->getBorderWidth() - cb->getHeight() );

          filenamespace = ( msg->size.neww - window->getBorderWidth() - sourcetext->getX() ) / aguix->getCharWidth();
          filenamespace -= strlen(catalog.getLocale(141)) - 2;

          // read copyop.cc:CopyOpWin::redraw for more comments
          break;
      }
      aguix->ReplyMessage(msg);
    }
  } while(msg!=NULL);
  return returnvalue;
}

void
DeleteOpWin::setmessage(char *msg)
{
  if(msg!=NULL) sourcetext->setText(msg);
  else sourcetext->setText("");
}

void
DeleteOpWin::dec_file_counter(unsigned long f)
{
  files-=f;
  update_files2gotext=true;
}

void
DeleteOpWin::dec_dir_counter(unsigned long d)
{
  dirs-=d;
  update_dirs2gotext=true;
}

