/* dirsizeop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: dirsizeop.cc,v 1.6 2002/03/16 23:28:08 ralf Exp $ */

#include "dirsizeop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *DirSizeOp::name="DirSizeOp";

DirSizeOp::DirSizeOp(Worker *tworker):FunctionProto(tworker)
{
}

DirSizeOp::~DirSizeOp()
{
}

DirSizeOp*
DirSizeOp::duplicate()
{
  DirSizeOp *ta=new DirSizeOp(worker);
  return ta;
}

bool
DirSizeOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
DirSizeOp::getName()
{
  return name;
}

int
DirSizeOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodedirsize();
    }
  }
  return 0;
}

const char *
DirSizeOp::getDescription()
{
  return catalog.getLocaleCom(30);
}

int
DirSizeOp::normalmodedirsize()
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  struct NM_dirsizeorder dsorder;
  struct NM_specialsource *specialsource=NULL;
  
  if(startlister==NULL) return 1;
  lm1=startlister->getActiveMode();
  if(lm1==NULL) return 1;
  if(lm1->isType("NormalMode")!=true) return 1;
  nm1=(NormalMode*)lm1;
  
  if(am->mode==am->AM_MODE_ONLYACTIVE)
    dsorder.source=dsorder.NM_ONLYACTIVE;
  else if(am->mode==am->AM_MODE_DNDACTION) {
    // insert DND-element into list
    dsorder.source=dsorder.NM_SPECIAL;
    dsorder.sources=new List;
    specialsource=(struct NM_specialsource*)_allocsafe(sizeof(struct NM_specialsource));
    specialsource->entry=NULL;
    specialsource->row=-1;
    //TODO: specialsource nach am besetzen (je nachdem wir ich das realisiere)
    dsorder.sources->addElement(specialsource);
  } else if(am->mode==am->AM_MODE_SPECIAL) {
    dsorder.source=dsorder.NM_SPECIAL;
    dsorder.sources=new List;
    specialsource=(struct NM_specialsource*)_allocsafe(sizeof(struct NM_specialsource));
    specialsource->entry=(FileEntry*)am->extraInfo;
    specialsource->row=-1;
    dsorder.sources->addElement(specialsource);
  } else
    dsorder.source=dsorder.NM_ALLENTRIES;

  nm1->dirsize(&dsorder);
  if(dsorder.source==dsorder.NM_SPECIAL) {
    if(specialsource!=NULL) _freesafe(specialsource);
    delete dsorder.sources;
  }

  return 0;
}

