/* setfilterop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: setfilterop.cc,v 1.6 2001/11/03 17:10:41 ralf Exp $ */

#include "setfilterop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *SetFilterOp::name="SetFilterOp";

SetFilterOp::SetFilterOp(Worker *tworker):FunctionProto(tworker)
{
  filtermode=INCLUDE_FILTER;
  request_flags=false;
  filter=dupstring("");
}

SetFilterOp::~SetFilterOp()
{
  _freesafe(filter);
}

SetFilterOp*
SetFilterOp::duplicate()
{
  SetFilterOp *ta=new SetFilterOp(worker);
  ta->filtermode=filtermode;
  ta->request_flags=request_flags;
  _freesafe(ta->filter);
  ta->filter=dupstring(filter);
  return ta;
}

bool
SetFilterOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
SetFilterOp::getName()
{
  return name;
}

int
SetFilterOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      endlister=worker->getOtherLister(startlister);
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodesf();
    }
  }
  return 0;
}

bool
SetFilterOp::save(Datei *fh)
{
  int size=2*Datei::getUCharSize()+Datei::getIntSize();
  size+=strlen(filter);
  fh->putInt(size);

  fh->putUChar((request_flags==true)?1:0);
  switch(filtermode) {
    case EXCLUDE_FILTER:
      fh->putUChar(1);
      break;
    case UNSET_FILTER:
      fh->putUChar(2);
      break;
    case UNSET_ALL:
      fh->putUChar(3);
      break;
    default:
      fh->putUChar(0);
  }
  fh->putInt(strlen(filter));
  fh->putString(filter);
  return true;
}

int
SetFilterOp::load(Datei *fh)
{
  int chunksize=fh->getInt();
  int cs=Datei::getUCharSize(),
      is=Datei::getIntSize(),
      len;
  unsigned char c1;
  if(chunksize>=(2*cs+is)) {
    if(fh->getUChar()==1) request_flags=true; else request_flags=false;
    c1=fh->getUChar();
    switch(c1) {
      case 1:
        filtermode=EXCLUDE_FILTER;
        break;
      case 2:
        filtermode=UNSET_FILTER;
        break;
      case 3:
        filtermode=UNSET_ALL;
        break;
      default:
        filtermode=INCLUDE_FILTER;
    }
    chunksize-=2*cs;

    len=fh->getInt();
    chunksize-=is;
    _freesafe(filter);
    filter=fh->getString(len);
    if(filter==NULL) filter=dupstring("");
    chunksize-=len;
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return true;
}

const char *
SetFilterOp::getDescription()
{
  return catalog.getLocaleCom(41);
}

int
SetFilterOp::normalmodesf()
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  bool cont=true;
  
  if(am->mode!=am->AM_MODE_DNDACTION) {
    if(startlister==NULL) return 1;
    lm1=startlister->getActiveMode();
    if(lm1==NULL) return 1;
    if(lm1->isType("NormalMode")!=true) return 1;
    nm1=(NormalMode*)lm1;
  }
  
  if(request_flags==true) {
    if(doconfigure(1)!=0) cont=false;
  } else {
    // set values in t* variables
    tfiltermode=filtermode;
    tfilter=dupstring(filter);
  }
  
  if(cont==true) {
    if(tfiltermode==UNSET_ALL) {
      nm1->unsetAllFilters();
    } else {
      if(strlen(tfilter)>0) {
        switch(tfiltermode) {
          case INCLUDE_FILTER:
            nm1->setFilter(tfilter,NormalMode::NM_FILTER_INCLUDE);
            break;
          case EXCLUDE_FILTER:
            nm1->setFilter(tfilter,NormalMode::NM_FILTER_EXCLUDE);
            break;
          case UNSET_FILTER:
            nm1->setFilter(tfilter,NormalMode::NM_FILTER_UNSET);
            break;
          default:
            break;
        }
      }
    }
    _freesafe(tfilter);
  }
  return 0;
}

int
SetFilterOp::doconfigure(int mode)
{
  AGUIX *aguix=worker->getAGUIX();
  Button *okb,*cb;
  StringGadget *sg;
  AWindow *win;
  ChooseButton *rfcb=NULL;
  CycleButton *fmcyb;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  int i;
  
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);
  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(getDescription())+1);
  sprintf(tstr,catalog.getLocale(293),getDescription());
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(133),1));
  x+=ttext->getWidth()+5;
  fmcyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  fmcyb->addOption(catalog.getLocale(191));
  fmcyb->addOption(catalog.getLocale(192));
  fmcyb->addOption(catalog.getLocale(193));
  fmcyb->addOption(catalog.getLocale(194));
  fmcyb->resize(fmcyb->getMaxSize(),fmcyb->getHeight());
  switch(filtermode) {
    case EXCLUDE_FILTER:
      fmcyb->setOption(1);
      break;
    case UNSET_FILTER:
      fmcyb->setOption(2);
      break;
    case UNSET_ALL:
      fmcyb->setOption(3);
      break;
    default:
      fmcyb->setOption(0);
  }

  y+=fmcyb->getHeight()+5;
  tw=x+fmcyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(93),1));
  x+=ttext->getWidth()+5;
  tw=w-x-5;
  if(tw<50) tw=50;
  sg=(StringGadget*)win->add(new StringGadget(aguix,x,y,tw,filter,0));
  y+=sg->getHeight()+5;
  tw=sg->getWidth()+5+x;
  if(tw>w) w=tw;
  x=5;

  if(mode==0) {
    rfcb=(ChooseButton*)win->add(new ChooseButton(aguix,x,y,20,20,(request_flags==true)?1:0,
                                                  catalog.getLocale(294),LABEL_RIGHT,1,0));
    y+=rfcb->getHeight()+5;
    tw=rfcb->getWidth()+10;
    if(tw>w) w=tw;
  }

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  sg->resize(w-5-sg->getX(),sg->getHeight());

  h=y;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
        case AG_KEYRELEASED:
          if(win->isParent(msg->key.window,false)==true) {
            switch(msg->key.key) {
              case XK_1:
                i=fmcyb->getSelectedOption()+1;
                if(i>=4) i=0;
                fmcyb->setOption(i);
                break;
              case XK_2:
                sg->activate();
                break;
              case XK_3:
                if(rfcb!=NULL) rfcb->setState((rfcb->getState()==1)?0:1);
                break;
              case XK_Return:
                endmode=0;
                break;
              case XK_Escape:
                endmode=1;
                break;
            }
          }
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    if(mode==1) {
      // store in t-variables
      tfilter=dupstring(sg->getText());
      switch(fmcyb->getSelectedOption()) {
        case 1:
          tfiltermode=EXCLUDE_FILTER;
          break;
        case 2:
          tfiltermode=UNSET_FILTER;
          break;
        case 3:
          tfiltermode=UNSET_ALL;
          break;
        default:
          tfiltermode=INCLUDE_FILTER;
          break;
      }
    } else {
      // store in normal variables
      request_flags=(rfcb->getState()==1)?true:false;
      _freesafe(filter);
      filter=dupstring(sg->getText());
      switch(fmcyb->getSelectedOption()) {
        case 1:
          filtermode=EXCLUDE_FILTER;
          break;
        case 2:
          filtermode=UNSET_FILTER;
          break;
        case 3:
          filtermode=UNSET_ALL;
          break;
        default:
          filtermode=INCLUDE_FILTER;
          break;
      }
    }
  }
  
  win->close();
  delete win;

  return endmode;
}

int
SetFilterOp::configure()
{
  return doconfigure(0);
}

