/* setfilterop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: setfilterop.h,v 1.3 2001/11/03 17:10:42 ralf Exp $ */

#ifndef SETFILTEROP_H
#define SETFILTEROP_H

#include "wdefines.h"
#include "functionproto.h"

class Worker;

class SetFilterOp:public FunctionProto
{
public:
  SetFilterOp(Worker*);
  virtual ~SetFilterOp();
  virtual SetFilterOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual bool save(Datei*);
  virtual int load(Datei*);
  virtual const char *getDescription();
  virtual int configure();

  int doconfigure(int mode);
  typedef enum {INCLUDE_FILTER=0,EXCLUDE_FILTER,UNSET_FILTER,UNSET_ALL} setfilterop_mode;
protected:
  static const char *name;
  // Infos to save
  bool request_flags;
  char *filter;
  setfilterop_mode filtermode;
  
  // temp variables
  Lister *startlister,*endlister;
  
  // temp values filled when request_flags==true
  char *tfilter;
  setfilterop_mode tfiltermode;

  int normalmodesf();
};

#endif
