// $Id: CallbacksFileOperations.cpp,v 1.7 2003/02/15 21:04:46 mrq Exp $
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string>
#include <iostream>

#include <gtk/gtk.h>

#include "support.h"
#include "interface.h"

#include "../Main.h"
#include "../Application.h"

#include "CallbacksFile.h"
#include "UIGtk.h"

#include <Ark/ArkFileSys.h>

static const char FileDialogDirectory[] = "{world}/";

// Enable save commands
void EnableSaveCommands(int s)
{
  GtkWidget* SaveButton = lookup_widget(g_MainWindow, "Save");
  GtkWidget* SaveMenuItem = lookup_widget(g_MainWindow, "SaveMenuItem");

  gtk_widget_set_sensitive(SaveButton, s);
  gtk_widget_set_sensitive(SaveMenuItem, s);
}


// Open file dialog
void OpenFileDialog() 
{
  GtkWidget* dialog = create_OpenFileDialog();
  assert(dialog);

  gtk_file_selection_set_filename( GTK_FILE_SELECTION(dialog), 
      Ark::Sys()->FS()->GetFileName(FileDialogDirectory).c_str());

  // Shows dialog
  gtk_widget_show_all(dialog);
}

// Opens a file
void OpenFile(const char* name) 
{
   if (name)
   {
      Ark::String sname = name;
      sname += "/world.cfg";
      
      if (Ark::Sys()->FS()->IsFile(sname))
	 g_Application->Load(name); 
      else
      {
	 GtkWidget* wid = create_Error_Dialog();
	 GtkWidget* mess = lookup_widget(wid, "ErrorMessage");
	 gtk_label_set_text(GTK_LABEL(mess), "You havent selected a world "
			    "directory. To select one, you have to go in "
			    "the directory, then click OK without selecting "
			    "any file.");
	 gtk_widget_show_all(wid);
      }
  }
}


// Internal function that calls the Write method of the global world
static void SaveThis()
{
  g_Application->Write();
}

// Saves a file
void SaveFileDialog() 
{
  if (!(g_Application->CanSave() && g_Application->IsChanged())) return;

  if (g_Application->GetFileName() == std::string())
  {
    SaveAsFileDialog();
  }
  else
  {
    SaveThis();
  }
  
}

// Saves to a new file
void SaveAsFileDialog() 
{
  if (!g_Application->CanSave()) return;
  
  GtkWidget* dialog = create_SaveFileDialog();
  assert(dialog);

  gtk_file_selection_set_filename( GTK_FILE_SELECTION(dialog), 
      Ark::Sys()->FS()->GetFileName(FileDialogDirectory).c_str());

  // Shows dialog
  gtk_widget_show_all(dialog);
}


// Saves the file under given name
void SaveFile(const char* name)
{
  g_Application->SetFileName(name);
  SaveThis();
}


// Quits the application
void QuitApplicationDialog()
{

  // hum, something to change ?
  if (g_Application->CanSave() && g_Application->IsChanged())
  {
    // Dialog to ask for save/save as/discard/cancel
    GtkWidget* dialog = create_Quit_Dialog();
    assert(dialog);

    gtk_widget_show_all(dialog);
  }
  else 
  {
    // Nothing to do, bye !
    gtk_main_quit();
  }
  
}

// Creates a new file
void NewFileDialog()
{
  GtkWidget* dialog = create_Properties_Dialog();
  assert(dialog);

  gtk_widget_show_all(dialog);
  
}

void NewFile(const char* name, const char* dir, int w, int h)
{
  std::string NewName = name;
  std::string NewDirectory = dir;
  
  // XXX Show error messages
  if ((NewName == std::string()) || (NewName == "")) return;
  if ((NewDirectory == std::string()) || (NewDirectory == "")) return;
  if ((w <= 0) || (h <= 0)) return;

  std::string Directory(FileDialogDirectory);
  Directory += NewDirectory;
  
  g_Application->NewWorld(Directory, NewName, w, h);
}

