///////////////////////////////////////////////////////////////////////////////
//
// Wall Paper Changer for GNOME
// Copyright (C) 2000-2001  Kenichi Shibata <ken_s@cat.zero.ad.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// Please read the file "COPYING" for more information.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////
//
// ken_s@cat.zero.ad.jp
// http://www3.might.co.jp/~sibata/top/
//
///////////////////////////////////////////////////////////////////////////////

#define __INTERFACE_H
#include "global.h"

////////////////////////////////////////////////////////
//                                                    //
//  Create Main dialog                                //
//                                                    //
//    Parameter                                       //
//       void                                         //
//    Return                                          //
//       GtkWidget *                                  //
//                                                    //
////////////////////////////////////////////////////////
GtkWidget* create_main_dialog (void)
{
  GtkWidget *main_dialog;
  GtkWidget *hpaned1;
  GtkWidget *scrolledwindow1;
  GtkWidget *image_file_clist;
  GtkWidget *wall_paper_files_label;
  GtkWidget *vbox3;
  GtkWidget *wpac_notebook;
  GtkWidget *vbox1;
  GtkWidget *mode_label;
  GSList *change_mode_group = NULL;
  GtkWidget *mode_sequential_radiobutton;
  GtkWidget *mode_random_radiobutton;
  GtkWidget *hseparator3;
  GtkWidget *Timeliness_label;
  GSList *change_Timeliness_group = NULL;
  GtkWidget *timeliness_manual_radio;
  GtkWidget *hbox10;
  GtkWidget *timeliness_auto_radio;
  GtkWidget *minute_entry;
  GtkWidget *minute_label;
  GtkWidget *hseparator1;
  GtkWidget *wall_paper_label;
  GtkWidget *hbox2;
  GtkWidget *add_button;
  GtkWidget *del_button;
  GtkWidget *hbox11;
  GtkWidget *all_select_button;
  GtkWidget *all_unselect_button;
  GtkWidget *common_label;
  GtkWidget *vbox2;
  GtkWidget *layout_label;
  GSList *layout_group = NULL;
  GtkWidget *layout_center_radiobutton;
  GtkWidget *layout_full_radiobutton;
  GtkWidget *layout_tile_radiobutton;
  GtkWidget *hseparator4;
  GtkWidget *effect_label;
  GtkWidget *dither_checkbutton;
  GtkWidget *gray_checkbutton;
  GtkWidget *effect_table;
  GtkWidget *rotate_hscale;
  GtkWidget *rotate_label;
  GtkWidget *gamma_hscale;
  GtkWidget *brighten_hscale;
  GtkWidget *rotate_entry;
  GtkWidget *gamma_entry;
  GtkWidget *brighten_entry;
  GtkWidget *brighten_label;
  GtkWidget *gamma_label;
  GtkWidget *hseparator9;
  GtkWidget *zoom_label;
  GtkWidget *xy_checkbutton;
  GtkWidget *table2;
  GtkWidget *xzoom_entry;
  GtkWidget *yzoom_entry;
  GtkWidget *xzoom_hscale;
  GtkWidget *yzoom_hscale;
  GtkWidget *xzoom_label;
  GtkWidget *yzoom_label;
  GtkWidget *hseparator10;
  GtkWidget *bgcolor_label;
  GtkWidget *bg_colorselection;
  GtkWidget *hseparator11;
  GtkWidget *hbox12;
  GtkWidget *test_button;
  GtkWidget *Individual_label;
  GtkWidget *hbox3;
  GtkWidget *save_button;
  GtkWidget *ok_button;
  GtkWidget *cancel_button;
  GtkWidget *vseparator1;
  GtkWidget *about_button;
  GtkWidget *exit_button;
  GtkWidget *option_entry;
  GtkWidget *hseparator12;
  GtkWidget *option_label;

  main_dialog = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_widget_set_name (main_dialog, "main_dialog");
  gtk_object_set_data (GTK_OBJECT (main_dialog), "main_dialog", main_dialog);
  gtk_window_set_title (GTK_WINDOW (main_dialog), _("Wall Paper Auto Changer"));
  gtk_window_set_default_size (GTK_WINDOW (main_dialog), 600, 610);

  hpaned1 = gtk_hpaned_new ();
  gtk_widget_set_name (hpaned1, "hpaned1");
  gtk_widget_ref (hpaned1);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hpaned1", hpaned1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hpaned1);
  gtk_container_add (GTK_CONTAINER (main_dialog), hpaned1);
  gtk_paned_set_position (GTK_PANED (hpaned1), 200);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_paned_pack1 (GTK_PANED (hpaned1), scrolledwindow1, FALSE, TRUE);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  image_file_clist = gtk_clist_new (1);
  gtk_widget_set_name (image_file_clist, "image_file_clist");
  gtk_widget_ref (image_file_clist);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "image_file_clist", image_file_clist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (image_file_clist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), image_file_clist);
  gtk_clist_set_column_width (GTK_CLIST (image_file_clist), 0, 80);
  gtk_clist_set_selection_mode (GTK_CLIST (image_file_clist), GTK_SELECTION_EXTENDED);
  gtk_clist_column_titles_show (GTK_CLIST (image_file_clist));

  wall_paper_files_label = gtk_label_new (_("Wall Paper Files"));
  gtk_widget_set_name (wall_paper_files_label, "wall_paper_files_label");
  gtk_widget_ref (wall_paper_files_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "wall_paper_files_label", wall_paper_files_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (wall_paper_files_label);
  gtk_clist_set_column_widget (GTK_CLIST (image_file_clist), 0, wall_paper_files_label);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox3, "vbox3");
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_paned_pack2 (GTK_PANED (hpaned1), vbox3, TRUE, TRUE);

  wpac_notebook = gtk_notebook_new ();
  gtk_widget_set_name (wpac_notebook, "wpac_notebook");
  gtk_widget_ref (wpac_notebook);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "wpac_notebook", wpac_notebook,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (wpac_notebook);
  gtk_box_pack_start (GTK_BOX (vbox3), wpac_notebook, TRUE, TRUE, 0);

  vbox1 = gtk_vbox_new (TRUE, 0);
  gtk_widget_set_name (vbox1, "vbox1");
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (wpac_notebook), vbox1);

  mode_label = gtk_label_new (_("Mode"));
  gtk_widget_set_name (mode_label, "mode_label");
  gtk_widget_ref (mode_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "mode_label", mode_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (mode_label);
  gtk_box_pack_start (GTK_BOX (vbox1), mode_label, FALSE, FALSE, 0);

  mode_sequential_radiobutton = gtk_radio_button_new_with_label (change_mode_group, _("Sequential"));
  change_mode_group = gtk_radio_button_group (GTK_RADIO_BUTTON (mode_sequential_radiobutton));
  gtk_widget_set_name (mode_sequential_radiobutton, "mode_sequential_radiobutton");
  gtk_widget_ref (mode_sequential_radiobutton);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "mode_sequential_radiobutton", mode_sequential_radiobutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (mode_sequential_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox1), mode_sequential_radiobutton, FALSE, FALSE, 0);

  mode_random_radiobutton = gtk_radio_button_new_with_label (change_mode_group, _("Random"));
  change_mode_group = gtk_radio_button_group (GTK_RADIO_BUTTON (mode_random_radiobutton));
  gtk_widget_set_name (mode_random_radiobutton, "mode_random_radiobutton");
  gtk_widget_ref (mode_random_radiobutton);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "mode_random_radiobutton", mode_random_radiobutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (mode_random_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox1), mode_random_radiobutton, FALSE, FALSE, 0);

  hseparator3 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator3, "hseparator3");
  gtk_widget_ref (hseparator3);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hseparator3", hseparator3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator3);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator3, TRUE, TRUE, 0);

  Timeliness_label = gtk_label_new (_("Timeliness"));
  gtk_widget_set_name (Timeliness_label, "Timeliness_label");
  gtk_widget_ref (Timeliness_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "Timeliness_label", Timeliness_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (Timeliness_label);
  gtk_box_pack_start (GTK_BOX (vbox1), Timeliness_label, FALSE, FALSE, 0);

  timeliness_manual_radio = gtk_radio_button_new_with_label (change_Timeliness_group, _("manual"));
  change_Timeliness_group = gtk_radio_button_group (GTK_RADIO_BUTTON (timeliness_manual_radio));
  gtk_widget_set_name (timeliness_manual_radio, "timeliness_manual_radio");
  gtk_widget_ref (timeliness_manual_radio);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "timeliness_manual_radio", timeliness_manual_radio,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (timeliness_manual_radio);
  gtk_box_pack_start (GTK_BOX (vbox1), timeliness_manual_radio, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (timeliness_manual_radio), TRUE);

  hbox10 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox10, "hbox10");
  gtk_widget_ref (hbox10);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hbox10", hbox10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox10);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox10, FALSE, FALSE, 0);

  timeliness_auto_radio = gtk_radio_button_new_with_label (change_Timeliness_group, _("auto"));
  change_Timeliness_group = gtk_radio_button_group (GTK_RADIO_BUTTON (timeliness_auto_radio));
  gtk_widget_set_name (timeliness_auto_radio, "timeliness_auto_radio");
  gtk_widget_ref (timeliness_auto_radio);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "timeliness_auto_radio", timeliness_auto_radio,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (timeliness_auto_radio);
  gtk_box_pack_start (GTK_BOX (hbox10), timeliness_auto_radio, TRUE, TRUE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (timeliness_auto_radio), TRUE);

  minute_entry = gtk_entry_new_with_max_length (3);
  gtk_widget_set_name (minute_entry, "minute_entry");
  gtk_widget_ref (minute_entry);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "minute_entry", minute_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (minute_entry);
  gtk_box_pack_start (GTK_BOX (hbox10), minute_entry, FALSE, FALSE, 0);
  gtk_widget_set_usize (minute_entry, 50, -2);

  minute_label = gtk_label_new (_("minute"));
  gtk_widget_set_name (minute_label, "minute_label");
  gtk_widget_ref (minute_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "minute_label", minute_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (minute_label);
  gtk_box_pack_start (GTK_BOX (hbox10), minute_label, FALSE, FALSE, 7);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator1, "hseparator1");
  gtk_widget_ref (hseparator1);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hseparator1", hseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, TRUE, TRUE, 0);

  wall_paper_label = gtk_label_new (_("Wall Paper File"));
  gtk_widget_set_name (wall_paper_label, "wall_paper_label");
  gtk_widget_ref (wall_paper_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "wall_paper_label", wall_paper_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (wall_paper_label);
  gtk_box_pack_start (GTK_BOX (vbox1), wall_paper_label, FALSE, FALSE, 0);

  hbox2 = gtk_hbox_new (TRUE, 0);
  gtk_widget_set_name (hbox2, "hbox2");
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, FALSE, 0);

  add_button = gtk_button_new_with_label (_("Addition"));
  gtk_widget_set_name (add_button, "add_button");
  gtk_widget_ref (add_button);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "add_button", add_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (add_button);
  gtk_box_pack_start (GTK_BOX (hbox2), add_button, FALSE, TRUE, 5);

  del_button = gtk_button_new_with_label (_("Deletes"));
  gtk_widget_set_name (del_button, "del_button");
  gtk_widget_ref (del_button);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "del_button", del_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (del_button);
  gtk_box_pack_start (GTK_BOX (hbox2), del_button, FALSE, TRUE, 5);

  hbox11 = gtk_hbox_new (TRUE, 0);
  gtk_widget_set_name (hbox11, "hbox11");
  gtk_widget_ref (hbox11);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hbox11", hbox11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox11);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox11, FALSE, FALSE, 0);

  all_select_button = gtk_button_new_with_label (_("All Select"));
  gtk_widget_set_name (all_select_button, "all_select_button");
  gtk_widget_ref (all_select_button);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "all_select_button", all_select_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (all_select_button);
  gtk_box_pack_start (GTK_BOX (hbox11), all_select_button, FALSE, TRUE, 5);

  all_unselect_button = gtk_button_new_with_label (_("All Unselect"));
  gtk_widget_set_name (all_unselect_button, "all_unselect_button");
  gtk_widget_ref (all_unselect_button);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "all_unselect_button", all_unselect_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (all_unselect_button);
  gtk_box_pack_start (GTK_BOX (hbox11), all_unselect_button, FALSE, TRUE, 5);

  common_label = gtk_label_new (_("Common attachment"));
  gtk_widget_set_name (common_label, "common_label");
  gtk_widget_ref (common_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "common_label", common_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (common_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (wpac_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (wpac_notebook), 0), common_label);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox2, "vbox2");
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (wpac_notebook), vbox2);

  layout_label = gtk_label_new (_("Layout"));
  gtk_widget_set_name (layout_label, "layout_label");
  gtk_widget_ref (layout_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "layout_label", layout_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (layout_label);
  gtk_box_pack_start (GTK_BOX (vbox2), layout_label, FALSE, FALSE, 0);

  layout_center_radiobutton = gtk_radio_button_new_with_label (layout_group, _("Center"));
  layout_group = gtk_radio_button_group (GTK_RADIO_BUTTON (layout_center_radiobutton));
  gtk_widget_set_name (layout_center_radiobutton, "layout_center_radiobutton");
  gtk_widget_ref (layout_center_radiobutton);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "layout_center_radiobutton", layout_center_radiobutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (layout_center_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox2), layout_center_radiobutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (layout_center_radiobutton), TRUE);

  layout_full_radiobutton = gtk_radio_button_new_with_label (layout_group, _("Full Screen"));
  layout_group = gtk_radio_button_group (GTK_RADIO_BUTTON (layout_full_radiobutton));
  gtk_widget_set_name (layout_full_radiobutton, "layout_full_radiobutton");
  gtk_widget_ref (layout_full_radiobutton);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "layout_full_radiobutton", layout_full_radiobutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (layout_full_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox2), layout_full_radiobutton, FALSE, FALSE, 0);

  layout_tile_radiobutton = gtk_radio_button_new_with_label (layout_group, _("Tile"));
  layout_group = gtk_radio_button_group (GTK_RADIO_BUTTON (layout_tile_radiobutton));
  gtk_widget_set_name (layout_tile_radiobutton, "layout_tile_radiobutton");
  gtk_widget_ref (layout_tile_radiobutton);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "layout_tile_radiobutton", layout_tile_radiobutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (layout_tile_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox2), layout_tile_radiobutton, FALSE, FALSE, 0);

  hseparator4 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator4, "hseparator4");
  gtk_widget_ref (hseparator4);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hseparator4", hseparator4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator4);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator4, TRUE, TRUE, 0);

  effect_label = gtk_label_new (_("Effect"));
  gtk_widget_set_name (effect_label, "effect_label");
  gtk_widget_ref (effect_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "effect_label", effect_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (effect_label);
  gtk_box_pack_start (GTK_BOX (vbox2), effect_label, FALSE, FALSE, 0);

  dither_checkbutton = gtk_check_button_new_with_label (_("Dither"));
  gtk_widget_set_name (dither_checkbutton, "dither_checkbutton");
  gtk_widget_ref (dither_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "dither_checkbutton", dither_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dither_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox2), dither_checkbutton, FALSE, FALSE, 0);

  gray_checkbutton = gtk_check_button_new_with_label (_("Gray"));
  gtk_widget_set_name (gray_checkbutton, "gray_checkbutton");
  gtk_widget_ref (gray_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "gray_checkbutton", gray_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (gray_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox2), gray_checkbutton, FALSE, FALSE, 0);

  effect_table = gtk_table_new (3, 3, FALSE);
  gtk_widget_set_name (effect_table, "effect_table");
  gtk_widget_ref (effect_table);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "effect_table", effect_table,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (effect_table);
  gtk_box_pack_start (GTK_BOX (vbox2), effect_table, FALSE, FALSE, 0);

  rotate_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (1, 0, 4, 1, 1, 1)));
  gtk_widget_set_name (rotate_hscale, "rotate_hscale");
  gtk_widget_ref (rotate_hscale);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "rotate_hscale", rotate_hscale,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (rotate_hscale);
  gtk_table_attach (GTK_TABLE (effect_table), rotate_hscale, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scale_set_draw_value (GTK_SCALE (rotate_hscale), FALSE);
  gtk_scale_set_value_pos (GTK_SCALE (rotate_hscale), GTK_POS_LEFT);
  gtk_scale_set_digits (GTK_SCALE (rotate_hscale), 0);

  rotate_label = gtk_label_new (_("Rotate"));
  gtk_widget_set_name (rotate_label, "rotate_label");
  gtk_widget_ref (rotate_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "rotate_label", rotate_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (rotate_label);
  gtk_table_attach (GTK_TABLE (effect_table), rotate_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 0);

  gamma_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (10, 0, 101, 1, 1, 1)));
  gtk_widget_set_name (gamma_hscale, "gamma_hscale");
  gtk_widget_ref (gamma_hscale);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "gamma_hscale", gamma_hscale,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (gamma_hscale);
  gtk_table_attach (GTK_TABLE (effect_table), gamma_hscale, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scale_set_draw_value (GTK_SCALE (gamma_hscale), FALSE);
  gtk_scale_set_digits (GTK_SCALE (gamma_hscale), 0);

  brighten_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (100, 0, 301, 1, 1, 1)));
  gtk_widget_set_name (brighten_hscale, "brighten_hscale");
  gtk_widget_ref (brighten_hscale);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "brighten_hscale", brighten_hscale,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (brighten_hscale);
  gtk_table_attach (GTK_TABLE (effect_table), brighten_hscale, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scale_set_draw_value (GTK_SCALE (brighten_hscale), FALSE);
  gtk_scale_set_digits (GTK_SCALE (brighten_hscale), 0);

  rotate_entry = gtk_entry_new_with_max_length (5);
  gtk_widget_set_name (rotate_entry, "rotate_entry");
  gtk_widget_ref (rotate_entry);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "rotate_entry", rotate_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (rotate_entry);
  gtk_table_attach (GTK_TABLE (effect_table), rotate_entry, 2, 3, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_widget_set_usize (rotate_entry, 50, -2);
  gtk_entry_set_editable (GTK_ENTRY (rotate_entry), FALSE);

  gamma_entry = gtk_entry_new_with_max_length (5);
  gtk_widget_set_name (gamma_entry, "gamma_entry");
  gtk_widget_ref (gamma_entry);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "gamma_entry", gamma_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (gamma_entry);
  gtk_table_attach (GTK_TABLE (effect_table), gamma_entry, 2, 3, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_widget_set_usize (gamma_entry, 50, -2);
  gtk_entry_set_editable (GTK_ENTRY (gamma_entry), FALSE);

  brighten_entry = gtk_entry_new_with_max_length (5);
  gtk_widget_set_name (brighten_entry, "brighten_entry");
  gtk_widget_ref (brighten_entry);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "brighten_entry", brighten_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (brighten_entry);
  gtk_table_attach (GTK_TABLE (effect_table), brighten_entry, 2, 3, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_widget_set_usize (brighten_entry, 50, -2);
  gtk_entry_set_editable (GTK_ENTRY (brighten_entry), FALSE);

  brighten_label = gtk_label_new (_("Brighten"));
  gtk_widget_set_name (brighten_label, "brighten_label");
  gtk_widget_ref (brighten_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "brighten_label", brighten_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (brighten_label);
  gtk_table_attach (GTK_TABLE (effect_table), brighten_label, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 0);

  gamma_label = gtk_label_new (_("Gamma"));
  gtk_widget_set_name (gamma_label, "gamma_label");
  gtk_widget_ref (gamma_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "gamma_label", gamma_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (gamma_label);
  gtk_table_attach (GTK_TABLE (effect_table), gamma_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 0);

  hseparator9 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator9, "hseparator9");
  gtk_widget_ref (hseparator9);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hseparator9", hseparator9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator9);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator9, TRUE, TRUE, 0);

  zoom_label = gtk_label_new (_("Zoom"));
  gtk_widget_set_name (zoom_label, "zoom_label");
  gtk_widget_ref (zoom_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "zoom_label", zoom_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (zoom_label);
  gtk_box_pack_start (GTK_BOX (vbox2), zoom_label, FALSE, FALSE, 0);

  xy_checkbutton = gtk_check_button_new_with_label (_("X = Y"));
  gtk_widget_set_name (xy_checkbutton, "xy_checkbutton");
  gtk_widget_ref (xy_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "xy_checkbutton", xy_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (xy_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox2), xy_checkbutton, FALSE, FALSE, 0);

  table2 = gtk_table_new (2, 3, FALSE);
  gtk_widget_set_name (table2, "table2");
  gtk_widget_ref (table2);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "table2", table2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table2);
  gtk_box_pack_start (GTK_BOX (vbox2), table2, TRUE, TRUE, 0);

  xzoom_entry = gtk_entry_new_with_max_length (5);
  gtk_widget_set_name (xzoom_entry, "xzoom_entry");
  gtk_widget_ref (xzoom_entry);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "xzoom_entry", xzoom_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (xzoom_entry);
  gtk_table_attach (GTK_TABLE (table2), xzoom_entry, 2, 3, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_widget_set_usize (xzoom_entry, 50, -2);
  gtk_entry_set_editable (GTK_ENTRY (xzoom_entry), FALSE);

  yzoom_entry = gtk_entry_new_with_max_length (5);
  gtk_widget_set_name (yzoom_entry, "yzoom_entry");
  gtk_widget_ref (yzoom_entry);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "yzoom_entry", yzoom_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (yzoom_entry);
  gtk_table_attach (GTK_TABLE (table2), yzoom_entry, 2, 3, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_widget_set_usize (yzoom_entry, 50, -2);
  gtk_entry_set_editable (GTK_ENTRY (yzoom_entry), FALSE);

  xzoom_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (100, 1, 201, 1, 1, 1)));
  gtk_widget_set_name (xzoom_hscale, "xzoom_hscale");
  gtk_widget_ref (xzoom_hscale);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "xzoom_hscale", xzoom_hscale,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (xzoom_hscale);
  gtk_table_attach (GTK_TABLE (table2), xzoom_hscale, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scale_set_draw_value (GTK_SCALE (xzoom_hscale), FALSE);
  gtk_scale_set_digits (GTK_SCALE (xzoom_hscale), 0);

  yzoom_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (100, 1, 201, 1, 1, 1)));
  gtk_widget_set_name (yzoom_hscale, "yzoom_hscale");
  gtk_widget_ref (yzoom_hscale);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "yzoom_hscale", yzoom_hscale,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (yzoom_hscale);
  gtk_table_attach (GTK_TABLE (table2), yzoom_hscale, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scale_set_draw_value (GTK_SCALE (yzoom_hscale), FALSE);
  gtk_scale_set_digits (GTK_SCALE (yzoom_hscale), 0);

  xzoom_label = gtk_label_new (_("X"));
  gtk_widget_set_name (xzoom_label, "xzoom_label");
  gtk_widget_ref (xzoom_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "xzoom_label", xzoom_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (xzoom_label);
  gtk_table_attach (GTK_TABLE (table2), xzoom_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 0);

  yzoom_label = gtk_label_new (_("Y"));
  gtk_widget_set_name (yzoom_label, "yzoom_label");
  gtk_widget_ref (yzoom_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "yzoom_label", yzoom_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (yzoom_label);
  gtk_table_attach (GTK_TABLE (table2), yzoom_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 0);

  hseparator10 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator10, "hseparator10");
  gtk_widget_ref (hseparator10);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hseparator10", hseparator10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator10);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator10, TRUE, TRUE, 0);

  bgcolor_label = gtk_label_new (_("Background Color"));
  gtk_widget_set_name (bgcolor_label, "bgcolor_label");
  gtk_widget_ref (bgcolor_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "bgcolor_label", bgcolor_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (bgcolor_label);
  gtk_box_pack_start (GTK_BOX (vbox2), bgcolor_label, FALSE, FALSE, 0);

  bg_colorselection = gtk_color_selection_new ();
  gtk_widget_set_name (bg_colorselection, "bg_colorselection");
  gtk_widget_ref (bg_colorselection);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "bg_colorselection", bg_colorselection,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (bg_colorselection);
  gtk_box_pack_start (GTK_BOX (vbox2), bg_colorselection, TRUE, TRUE, 0);

  hseparator11 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator11, "hseparator11");
  gtk_widget_ref (hseparator11);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hseparator11", hseparator11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator11);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator11, TRUE, TRUE, 0);


  option_label = gtk_label_new (_("\"xloadimage\" command line option"));
  gtk_widget_set_name (option_label, "option_label");
  gtk_widget_ref (option_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "option_label", option_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (option_label);
  gtk_box_pack_start (GTK_BOX (vbox2), option_label, FALSE, FALSE, 0);


  option_entry = gtk_entry_new ();
  gtk_widget_set_name (option_entry, "option_entry");
  gtk_widget_ref (option_entry);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "option_entry", option_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (option_entry);
  gtk_box_pack_start (GTK_BOX (vbox2), option_entry, TRUE, TRUE, 5);





  hseparator12 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator12, "hseparator12");
  gtk_widget_ref (hseparator12);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hseparator12", hseparator12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator12);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator12, TRUE, TRUE, 0);


  hbox12 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox12, "hbox12");
  gtk_widget_ref (hbox12);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hbox12", hbox12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox12);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox12, FALSE, FALSE, 6);

  test_button = gtk_button_new_with_label (_("Test"));
  gtk_widget_set_name (test_button, "test_button");
  gtk_widget_ref (test_button);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "test_button", test_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (test_button);
  gtk_box_pack_start (GTK_BOX (hbox12), test_button, TRUE, TRUE, 5);



  Individual_label = gtk_label_new (_("Individual attachment"));
  gtk_widget_set_name (Individual_label, "Individual_label");
  gtk_widget_ref (Individual_label);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "Individual_label", Individual_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (Individual_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (wpac_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (wpac_notebook), 1), Individual_label);

  hbox3 = gtk_hbox_new (TRUE, 0);
  gtk_widget_set_name (hbox3, "hbox3");
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox3, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox3), 7);

  save_button = gtk_button_new_with_label (_("Save"));
  gtk_widget_set_name (save_button, "save_button");
  gtk_widget_ref (save_button);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "save_button", save_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (save_button);
  gtk_box_pack_start (GTK_BOX (hbox3), save_button, FALSE, TRUE, 5);

  ok_button = gtk_button_new_with_label (_("OK"));
  gtk_widget_set_name (ok_button, "ok_button");
  gtk_widget_ref (ok_button);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "ok_button", ok_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ok_button);
  gtk_box_pack_start (GTK_BOX (hbox3), ok_button, FALSE, TRUE, 5);

  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_set_name (cancel_button, "cancel_button");
  gtk_widget_ref (cancel_button);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "cancel_button", cancel_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cancel_button);
  gtk_box_pack_start (GTK_BOX (hbox3), cancel_button, FALSE, TRUE, 5);

  vseparator1 = gtk_vseparator_new ();
  gtk_widget_set_name (vseparator1, "vseparator1");
  gtk_widget_ref (vseparator1);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "vseparator1", vseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vseparator1);
  gtk_box_pack_start (GTK_BOX (hbox3), vseparator1, FALSE, FALSE, 0);

  about_button = gtk_button_new_with_label (_("About"));
  gtk_widget_set_name (about_button, "about_button");
  gtk_widget_ref (about_button);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "about_button", about_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (about_button);
  gtk_box_pack_start (GTK_BOX (hbox3), about_button, FALSE, TRUE, 5);

  exit_button = gtk_button_new_with_label (_("Exit"));
  gtk_widget_set_name (exit_button, "exit_button");
  gtk_widget_ref (exit_button);
  gtk_object_set_data_full (GTK_OBJECT (main_dialog), "exit_button", exit_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (exit_button);
  gtk_box_pack_start (GTK_BOX (hbox3), exit_button, FALSE, TRUE, 5);

  gtk_signal_connect (GTK_OBJECT (main_dialog), "delete_event",
                      GTK_SIGNAL_FUNC (on_main_dialog_delete_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (main_dialog), "destroy_event",
                      GTK_SIGNAL_FUNC (on_main_dialog_destroy_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (image_file_clist), "select_row",
                      GTK_SIGNAL_FUNC (on_image_file_clist_select_row),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (image_file_clist), "unselect_row",
                      GTK_SIGNAL_FUNC (on_image_file_clist_unselect_row),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (wpac_notebook), "switch_page",
                      GTK_SIGNAL_FUNC (on_wpac_notebook_switch_page),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (mode_sequential_radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_mode_sequential_radiobutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (mode_random_radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_mode_random_radiobutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (timeliness_manual_radio), "toggled",
                      GTK_SIGNAL_FUNC (on_timeliness_manual_radio_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (timeliness_auto_radio), "toggled",
                      GTK_SIGNAL_FUNC (on_timeliness_auto_radio_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (minute_entry), "insert_text",
                      GTK_SIGNAL_FUNC (on_minute_entry_insert_text),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (minute_entry), "changed",
                      GTK_SIGNAL_FUNC (on_minute_entry_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
                      GTK_SIGNAL_FUNC (on_add_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (del_button), "clicked",
                      GTK_SIGNAL_FUNC (on_del_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (all_select_button), "clicked",
                      GTK_SIGNAL_FUNC (on_all_select_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (all_unselect_button), "clicked",
                      GTK_SIGNAL_FUNC (on_all_unselect_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (layout_center_radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_layout_center_radiobutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (layout_full_radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_layout_full_radiobutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (layout_tile_radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_layout_tile_radiobutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dither_checkbutton), "toggled",
                      GTK_SIGNAL_FUNC (on_dither_checkbutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (gray_checkbutton), "toggled",
                      GTK_SIGNAL_FUNC (on_gray_checkbutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (xy_checkbutton), "toggled",
                      GTK_SIGNAL_FUNC (on_xy_checkbutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (bg_colorselection), "color_changed",
                      GTK_SIGNAL_FUNC (on_bg_colorselection_color_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (option_entry), "changed",
                      GTK_SIGNAL_FUNC (on_option_entry_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (test_button), "clicked",
                      GTK_SIGNAL_FUNC (on_test_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (save_button), "clicked",
                      GTK_SIGNAL_FUNC (on_save_button_clicked),
                      (gpointer)FALSE);
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (on_ok_button_clicked),
                      (gpointer)TRUE);
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
                      GTK_SIGNAL_FUNC (on_cancel_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (about_button), "clicked",
                      GTK_SIGNAL_FUNC (on_about_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (exit_button), "clicked",
                      GTK_SIGNAL_FUNC (on_exit_button_clicked),
                      NULL);

  return main_dialog;
}

////////////////////////////////////////////////////////
//                                                    //
//  Create File selection dialog                      //
//                                                    //
//    Parameter                                       //
//       void                                         //
//    Return                                          //
//       GtkWidget *                                  //
//                                                    //
////////////////////////////////////////////////////////
GtkWidget* create_fileselection (void)
{
  GtkWidget *fileselection;
  GtkWidget *fileselect_ok_button;
  GtkWidget *fileselect_cancel_button;

  fileselection = gtk_file_selection_new (_("File Selection"));
  gtk_widget_set_name (fileselection, "fileselection");
  gtk_object_set_data (GTK_OBJECT (fileselection), "fileselection", fileselection);
  gtk_container_set_border_width (GTK_CONTAINER (fileselection), 10);
  GTK_WINDOW (fileselection)->type = GTK_WINDOW_DIALOG;

  fileselect_ok_button = GTK_FILE_SELECTION (fileselection)->ok_button;
  gtk_widget_set_name (fileselect_ok_button, "fileselect_ok_button");
  gtk_object_set_data (GTK_OBJECT (fileselection), "fileselect_ok_button", fileselect_ok_button);
  gtk_widget_show (fileselect_ok_button);
  GTK_WIDGET_SET_FLAGS (fileselect_ok_button, GTK_CAN_DEFAULT);

  fileselect_cancel_button = GTK_FILE_SELECTION (fileselection)->cancel_button;
  gtk_widget_set_name (fileselect_cancel_button, "fileselect_cancel_button");
  gtk_object_set_data (GTK_OBJECT (fileselection), "fileselect_cancel_button", fileselect_cancel_button);
  gtk_widget_show (fileselect_cancel_button);
  GTK_WIDGET_SET_FLAGS (fileselect_cancel_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (fileselection), "delete_event",
                      GTK_SIGNAL_FUNC (on_fileselection_delete_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (fileselection), "destroy_event",
                      GTK_SIGNAL_FUNC (on_fileselection_destroy_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (fileselect_ok_button), "clicked",
                      GTK_SIGNAL_FUNC (on_fileselect_ok_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (fileselect_cancel_button), "clicked",
                      GTK_SIGNAL_FUNC (on_fileselect_cancel_button_clicked),
                      NULL);

  return fileselection;
}

////////////////////////////////////////////////////////
//                                                    //
//  Create About dealog                               //
//                                                    //
//    Parameter                                       //
//       void                                         //
//    Return                                          //
//       GtkWidget *                                  //
//                                                    //
////////////////////////////////////////////////////////
GtkWidget* create_about_dialog (void)
{
  GtkWidget *dialog1;
  GtkWidget *dialog_vbox1;
  GtkWidget *notebook1;
  GtkWidget *scrolledwindow1;
  GtkWidget *text1;
  GtkWidget *label14;
  GtkWidget *scrolledwindow2;
  GtkWidget *text2;
  GtkWidget *label15;
  GtkWidget *dialog_action_area1;
  GtkWidget *info_ok_button;
  gchar      buff[256];

  dialog1 = gtk_dialog_new ();
  gtk_widget_set_name (dialog1, "dialog1");
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog1", dialog1);
  gtk_window_set_title (GTK_WINDOW (dialog1), _("Infomation - Wall Paper Auto Changer"));
  gtk_window_set_default_size (GTK_WINDOW (dialog1), 460, 370);
  gtk_window_set_policy (GTK_WINDOW (dialog1), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (dialog1)->vbox;
  gtk_widget_set_name (dialog_vbox1, "dialog_vbox1");
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  notebook1 = gtk_notebook_new ();
  gtk_widget_set_name (notebook1, "notebook1");
  gtk_widget_ref (notebook1);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "notebook1", notebook1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (notebook1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), notebook1, TRUE, TRUE, 0);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (notebook1), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text1 = gtk_text_new (NULL, NULL);
  gtk_widget_set_name (text1, "text1");
  gtk_widget_ref (text1);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "text1", text1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (text1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);
  sprintf(buff, _("\n <<Wall Paper Auto Changer  Version %s>>\n\n Copyright 2000-2001 by Kenichi Shibata\n\n Author: Kenichi Shibata <ken_s@cat.zero.ad.jp>\n\n http://www3.might.co.jp/~sibata/top/\n"), VERSION);
  gtk_text_insert (GTK_TEXT (text1), NULL, NULL, NULL, buff, strlen(buff));

  label14 = gtk_label_new (_("About Wall Paper Auto Changer"));
  gtk_widget_set_name (label14, "label14");
  gtk_widget_ref (label14);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "label14", label14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label14);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label14);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow2, "scrolledwindow2");
  gtk_widget_ref (scrolledwindow2);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "scrolledwindow2", scrolledwindow2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow2);
  gtk_container_add (GTK_CONTAINER (notebook1), scrolledwindow2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text2 = gtk_text_new (NULL, NULL);
  gtk_widget_set_name (text2, "text2");
  gtk_widget_ref (text2);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "text2", text2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (text2);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), text2);
  gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL,
                   _("\t\t    GNU GENERAL PUBLIC LICENSE\n\t\t       Version 2, June 1991\n\n Copyright (C) 1989, 1991 Free Software Foundation, Inc.\n     59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n Everyone is permitted to copy and distribute verbatim copies\n of this license document, but changing it is not allowed.\n\n\t\t\t    Preamble\n\n  The licenses for most software are designed to take away your\nfreedom to share and change it.  By contrast, the GNU General Public\nLicense is intended to guarantee your freedom to share and change free\nsoftware--to make sure the software is free for all its users.  This\nGeneral Public License applies to most of the Free Software\nFoundation's software and to any other program whose authors commit to\nusing it.  (Some other Free Software Foundation software is covered by\nthe GNU Library General Public License instead.)  You can apply it to\nyour programs, too.\n\n  When we speak of free software, we are referring to freedom, not\nprice.  Our General Public Licenses are designed to make sure that you\nhave the freedom to distribute copies of free software (and charge for\nthis service if you wish), that you receive source code or can get it\nif you want it, that you can change the software or use pieces of it\nin new free programs; and that you know you can do these things.\n\n  To protect your rights, we need to make restrictions that forbid\nanyone to deny you these rights or to ask you to surrender the rights.\nThese restrictions translate to certain responsibilities for you if you\ndistribute copies of the software, or if you modify it.\n\n  For example, if you distribute copies of such a program, whether\ngratis or for a fee, you must give the recipients all the rights that\nyou have.  You must make sure that they, too, receive or can get the\nsource code.  And you must show them these terms so they know their\nrights.\n\n  We protect your rights with two steps: (1) copyright the software, and\n(2) offer you this license which gives you legal permission to copy,\ndistribute and/or modify the software.\n\n  Also, for each author's protection and ours, we want to make certain\nthat everyone understands that there is no warranty for this free\nsoftware.  If the software is modified by someone else and passed on, we\nwant its recipients to know that what they have is not the original, so\nthat any problems introduced by others will not reflect on the original\nauthors' reputations.\n\n  Finally, any free program is threatened constantly by software\npatents.  We wish to avoid the danger that redistributors of a free\nprogram will individually obtain patent licenses, in effect making the\nprogram proprietary.  To prevent this, we have made it clear that any\npatent must be licensed for everyone's free use or not licensed at all.\n\n  The precise terms and conditions for copying, distribution and\nmodification follow.\n\14\n\t\t    GNU GENERAL PUBLIC LICENSE\n   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n\n  0. This License applies to any program or other work which contains\na notice placed by the copyright holder saying it may be distributed\nunder the terms of this General Public License.  The \"Program\", below,\nrefers to any such program or work, and a \"work based on the Program\"\nmeans either the Program or any derivative work under copyright law:\nthat is to say, a work containing the Program or a portion of it,\neither verbatim or with modifications and/or translated into another\nlanguage.  (Hereinafter, translation is included without limitation in\nthe term \"modification\".)  Each licensee is addressed as \"you\".\n\nActivities other than copying, distribution and modification are not\ncovered by this License; they are outside its scope.  The act of\nrunning the Program is not restricted, and the output from the Program\nis covered only if its contents constitute a work based on the\nProgram (independent of having been made by running the Program).\nWhether that is true depends on what the Program does.\n\n  1. You may copy and distribute verbatim copies of the Program's\nsource code as you receive it, in any medium, provided that you\nconspicuously and appropriately publish on each copy an appropriate\ncopyright notice and disclaimer of warranty; keep intact all the\nnotices that refer to this License and to the absence of any warranty;\nand give any other recipients of the Program a copy of this License\nalong with the Program.\n\nYou may charge a fee for the physical act of transferring a copy, and\nyou may at your option offer warranty protection in exchange for a fee.\n\n  2. You may modify your copy or copies of the Program or any portion\nof it, thus forming a work based on the Program, and copy and\ndistribute such modifications or work under the terms of Section 1\nabove, provided that you also meet all of these conditions:\n\n    a) You must cause the modified files to carry prominent notices\n    stating that you changed the files and the date of any change.\n\n    b) You must cause any work that you distribute or publish, that in\n    whole or in part contains or is derived from the Program or any\n    part thereof, to be licensed as a whole at no charge to all third\n    parties under the terms of this License.\n\n    c) If the modified program normally reads commands interactively\n    when run, you must cause it, when started running for such\n    interactive use in the most ordinary way, to print or display an\n    announcement including an appropriate copyright notice and a\n    notice that there is no warranty (or else, saying that you provide\n    a warranty) and that users may redistribute the program under\n    these conditions, and telling the user how to view a copy of this\n    License.  (Exception: if the Program itself is interactive but\n    does not normally print such an announcement, your work based on\n    the Program is not required to print an announcement.)\n\14\nThese requirements apply to the modified work as a whole.  If\nidentifiable sections of that work are not derived from the Program,\nand can be reasonably considered independent and separate works in\nthemselves, then this License, and its terms, do not apply to those\nsections when you distribute them as separate works.  But when you\ndistribute the same sections as part of a whole which is a work based\non the Program, the distribution of the whole must be on the terms of\nthis License, whose permissions for other licensees extend to the\nentire whole, and thus to each and every part regardless of who wrote it.\n\nThus, it is not the intent of this section to claim rights or contest\nyour rights to work written entirely by you; rather, the intent is to\nexercise the right to control the distribution of derivative or\ncollective works based on the Program.\n\nIn addition, mere aggregation of another work not based on the Program\nwith the Program (or with a work based on the Program) on a volume of\na storage or distribution medium does not bring the other work under\nthe scope of this License.\n\n  3. You may copy and distribute the Program (or a work based on it,\nunder Section 2) in object code or executable form under the terms of\nSections 1 and 2 above provided that you also do one of the following:\n\n    a) Accompany it with the complete corresponding machine-readable\n    source code, which must be distributed under the terms of Sections\n    1 and 2 above on a medium customarily used for software interchange; or,\n\n    b) Accompany it with a written offer, valid for at least three\n    years, to give any third party, for a charge no more than your\n    cost of physically performing source distribution, a complete\n    machine-readable copy of the corresponding source code, to be\n    distributed under the terms of Sections 1 and 2 above on a medium\n    customarily used for software interchange; or,\n\n    c) Accompany it with the information you received as to the offer\n    to distribute corresponding source code.  (This alternative is\n    allowed only for noncommercial distribution and only if you\n    received the program in object code or executable form with such\n    an offer, in accord with Subsection b above.)\n\nThe source code for a work means the preferred form of the work for\nmaking modifications to it.  For an executable work, complete source\ncode means all the source code for all modules it contains, plus any\nassociated interface definition files, plus the scripts used to\ncontrol compilation and installation of the executable.  However, as a\nspecial exception, the source code distributed need not include\nanything that is normally distributed (in either source or binary\nform) with the major components (compiler, kernel, and so on) of the\noperating system on which the executable runs, unless that component\nitself accompanies the executable.\n\nIf distribution of executable or object code is made by offering\naccess to copy from a designated place, then offering equivalent\naccess to copy the source code from the same place counts as\ndistribution of the source code, even though third parties are not\ncompelled to copy the source along with the object code.\n\14\n  4. You may not copy, modify, sublicense, or distribute the Program\nexcept as expressly provided under this License.  Any attempt\notherwise to copy, modify, sublicense or distribute the Program is\nvoid, and will automatically terminate your rights under this License.\nHowever, parties who have received copies, or rights, from you under\nthis License will not have their licenses terminated so long as such\nparties remain in full compliance.\n\n  5. You are not required to accept this License, since you have not\nsigned it.  However, nothing else grants you permission to modify or\ndistribute the Program or its derivative works.  These actions are\nprohibited by law if you do not accept this License.  Therefore, by\nmodifying or distributing the Program (or any work based on the\nProgram), you indicate your acceptance of this License to do so, and\nall its terms and conditions for copying, distributing or modifying\nthe Program or works based on it.\n\n  6. Each time you redistribute the Program (or any work based on the\nProgram), the recipient automatically receives a license from the\noriginal licensor to copy, distribute or modify the Program subject to\nthese terms and conditions.  You may not impose any further\nrestrictions on the recipients' exercise of the rights granted herein.\nYou are not responsible for enforcing compliance by third parties to\nthis License.\n\n  7. If, as a consequence of a court judgment or allegation of patent\ninfringement or for any other reason (not limited to patent issues),\nconditions are imposed on you (whether by court order, agreement or\notherwise) that contradict the conditions of this License, they do not\nexcuse you from the conditions of this License.  If you cannot\ndistribute so as to satisfy simultaneously your obligations under this\nLicense and any other pertinent obligations, then as a consequence you\nmay not distribute the Program at all.  For example, if a patent\nlicense would not permit royalty-free redistribution of the Program by\nall those who receive copies directly or indirectly through you, then\nthe only way you could satisfy both it and this License would be to\nrefrain entirely from distribution of the Program.\n\nIf any portion of this section is held invalid or unenforceable under\nany particular circumstance, the balance of the section is intended to\napply and the section as a whole is intended to apply in other\ncircumstances.\n\nIt is not the purpose of this section to induce you to infringe any\npatents or other property right claims or to contest validity of any\nsuch claims; this section has the sole purpose of protecting the\nintegrity of the free software distribution system, which is\nimplemented by public license practices.  Many people have made\ngenerous contributions to the wide range of software distributed\nthrough that system in reliance on consistent application of that\nsystem; it is up to the author/donor to decide if he or she is willing\nto distribute software through any other system and a licensee cannot\nimpose that choice.\n\nThis section is intended to make thoroughly clear what is believed to\nbe a consequence of the rest of this License.\n\14\n  8. If the distribution and/or use of the Program is restricted in\ncertain countries either by patents or by copyrighted interfaces, the\noriginal copyright holder who places the Program under this License\nmay add an explicit geographical distribution limitation excluding\nthose countries, so that distribution is permitted only in or among\ncountries not thus excluded.  In such case, this License incorporates\nthe limitation as if written in the body of this License.\n\n  9. The Free Software Foundation may publish revised and/or new versions\nof the General Public License from time to time.  Such new versions will\nbe similar in spirit to the present version, but may differ in detail to\naddress new problems or concerns.\n\nEach version is given a distinguishing version number.  If the Program\nspecifies a version number of this License which applies to it and \"any\nlater version\", you have the option of following the terms and conditions\neither of that version or of any later version published by the Free\nSoftware Foundation.  If the Program does not specify a version number of\nthis License, you may choose any version ever published by the Free Software\nFoundation.\n\n  10. If you wish to incorporate parts of the Program into other free\nprograms whose distribution conditions are different, write to the author\nto ask for permission.  For software which is copyrighted by the Free\nSoftware Foundation, write to the Free Software Foundation; we sometimes\nmake exceptions for this.  Our decision will be guided by the two goals\nof preserving the free status of all derivatives of our free software and\nof promoting the sharing and reuse of software generally.\n\n\t\t\t    NO WARRANTY\n\n  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\nFOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN\nOTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\nPROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\nOR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\nMERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS\nTO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE\nPROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\nREPAIR OR CORRECTION.\n\n  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\nWILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\nREDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\nINCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\nOUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\nTO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\nYOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\nPROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\nPOSSIBILITY OF SUCH DAMAGES.\n\n\t\t     END OF TERMS AND CONDITIONS\n\14\n\t    How to Apply These Terms to Your New Programs\n\n  If you develop a new program, and you want it to be of the greatest\npossible use to the public, the best way to achieve this is to make it\nfree software which everyone can redistribute and change under these terms.\n\n  To do so, attach the following notices to the program.  It is safest\nto attach them to the start of each source file to most effectively\nconvey the exclusion of warranty; and each file should have at least\nthe \"copyright\" line and a pointer to where the full notice is found.\n\n    <one line to give the program's name and a brief idea of what it does.>\n    Copyright (C) <year>  <name of author>\n\n    This program is free software; you can redistribute it and/or modify\n    it under the terms of the GNU General Public License as published by\n    the Free Software Foundation; either version 2 of the License, or\n    (at your option) any later version.\n\n    This program is distributed in the hope that it will be useful,\n    but WITHOUT ANY WARRANTY; without even the implied warranty of\n    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n    GNU General Public License for more details.\n\n    You should have received a copy of the GNU General Public License\n    along with this program; if not, write to the Free Software\n    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n\n\nAlso add information on how to contact you by electronic and paper mail.\n\nIf the program is interactive, make it output a short notice like this\nwhen it starts in an interactive mode:\n\n    Gnomovision version 69, Copyright (C) year  name of author\n    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.\n    This is free software, and you are welcome to redistribute it\n    under certain conditions; type `show c' for details.\n\nThe hypothetical commands `show w' and `show c' should show the appropriate\nparts of the General Public License.  Of course, the commands you use may\nbe called something other than `show w' and `show c'; they could even be\nmouse-clicks or menu items--whatever suits your program.\n\nYou should also get your employer (if you work as a programmer) or your\nschool, if any, to sign a \"copyright disclaimer\" for the program, if\nnecessary.  Here is a sample; alter the names:\n\n  Yoyodyne, Inc., hereby disclaims all copyright interest in the program\n  `Gnomovision' (which makes passes at compilers) written by James Hacker.\n\n  <signature of Ty Coon>, 1 April 1989\n  Ty Coon, President of Vice\n\nThis General Public License does not permit incorporating your program into\nproprietary programs.  If your program is a subroutine library, you may\nconsider it more useful to permit linking proprietary applications with the\nlibrary.  If this is what you want to do, use the GNU Library General\nPublic License instead of this License.\n"), 17992);

  label15 = gtk_label_new (_("License"));
  gtk_widget_set_name (label15, "label15");
  gtk_widget_ref (label15);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "label15", label15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label15);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label15);

  dialog_action_area1 = GTK_DIALOG (dialog1)->action_area;
  gtk_widget_set_name (dialog_action_area1, "dialog_action_area1");
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  info_ok_button = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
  gtk_widget_set_name (info_ok_button, "info_ok_button");
  gtk_widget_ref (info_ok_button);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "info_ok_button", info_ok_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_ok_button);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), info_ok_button, FALSE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (dialog1), "destroy",
                      GTK_SIGNAL_FUNC (on_about_dialog_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dialog1), "delete_event",
                      GTK_SIGNAL_FUNC (on_about_dialog_delete_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (info_ok_button), "clicked",
                      GTK_SIGNAL_FUNC (on_about_ok_button_clicked),
                      NULL);

  return dialog1;
}

GtkWidget*
create_save_dialog (void)
{
  GtkWidget *save_dialog;
  GtkWidget *save_cont;
  GtkWidget *label;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbox1;
  GtkWidget *save_ok_button;
  GtkWidget *save_cancel_button;

  save_dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (save_dialog), "save_dialog", save_dialog);
  gtk_window_set_title (GTK_WINDOW (save_dialog), _("WPAC"));
  GTK_WINDOW (save_dialog)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_position (GTK_WINDOW (save_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_default_size (GTK_WINDOW (save_dialog), 180, 110);
  gtk_window_set_policy (GTK_WINDOW (save_dialog), TRUE, TRUE, FALSE);

  save_cont = GTK_DIALOG (save_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (save_dialog), "save_cont", save_cont);
  gtk_widget_show (save_cont);

  label = gtk_label_new (_("Do you save it ?"));
  gtk_widget_ref (label);
  gtk_object_set_data_full (GTK_OBJECT (save_dialog), "label", label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (save_cont), label, TRUE, FALSE, 0);

  dialog_action_area1 = GTK_DIALOG (save_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (save_dialog), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (save_dialog), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbox1, TRUE, TRUE, 0);

  save_ok_button = gtk_button_new_with_label (_(" Yes "));
  gtk_widget_ref (save_ok_button);
  gtk_object_set_data_full (GTK_OBJECT (save_dialog), "save_yes_button", save_ok_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (save_ok_button);
  gtk_box_pack_start (GTK_BOX (hbox1), save_ok_button, TRUE, FALSE, 0);

  save_cancel_button = gtk_button_new_with_label (_(" No "));
  gtk_widget_ref (save_cancel_button);
  gtk_object_set_data_full (GTK_OBJECT (save_dialog), "save_no_button", save_cancel_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (save_cancel_button);
  gtk_box_pack_start (GTK_BOX (hbox1), save_cancel_button, TRUE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (save_ok_button), "clicked",
                      GTK_SIGNAL_FUNC (on_save_yes_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (save_cancel_button), "clicked",
                      GTK_SIGNAL_FUNC (on_save_no_button_clicked),
                      NULL);

  return save_dialog;
}

