///////////////////////////////////////////////////////////////////////////////
//
// Wall Paper Changer for GNOME
// Copyright (C) 2000-2001  Kenichi Shibata <ken_s@cat.zero.ad.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// Please read the file "COPYING" for more information.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////
//
// ken_s@cat.zero.ad.jp
// http://www3.might.co.jp/~sibata/top/
//
///////////////////////////////////////////////////////////////////////////////

// COMMON /////////////////////////////////////////////////////////////////////

//--- Structure -------------------------------------------
typedef struct _wpac {
  gboolean  changeMode;
  gboolean  random;
  gulong    timeout;
  GList     *wallPaper;
} WPAC_DATA;

typedef struct _wallpaper{
  gchar     *fileName;    // file name (full path)
  gboolean  used;         // used flag (0=not use / 1=used)
  guchar    layout;       // layout
  gboolean  dither;       // dither (yes/no)
  gboolean  gray;         // gray (yes/no)
  gboolean  zoom_x_eq_y;  // zoom X == Y (yes/no)
  guchar    zoom_x;       // zoom X (1 - 200[%])
  guchar    zoom_y;       // zoom Y (1 - 200[%])
  gushort   rotate;       // rotate (0, 90, 180, 270)
  guchar    gamma;        // gamma (0 - 100)
  gushort   brighten;     // brighten (0 - 300[%])
  gdouble   bg_color[3];  // background color (0.0 - 1.0 x 3 [rr/gg/bb])
  gchar     *option;      // option
} WALL_PAPER;

//--- Proto type ------------------------------------------
void wpac_set_changeMode(gboolean mode);
void wpac_set_random(gboolean random);
void wpac_set_timeout(gulong time);
gboolean wpac_get_changeMode(void);
gboolean wpac_get_random(void);
gulong wpac_get_timeout(void);
GList *wpac_get_wallPaper(void);
WALL_PAPER *wpac_find_wallPaper(gchar *filename);
void wpac_add_image(WALL_PAPER *add_data);
void wpac_del_image(gchar *filename);
void wpac_init_editData(void);
void wpac_quit(void);
gboolean wpac_load_file(void);
gboolean wpac_save_file(gboolean tmpFree);
gboolean wpac_change_wallpaper(void);
gboolean wpac_xloadimage(WALL_PAPER *data);

//--- Define ----------------------------------------------
// layout
#define LAYOUT_CENTER     0
#define LAYOUT_FULLSCREEN 1
#define LAYOUT_TILE       2
#define LAYOUT_DEF LAYOUT_TILE

// LOCAL //////////////////////////////////////////////////////////////////////
#ifdef __WPAC_H

//--- Proto type ------------------------------------------
static gint wpac_data_comp(gconstpointer a, gconstpointer b);
static void wpac_copy(WPAC_DATA *dst, WPAC_DATA *src);
static void wpac_allFree(WPAC_DATA *wpac_data);
static void wpac_data_check(WALL_PAPER *data);
static gchar *wpac_seek_data(gchar *str);
static GList *wpac_get_wallpaper_random(void);
static GList *wpac_get_wallpaper_normal(void);
static void wpac_init_used_flag(void);
static gboolean wpac_check_used_flag(void);


// GLOBAL /////////////////////////////////////////////////////////////////////
#else   // __WPAC_H

#endif  // End of __WPAC_H

