/*

Sound audio library
   
Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: misc.c,v 1.16 2000/01/19 15:28:46 dalroi Exp $

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/param.h>

#include "wsound.h"


Display	*dpy;
Atom	_XA_WINDOWMAKER_EVENT;
Window	wsoundserver;

extern void wAbort(void);
int checkForFile (char *instrpath);

int
SFindSoundServer(void)
{
	Window         *lstChildren;
	Window          retRoot;
	Window          retParent;
	int             indexCount;
	u_int           numChildren;
	XClassHint     *retHint;
	int		state = 0;
	/* 1 = DockApp ClassName Detected */
	
	dpy = XOpenDisplay("");
	
	if (!dpy) {
		sfatal(SMessageForError(SERR_NODISPLAY));
		wAbort();
	}
	
	_XA_WINDOWMAKER_EVENT = XInternAtom(dpy, "_WINDOWMAKER_EVENT", True);
	if (XQueryTree(dpy, DefaultRootWindow(dpy), &retRoot, &retParent, &lstChildren, &numChildren)) {
		for (indexCount = 1; indexCount < numChildren; indexCount++) {
			retHint = XAllocClassHint();
			if (!retHint) {
				XFree(lstChildren);
				SErrorCode = SERR_NOMEMORY;
				return -1;
			}
			XGetClassHint(dpy, lstChildren[indexCount], retHint);
			if (retHint->res_class) {
			    if (strcasecmp("DockApp", retHint->res_class) == 0)
				state = 1;
			    /* For compatibility with older libdockapps */
			    if (strcmp("wsoundserver", retHint->res_class) == 0)
				state = 1;
			}
			if ((state != 0) && (retHint->res_name)) {
				if (strcmp("wsoundserver", retHint->res_name) == 0) {
					wsoundserver = lstChildren[indexCount];
					XFree(lstChildren);
					if (retHint) {
						XFree(retHint);
					}
					return 0;
				}
			}
			XFree(retHint);
			retHint = 0;
		}
		XFree(lstChildren);
	}
	XCloseDisplay(dpy);

	return -1;
}



int
checkForFile(char *instrpath)
{
	return (access(instrpath, F_OK));
}


char*
SMapEventID(int wsEventID)
{
	switch (wsEventID) {
		case SEVNT_STARTUP:
				  return (S_STARTUP);
		case SEVNT_SHUTDOWN:
				  return (S_SHUTDOWN);
		case SEVNT_SHADE:
				  return (S_SHADE);
		case SEVNT_UNSHADE:
				  return (S_UNSHADE);
		case SEVNT_MAXIMIZE:
				  return (S_MAXIMIZE);
		case SEVNT_UNMAXIMIZE:
				  return (S_UNMAXIMIZE);
		case SEVNT_ICONIFY:
				  return (S_ICONIFY);
		case SEVNT_DEICONIFY:
				  return (S_DEICONIFY);
		case SEVNT_HIDE:
				  return (S_HIDE);
		case SEVNT_UNHIDE:
				  return (S_UNHIDE);
		case SEVNT_APPSTART:
				  return (S_APPSTART);
		case SEVNT_APPEXIT:
				  return (S_APPEXIT);
		case SEVNT_DOCK:
				  return (S_DOCK);
		case SEVNT_UNDOCK:
				  return (S_UNDOCK);
		case SEVNT_KABOOM:
				  return (S_KABOOM);
		case SEVNT_USERDEF:
				  return (S_USERDEF);
		default:
				  return (NULL);
	}
}


char*
SGetSoundFileFromKey(char *plKey)
{
	char		*strbuffer = NULL;
	
	strbuffer = SGetStringForKey(plKey);
	if (!strbuffer) {
		SErrorCode = SERR_NOKEY;
		return NULL;
	}

	return SGetSoundFile(strbuffer);
}


char*
SGetSoundFile(char *file)
{
	proplist_t      array = NULL, val = NULL;
	int             nr_elem = 0, i = 0;
	char		*exppath = NULL;
	char		*strbuffer = NULL;

	if (strcmp(file, "None") == 0) { /* SoundFile says None ... No need to search any further ... just don't play sound */
		if ((strbuffer = strdup(file)))
			return strbuffer;
		else {
			SErrorCode = SERR_NOMEMORY;
			return NULL;
		}
	}
	
	if (!(strbuffer = sexpandpath(file))) {
		SErrorCode = SERR_NOMEMORY;
		return NULL;
	}

	if (strncmp(strbuffer, "/", 1) == 0) {
		return strbuffer;
	}
	free(strbuffer);
	strbuffer = NULL;
	
	if ((array = SGetObjectForKey("SoundPath")) == NULL) { /* Do NOT Free */
		sfatal ("SoundPath entry is missing from the WMSound Domain File");
		wAbort();
	}
	nr_elem = PLGetNumberOfElements(array);
	
	while (i < nr_elem) {
		val = PLGetArrayElement(array, i); /* Do NOT Free */
		exppath = sexpandpath(PLGetString(val));
		if (!exppath) {
			SErrorCode = SERR_NOFILE;
			return NULL;
		}
		strbuffer = (char *) malloc(MAXPATHLEN*sizeof(char));
		if (!strbuffer) {
			free(exppath);
			SErrorCode = SERR_NOMEMORY;
			return NULL;
		}
		strcpy(strbuffer, exppath);
		strcat(strbuffer, "/");
		strcat(strbuffer, file);
		if (checkForFile(strbuffer) == 0) {
			free(exppath);
			return strbuffer;
		}
		free(exppath);
		exppath = NULL;
		free(strbuffer);
		strbuffer = NULL;
		i++;
	}
	
	SErrorCode = SERR_NOFILE;
	
	return NULL;
}

char*
SGetSoundSetFile(char *sndsetfile)
{
	proplist_t	array, val;
	int		nr_elem = 0, i = 0;
	char		*strpath, *strbuffer;

	if (strncmp(sndsetfile, "/", 1) == 0) {
		strbuffer = strdup(sndsetfile);
		if (!strbuffer) {
			SErrorCode = SERR_NOMEMORY;
			return NULL;
		}
		return strbuffer;
	}
	
	if ((array = SGetObjectForKey("SoundSetPath")) == NULL) { /* Do NOT Free */
		sfatal("SoundSetPath entry is missing from WMSound Domain File");
		wAbort();
	}

	nr_elem = PLGetNumberOfElements(array);
	
	while (i < nr_elem) {
		val = PLGetArrayElement(array, i); /* Do NOT Free */
		strpath = sexpandpath(PLGetString(val));
		if (!strpath)
			return NULL;
		strbuffer = (char *) malloc(MAXPATHLEN*sizeof(char));
		if (!strbuffer) {
			free(strpath);
			return NULL;
		}
		strcpy(strbuffer, strpath);
		strcat(strbuffer, "/");
		strcat(strbuffer, sndsetfile);
		if (checkForFile(strbuffer) == 0) {
			free(strpath);
			return strbuffer;
		}
		free(strpath);
		strpath = NULL;
		free(strbuffer);
		strbuffer = NULL;
		i++;
	}
	
	return NULL;
}
