/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.LastPositionFinder;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.om.NodeInfo;
import java.util.Vector;
import org.xml.sax.SAXException;

public class NodeSetIntent
extends NodeSetValue {
    private NodeSetExpression expression;
    private NodeSetExtent extent = null;
    private boolean sorted = false;

    public NodeSetIntent(NodeSetExpression nodeSetExpression) throws SAXException {
        if (nodeSetExpression.getDependencies() != 0) {
            throw new SAXException("Cannot create intensional node-set with context dependencies: " + nodeSetExpression.getClass() + ":" + nodeSetExpression.getDependencies());
        }
        this.expression = nodeSetExpression;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
    }

    public boolean isSorted() throws SAXException {
        return this.sorted || this.expression.enumerate(null).isSorted();
    }

    public String asString() throws SAXException {
        NodeInfo nodeInfo = this.getFirst();
        return nodeInfo == null ? "" : nodeInfo.getValue();
    }

    public int getCount() throws SAXException {
        if (this.extent == null) {
            NodeEnumeration nodeEnumeration = this.expression.enumerate(null);
            if (nodeEnumeration instanceof LastPositionFinder && nodeEnumeration.isSorted()) {
                return ((LastPositionFinder)((Object)nodeEnumeration)).getLastPosition();
            }
            this.extent = new NodeSetExtent(nodeEnumeration);
        }
        return this.extent.getCount();
    }

    public boolean isEmpty() throws SAXException {
        if (this.extent != null) {
            return this.extent.isEmpty();
        }
        NodeEnumeration nodeEnumeration = this.expression.enumerate(null);
        return !nodeEnumeration.hasMoreElements();
    }

    public boolean contains(NodeInfo nodeInfo) throws SAXException {
        this.fix();
        return this.extent.contains(nodeInfo);
    }

    private void fix() throws SAXException {
        if (this.extent == null) {
            NodeEnumeration nodeEnumeration = this.expression.enumerate(null);
            this.extent = new NodeSetExtent(nodeEnumeration);
        }
    }

    public Vector getVector() throws SAXException {
        this.fix();
        return this.extent.getVector();
    }

    public NodeInfo[] getNodes() throws SAXException {
        this.fix();
        return this.extent.getNodes();
    }

    public NodeSetValue sort() throws SAXException {
        if (this.sorted) {
            return this;
        }
        this.fix();
        return this.extent.sort();
    }

    public NodeInfo getFirst() throws SAXException {
        if (this.extent != null) {
            return this.extent.getFirst();
        }
        NodeEnumeration nodeEnumeration = this.expression.enumerate(null);
        if (this.sorted || nodeEnumeration.isSorted()) {
            this.sorted = true;
            if (nodeEnumeration.hasMoreElements()) {
                return nodeEnumeration.nextElement();
            }
            return null;
        }
        NodeInfo nodeInfo = null;
        long l = Long.MAX_VALUE;
        while (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo2 = nodeEnumeration.nextElement();
            long l2 = nodeInfo2.getSequenceNumber();
            if (l2 >= l) continue;
            nodeInfo = nodeInfo2;
            l = l2;
        }
        return nodeInfo;
    }

    public NodeInfo selectFirst(Context context) throws SAXException {
        return this.getFirst();
    }

    public NodeEnumeration enumerate() throws SAXException {
        if (this.extent != null) {
            return this.extent.enumerate();
        }
        return this.expression.enumerate(null);
    }
}

