/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.CharacterSet;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.OutputDetails;
import java.io.Writer;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class ContentHandlerProxy
implements Emitter {
    protected ContentHandler handler;
    protected LexicalHandler lexicalHandler;
    protected Writer writer;
    protected CharacterSet characterSet;
    protected OutputDetails outputDetails;
    protected AttributesImpl attributes = new AttributesImpl();
    private int depth = 0;
    protected boolean requireWellFormed = true;
    private String[] namespaces = new String[30];
    private int namespacesSize = 0;
    private int[] namespaceStack = new int[100];
    private int nsStackTop = 0;
    private int nsCount = 0;

    public void setUnderlyingContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setWriter(Writer writer) throws SAXException {
    }

    public void setCharacterSet(CharacterSet characterSet) throws SAXException {
    }

    public void setRequireWellFormed(boolean bl) {
        this.requireWellFormed = bl;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.handler != null) {
            this.handler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.handler == null) {
            throw new SAXException("ContentHandlerProxy.startDocument(): no underlying handler provided");
        }
        this.handler.startDocument();
        this.depth = 0;
    }

    public void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        int n = this.namespacesSize - 2;
        while (n >= 0) {
            if (this.namespaces[n] == string) {
                if (this.namespaces[n + 1] != string2) break;
                return;
            }
            n -= 2;
        }
        if (this.namespacesSize + 2 >= this.namespaces.length) {
            String[] stringArray = new String[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, stringArray, 0, this.namespacesSize);
            this.namespaces = stringArray;
        }
        this.namespaces[this.namespacesSize++] = string;
        this.namespaces[this.namespacesSize++] = string2;
        ++this.nsCount;
        this.handler.startPrefixMapping(string, string2);
    }

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        ++this.depth;
        if (this.depth > 0) {
            this.attributes.clear();
            int n = 0;
            while (n < attributeCollection.getLength()) {
                Name name2 = attributeCollection.getExpandedName(n);
                this.attributes.addAttribute(name2.getURI(), name2.getLocalName(), name2.getDisplayName(), attributeCollection.getType(n), attributeCollection.getValue(n));
                ++n;
            }
            this.handler.startElement(name.getURI(), name.getLocalName(), name.getDisplayName(), this.attributes);
        }
        if (this.nsStackTop >= this.namespaceStack.length) {
            int[] nArray = new int[this.nsStackTop * 2];
            System.arraycopy(this.namespaceStack, 0, nArray, 0, this.nsStackTop);
            this.namespaceStack = nArray;
        }
        this.namespaceStack[this.nsStackTop++] = this.nsCount;
        this.nsCount = 0;
    }

    public void endElement(Name name) throws SAXException {
        if (this.depth > 0) {
            this.handler.endElement(name.getURI(), name.getLocalName(), name.getDisplayName());
        }
        --this.depth;
        if (this.requireWellFormed && this.depth <= 0) {
            this.depth = Integer.MIN_VALUE;
        }
        if (this.nsStackTop-- == 0) {
            throw new SAXException("Attempt to output end tag with no matching start tag");
        }
        int n = this.namespaceStack[this.nsStackTop];
        int n2 = this.namespacesSize - 2;
        while (n2 >= this.namespacesSize - n * 2) {
            this.handler.endPrefixMapping(this.namespaces[n2]);
            n2 -= 2;
        }
        this.namespacesSize -= n * 2;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.depth > 0 || !this.requireWellFormed) {
            this.handler.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.depth > 0 || !this.requireWellFormed) {
            this.handler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.handler.processingInstruction(string, string2);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(cArray, n, n2);
        }
    }

    public void setEscaping(boolean bl) throws SAXException {
    }

    public void setIndenting(boolean bl) {
    }

    public void setOutputDetails(OutputDetails outputDetails) throws SAXException {
        this.outputDetails = outputDetails;
    }
}

