/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.ContentHandlerProxy;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Version;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FOPEmitter
extends ContentHandlerProxy {
    private PrintWriter printWriter;
    private Driver fop;

    public void startDocument() throws SAXException {
        this.fop = new Driver();
        String string = Version.getVersion();
        ContentHandler contentHandler = this.fop.getContentHandler();
        this.fop.setRenderer("org.apache.fop.render.pdf.PDFRenderer", string);
        this.fop.addElementMapping("org.apache.fop.fo.StandardElementMapping");
        this.fop.addElementMapping("org.apache.fop.svg.SVGElementMapping");
        this.setUnderlyingContentHandler(contentHandler);
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        try {
            this.fop.setWriter(this.printWriter);
            this.fop.format();
            this.fop.render();
        }
        catch (FOPException fOPException) {
            throw new SAXException("Error from FOP: ", (Exception)((Object)fOPException));
        }
        catch (IOException iOException) {
            throw new SAXException("I/O Error from FOP: ", iOException);
        }
        catch (Throwable throwable) {
            throw new SAXException("FOP processing failed: " + throwable.getMessage());
        }
    }

    public void setWriter(Writer writer) {
        this.printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }
}

