/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.Emitter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Node;

public class OutputDetails {
    Writer writer = null;
    OutputStream outputStream = null;
    Emitter emitter = null;
    String method = "saxon:uncommitted";
    String version = null;
    String indent = null;
    String encoding = "utf-8";
    String mediaType = null;
    String doctypeSystem = null;
    String doctypePublic = null;
    String omitDeclaration = "no";
    String standalone = null;
    String userData = null;
    Vector cdataElements = new Vector();
    PreparedStyleSheet nextInChain = null;
    boolean escaping = true;
    int indentSpaces = 3;
    boolean closeAfterUse = true;
    boolean includeHtmlMetaTag = true;
    Node node = null;

    public OutputDetails() {
    }

    public OutputDetails(OutputDetails outputDetails) {
        this.writer = outputDetails.writer;
        this.method = outputDetails.method;
        this.version = outputDetails.version;
        this.indent = outputDetails.indent;
        this.encoding = outputDetails.encoding;
        this.mediaType = outputDetails.mediaType;
        this.doctypeSystem = outputDetails.doctypeSystem;
        this.doctypePublic = outputDetails.doctypePublic;
        this.omitDeclaration = outputDetails.omitDeclaration;
        this.standalone = outputDetails.standalone;
        this.userData = outputDetails.userData;
        this.closeAfterUse = outputDetails.closeAfterUse;
        this.cdataElements = outputDetails.cdataElements;
        this.node = outputDetails.node;
        this.includeHtmlMetaTag = outputDetails.includeHtmlMetaTag;
    }

    public final void setWriter(Writer writer) {
        this.writer = writer;
    }

    public final void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public final void setMethod(String string) {
        if (string != null) {
            this.method = string.intern();
        }
    }

    public final void setVersion(String string) {
        if (string != null) {
            this.version = string.intern();
        }
    }

    public final void setIndent(String string) {
        if (string != null) {
            this.indent = string.intern();
        }
    }

    public void setIndentSpaces(int n) {
        this.indentSpaces = n;
    }

    public final void setEncoding(String string) {
        if (string != null) {
            this.encoding = string.intern();
        }
    }

    public final void setMediaType(String string) {
        if (string != null) {
            this.mediaType = string.intern();
        }
    }

    public final void setDoctypeSystem(String string) {
        if (string != null) {
            this.doctypeSystem = string.intern();
        }
    }

    public final void setDoctypePublic(String string) {
        if (string != null) {
            this.doctypePublic = string.intern();
        }
    }

    public final void setOmitDeclaration(String string) {
        if (string != null) {
            this.omitDeclaration = string.intern();
        }
    }

    public final void setStandalone(String string) {
        if (string != null) {
            this.standalone = string.intern();
        }
    }

    public final void setUserData(String string) {
        this.userData = string;
    }

    public final void addCdataElements(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.cdataElements.addElement(vector.elementAt(n));
            ++n;
        }
    }

    public final void addCdataElement(Name name) {
        this.cdataElements.addElement(name);
    }

    public final void setEscaping(boolean bl) {
        this.escaping = bl;
    }

    public final void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public final void setNextInChain(PreparedStyleSheet preparedStyleSheet) {
        this.nextInChain = preparedStyleSheet;
    }

    public final void setCloseAfterUse(boolean bl) {
        this.closeAfterUse = bl;
    }

    public final void setDOMNode(Node node) {
        this.node = node;
    }

    public void setIncludeHtmlMetaTag(boolean bl) {
        this.includeHtmlMetaTag = bl;
    }

    public final Writer getWriter() {
        return this.writer;
    }

    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    public final String getMethod() {
        return this.method;
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getIndent() {
        return this.indent;
    }

    public final boolean isIndenting() {
        if (this.indent == null) {
            return this.method == "html" || this.method == "xhtml";
        }
        return this.indent == "yes";
    }

    public int getIndentSpaces() {
        return this.indentSpaces;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final String getMediaType() {
        if (this.mediaType == null) {
            if (this.method == null || this.method.equals("xml")) {
                return "application/xml";
            }
            if (this.method.equals("html")) {
                return "text/html";
            }
            if (this.method.equals("text")) {
                return "text/plain";
            }
            return "application/xml";
        }
        return this.mediaType;
    }

    public final String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    public final String getDoctypePublic() {
        return this.doctypePublic;
    }

    public final String getOmitDeclaration() {
        return this.omitDeclaration;
    }

    public final String getStandalone() {
        return this.standalone;
    }

    public final String getUserData() {
        return this.userData;
    }

    public final Vector getCdataElements() {
        return this.cdataElements;
    }

    public final boolean isEscaping() {
        return this.escaping;
    }

    public final Emitter getEmitter() {
        return this.emitter;
    }

    public final PreparedStyleSheet getNextInChain() {
        return this.nextInChain;
    }

    public final boolean getCloseAfterUse() {
        return this.closeAfterUse;
    }

    public final Node getDOMNode() {
        return this.node;
    }

    public boolean getIncludeHtmlMetaTag() {
        return this.includeHtmlMetaTag;
    }
}

