#ifndef _RGBA_H
#define _RGBA_H

#include <X11/Xlib.h>

struct _RgbaImage {
  unsigned char *data;
  int width, height, hotx, hoty, has_alpha;
};
typedef struct _RgbaImage * RgbaImage;

RgbaImage new_rgba_image( int width, int height );
void delete_rgba_image( RgbaImage ri );
RgbaImage create_rgba_image_from_png_file( const char *filename );
RgbaImage scale_down_rgba_image( RgbaImage ri, double scalex, double scaley );
RgbaImage crop_rgba_image( RgbaImage ri, int x1, int y1, int x2, int y2 );
RgbaImage rotate_rgba_image( RgbaImage ri, double angle, int autocrop );
int create_pixmaps_from_rgba_image( RgbaImage ri, Pixmap *rgb, Pixmap *mask);
unsigned long get_pixel( int red, int green, int blue );

#endif /* _RGBA_H */
