/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : xcardMain.h
            Author : David Corcoran
            Date   : 10/05/01
	    License: Copyright (C) 2001 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This provides functionality for the xcard
	             personalization tool for the musclecard.
 
********************************************************************/ 

#ifndef xcardMain_included
#define xcardMain_included

#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif

#include "xcardMainData.h"

#ifdef MSC_TARGET_WIN32
#define snprintf _snprintf
#endif


#define XCARD_MAX_READERS   16
#define XCARD_MAX_OBJECTS   24
#define XCARD_MAX_KEYS      16
#define XCARD_MAX_PINS      8

class xcardViewer;
class xcardPutKey;

class xcardMain : public xcardMainData
{
    Q_OBJECT

public:

    xcardMain(
        QWidget *parent = NULL,
        const char *name = NULL );

    virtual ~xcardMain();

    void xcardMainAddCard(
	xcardMain *myClass,
	const char *readerName, 
	unsigned char *idValue,
	unsigned long idLength );
 
    void xcardMainRemoveCard(
	xcardMain *myClass,
	const char *readerName );

    int XCHECK_RESP(
        int rv, 
	char *message );

    void XCOutputDataObject(
        char *objectID, 
	char *exportFile,
	bool suppressMesg); 

    void XCInputDataObject(
         char *objectID,
	 char *inputFile);

    void XCHandleLongOperation();
    void XCCancelLongOperation();
    int XCGetFreeMemory();
    void XCUpdateMemory();
    void XCUpdateList();


    xcardPutKey *putKeyDialog;
    xcardViewer *getViewerDialog;
    int numStars;
    MSCLPTokenInfo clickedReader;


    QListViewItem *readerList[XCARD_MAX_READERS];
    QListViewItem *readerRoot;
    QListViewItem *objectList[XCARD_MAX_OBJECTS];
    QListViewItem *theRoot;
    QListViewItem *objectRoot;
    QListViewItem *keyRoot;
    QListViewItem *keyList[XCARD_MAX_KEYS];
    QListViewItem *pinRoot;
    QListViewItem *pinList[XCARD_MAX_PINS];
    QListView *mainBox;
    QListViewItem *itemCurrentlySelected;
    
    QPopupMenu *fileMenu;
    QPopupMenu *viewMenu;
    QPopupMenu *optionsMenu;
    QPopupMenu *helpMenu;
    
    SCARDCONTEXT hContext;
    MSCTokenConnection pConnection;
    //LPCardEventInfo cardEventInf[XCARD_MAX_READERS];
    char errorMessage[300];
    char currentActiveReader[100];
    bool objectViewHex;

    void dragEnterEvent(QDragEnterEvent* event);
    void dropEvent(QDropEvent* event);

    public slots:

    virtual void XCResetButtonClicked();
    virtual void XCReaderListClicked(QListViewItem*); 
    virtual void XCtargetObjectClicked(QListViewItem*);
    virtual void XCRightSelectObjectType(QListViewItem*,const QPoint&,int);
    virtual void XCVerifyPIN();
    virtual void XCChangePIN();
    virtual void XCUnblockPIN();
    virtual void XCImportObject();
    virtual void XCExportObject();
    virtual void XCDeleteObject();
    virtual void XCViewObject();
    virtual void XCViewObjectParams();
    virtual void XCExportKey();
    virtual void XCViewKeyParams();
    virtual void XCProperties();
    virtual void XCCreateObject();
    virtual void XCGenerateKey();
    virtual void XCImportKey();
    virtual void XCCreatePIN();
    virtual void XCLogoutAll();
    virtual void XCDeleteAll();
    virtual void XCReGenerateKey();

    virtual void XCOpenObjectConfig();
    virtual void XCSaveObjectConfig();
    virtual void XCChangeView();
    virtual void XCAboutXCardII();


    virtual void XCRefreshContents();
    virtual void XCRefreshReaders();
    virtual void XCMenuExit();
    virtual void XCSetViewer();
    virtual void XCInitCard();


};
#endif // xcardMain_included
