/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : xcardManagePIN.cpp
            Author : David Corcoran
            Date   : 10/05/01
	    License: Copyright (C) 2001 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This provides functionality for the xcard
	             personalization tool for the musclecard.
 
********************************************************************/ 

#include "xcardManagePIN.h"
#include <qtooltip.h>
#include <qmessagebox.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>


#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif


#define Inherited xcardManagePINData

xcardManagePIN::xcardManagePIN
(
 MSCLPTokenConnection pConn,
 MSCULong32 pinNum,
 xcardMain *mainWin,
 QWidget* parent,
 const char* name
)
	:
	Inherited( parent, name )
{
  mainWindow = mainWin;
  pinNumber  = pinNum;
  pConnect   = pConn;

  g_pinManageUnblockText1->setEchoMode(QLineEdit::Password);
  g_pinManageNewText1->setEchoMode(QLineEdit::Password);
  g_pinManageNewText2->setEchoMode(QLineEdit::Password);
  g_pinManageAttemptsBox1->setValue(5);

  QToolTip::add(g_pinManageChangeCheck1, "Check this box to change a pin\nUncheck this box to create a pin");


  if ( pinNumber < 7 ) {
    g_pinManageChangeCheck1->setChecked(TRUE);
    XCFillPINBox(TRUE);
  } else {
    XCFillPINBox(FALSE);
  }

}

xcardManagePIN::~xcardManagePIN()
{


}

void xcardManagePIN::XCPinManageCancelClick()
{
  hide();
}

void xcardManagePIN::XCPinManageCheckClicked(bool isClicked)
{

  if ( isClicked == TRUE ) {
    /* Must want to change PIN */
    g_pinManageLabel1->setText("Old PIN Number");
    g_pinManageAttemptsBox1->setDisabled(TRUE);
    XCFillPINBox(TRUE);

  } else {
    g_pinManageLabel1->setText("Unblock PIN Number");
    g_pinManageAttemptsBox1->setEnabled(TRUE);
    XCFillPINBox(FALSE);
  }


}

void xcardManagePIN::XCPinManageOKClicked()
{

  MSCLong32 rv;
  QString newString;
  QString newStringCheck;
  QString oldUNString;
  QString pinNumString;
  QString numTriesString;
  char tempString[50];
  char errorString[200];
  bool isOK;

  MSCUChar8 newPinCode[50];
  MSCUChar8 newPinCodeCheck[50];
  MSCUChar8 oldUNPinCode[50];
  MSCULong32 numTries;
  MSCULong32 chosenNumber;

  oldUNString    = g_pinManageUnblockText1->text();
  memcpy(oldUNPinCode, oldUNString.latin1(), oldUNString.length());

  newString      = g_pinManageNewText1->text();
  memcpy(newPinCode, newString.latin1(), newString.length());

  newStringCheck = g_pinManageNewText2->text();
  memcpy(newPinCodeCheck, newStringCheck, newStringCheck.length());

  pinNumString = g_pinManageNumberBox1->currentText();
  strcpy((char *)tempString, pinNumString.latin1());

  chosenNumber   = strtoul((char *)&tempString[5], 0, 10);  
  numTriesString = g_pinManageAttemptsBox1->text();
  numTries       = numTriesString.toULong(&isOK, 10);

  if ( newString.isNull() || newStringCheck.isNull() ) {
    QMessageBox::critical( 0, "XCard II", "No Value for PIN" );     
    return;
  }

  if ( QString::compare(newString, newStringCheck) ) {
    QMessageBox::critical( 0, "XCard II", "PINs do no match" );     
    return;
  }

  if ( g_pinManageChangeCheck1->isChecked() == TRUE ) {
    /* Change PIN */

    rv = MSCChangePIN(pConnect, chosenNumber, oldUNPinCode, 
		      oldUNString.length(), newPinCode,
		      newString.length() );

    if ( rv != MSC_SUCCESS ) {
      snprintf(errorString, sizeof(errorString), "%s%s", 
	       "ChangePIN Failed\nCode: ", msc_error(rv));
      QMessageBox::critical( 0, "XCard II", errorString ); 
    } else {
      snprintf(errorString, sizeof(errorString), "%s%ld", 
	       "Successful Change\n     of PIN #", chosenNumber);
      QMessageBox::information( 0, "XCard II", errorString );
      hide();
    }

  } else {
    /* Create PIN */

   rv = MSCCreatePIN(pConnect, chosenNumber, numTries, newPinCode,
		      newString.length(), oldUNPinCode, 
		      oldUNString.length());

    if ( rv != MSC_SUCCESS ) {
      snprintf(errorString, sizeof(errorString), "%s%s", 
	       "CreatePIN Failed\nCode: ", msc_error(rv));
      QMessageBox::critical( 0, "XCard II", errorString); 
    } else {
      mainWindow->XCUpdateList();
      hide();
    }
  }

}

void xcardManagePIN::XCFillPINBox(bool isChangePIN) {


  MSCLong32 rv;
  MSCUShort16 pinInf;
  int desiredPIN;
  char insertText[75];
  unsigned int p;
  int i, index;

  pinInf     = 0;
  index      = 0;
  p          = 0;
  desiredPIN = -1;


  if ( isChangePIN == TRUE ) {
    g_managePINTitle1->setText("Change PIN Number");
  } else {
    g_managePINTitle1->setText("Create PIN Number");
  }


  g_pinManageNumberBox1->clear();
  g_pinManageNumberBox1->setInsertionPolicy(QComboBox::AtTop);

  rv = MSCListPINs( pConnect, &pinInf );

  for (i=1; i < 0xFF; i<<=1) {
    if (pinInf & i) {
      if ( isChangePIN == TRUE ) {
	snprintf(insertText, sizeof(insertText), "PIN #%d", p);

	if ( pinNumber == p ) {
	  printf("Setting default %ld\n", pinNumber);
	  g_pinManageNumberBox1->insertItem(insertText, 0);
	} else {
	  g_pinManageNumberBox1->insertItem(insertText, -1);
	}
	++index;
      }
    } else if ( (pinInf & i) == 0 ) {
      if ( isChangePIN == FALSE ) {
	snprintf(insertText, sizeof(insertText), "PIN #%d", p);
	g_pinManageNumberBox1->insertItem(insertText, -1);
	++index;
      }
    }

    ++p;
  }	

}
