#include<string.h>

#include "base64.h"

// The Base64 alphabet

const char szB64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

void encodeMIME64(char *szStr, char* szEnc, int szStrLen) 
{
  int iLen, i, j;
  iLen = ((szStrLen < 0) ? strlen(szStr) : szStrLen);
  //iLen = strlen(szStr);
  
  j = 0;
  for (i = 0; i < (iLen - (iLen % 3)); i+=3)   // Encode 3 bytes at a time.
    {
      szEnc[j]   = szB64[ (szStr[i] & 0xfc) >> 2 ];
      szEnc[j+1] = szB64[ ((szStr[i] & 0x03) << 4)   | ((szStr[i+1] & 0xf0) >> 4) ];
      szEnc[j+2] = szB64[ ((szStr[i+1] & 0x0f) << 2) | ((szStr[i+2] & 0xc0) >> 6) ];
      szEnc[j+3] = szB64[ (szStr[i+2] & 0x3f) ];
      j += 4;
    }
  
  i = iLen - (iLen % 3);  // Where we left off before.
  switch (iLen % 3)
    {
    case 2:  // One character padding needed.
      {
	szEnc[j] = szB64[ (szStr[i] & 0xfc) >> 2 ];
	szEnc[j+1] = szB64[ ((szStr[i] & 0x03) << 4) | ((szStr[i+1] & 0xf0) >> 4) ];
	szEnc[j+2] = szB64[ (szStr[i+1] & 0x0f) << 2 ];
	szEnc[j+3] = szB64[64];  // Pad
	break;
      }
    case 1:  // Two character padding needed.
      {
	szEnc[j] = szB64[ (szStr[i] & 0xfc) >> 2 ];
	szEnc[j+1] = szB64[ (szStr[i] & 0x03) << 4 ];
	szEnc[j+2] = szB64[64];  // Pad
	szEnc[j+3] = szB64[64];  // Pad
	break;
      }
    }
  szEnc[j+4] = '\0';
}

// Helper macro
#define Val(i) ( szStr[i] == '=' ? 0 : strchr(szB64, szStr[i]) - szB64 )

void decodeMIME64(char *szStr, char* szDecode)
{
  int iLen, i, j;
  iLen = strlen(szStr);
  
  j = 0;
  for (i = 0; i < iLen; i+=4) // Work on 4 bytes at a time.
    {                         // Twiddle bits.
      szDecode[j]   = (Val(i) << 2) | ((Val(i+1) & 0x30) >> 4);
      szDecode[j+1] = ((Val(i+1) & 0x0f) << 4) | ((Val(i+2) & 0x3c) >> 2);
      szDecode[j+2] = ((Val(i+2) & 0x03) << 6) | (Val(i+3) & 0x3f);
      j += 3;
    }
  
  szDecode[j] = '\0';
}









