#ifndef helper_h
#define helper_h

#include <time.h>
#include <string.h>
#include <stdio.h>

#include "globals.h"

extern long timeOffset;
extern FILE *xproxyLog;

// This function takes a string date as input and converts it to UTC time in seconds. It handles rfc1123, asctime and rfc850 dates.  If successful, it returns true; otherwise, false.

bool strToTime(char *str, time_t *t);

// This function takes a UTC time in seconds and converts it to a string date in the rfc1123 format.  If successful, it returns true; otherwise, false.

bool timeToStr(time_t t, char str[32]);

// This function allocates more memory for an array of characters.

void reallocateBuffer(char **buffer, int *allocatedLength, int desiredLength);

#endif helper_h
