/****************************************************************************
** $Id: qt/examples/application/application.cpp   2.2.4   edited 2000-08-31 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#include "application.h"

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <qglobal.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qpixmap.h>
#include <qclipboard.h>
#include <qdragobject.h>
#include <qtooltip.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qmultilineedit.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <qpushbutton.h>
#include <qcolordialog.h>
#include <qpaintdevicemetrics.h>
#include <qwhatsthis.h>
#include <qscrollview.h>
#include <qcombobox.h>
#include <qfont.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qmime.h>

#ifdef UNIX
#include <stdlib.h>
#include <time.h>
#endif

#include "defs.h"
#include "drawable.h"
#include "render2d.h"
#include "chemdata.h"
#include "ringdialog.h"
#include "fixeddialog.h"
#include "netdialog.h"
#include "netchoosedialog.h"
#include "netaccess.h"
#include "pagesetupdialog.h"
#include "xdc_toolbutton.h"

// top toolbar
#include "filesave.xpm"
#include "fileopen.xpm"
#include "fileprint.xpm"
#include "cuttool.xpm"
#include "copytool.xpm"
#include "pastetool.xpm"

// line thicknesses
#include "lines.h"

// text operation buttons
#include "boldtool.xpm"
#include "italictool.xpm"
#include "underlinetool.xpm"
#include "superscript.xpm"
#include "subscript.xpm"

// left side toolbar
#include "selecttool.xpm"
#include "erasetool.xpm"
#include "linetool.xpm"
#include "dashtool.xpm"
#include "uptool.xpm"
#include "downtool.xpm"
#include "texttool.xpm"
#include "arrowtool.xpm"
#include "curvearrowtool.xpm"
#include "brackettool.xpm"
#include "ringtool.xpm"
#include "symboltool.xpm"

// predefined toolbar
#include "rings.h"

// Brackets
#include "brackets.h"
// end brackets

// Symbols
#include "symbol_xpm.h"
// end symbols

// Arrows
#include "arrows.h"
#include "cw90.xpm"
#include "ccw90.xpm"
#include "cw180.xpm"
#include "ccw180.xpm"
#include "cw270.xpm"
#include "ccw270.xpm"
// end Arrows

// defined in main.cpp
extern QString RingDir;


ApplicationWindow::ApplicationWindow(Clipboard *clipin)
    : QMainWindow( 0, "XDrawChem main window", WDestructiveClose )
{
  use_babel = false;
#ifdef UNIX
  // check for Babel

  FILE *test1;
  char *spam;
  QString cmd = "babel";
  test1 = popen(cmd.ascii(), "r");
  spam = (char*)malloc(sizeof(char) * 65536);
  fread(spam, 1, 65535, test1);
  QString testq = spam;
  pclose(test1);
  free(spam);

  if (testq.contains("Babel") > 0) {
    cout << "Found Babel" << endl;
    use_babel = true;
  }
#endif

  //QApplication::clipboard()->setData(new QImageDrag(QImage("edittool.xpm")));
  //QApplication::clipboard()->setText("edittool.xpm");

  //QFont mf("Helvetica", 10, QFont::Normal);
  //setFont(mf);

  // What's This? text for top toolbar
  QString fileOpenText=tr("Click this button to open a file.<br><br>You can also select the Open command from the File menu.");
  QString fileSaveText=tr("Click this button to save the file you are editing.<br><br>You can also select the Save command from the File menu.<br><br>");
  QString filePrintText=tr("Click this button to print the file you are editing.<br><br>You can also select the Print command from the File menu.");
  QString editCutText=tr("Click this button to cut a selection.<br><br>You can also select the Cut command from the Edit menu, or press Ctrl+X.");
  QString editCopyText=tr("Click this button to copy a selection.<br><br>You can also select the Copy command from the Edit menu, or press Ctrl+C.");
  QString editPasteText=tr("Click this button to paste a selection.<br><br>You can also select the Paste command from the Edit menu, or press Ctrl+V.");
  
  // What's This? text for left side toolbar
  QString selectToolText = tr("Select tool<br><br>Use the Select tool to select and move items.<br><br>You can select multiple items and cut, copy, move and rotate them.");
  QString eraseToolText = tr("Erase tool<br><br>Use the Erase tool to erase individual items.");
  QString lineToolText = tr("Line tool<br><br>Use the Line tool to draw bonds.  Draw over existing bonds to create double and triple bonds.");
  QString dashLineToolText = tr("Dashed Line tool<br><br>Use the Dashed Line tool to draw dashed lines.  Draw over existing bonds to add dashed lines (to indicate resonance, etc.).");
  QString upLineToolText = tr("Stereo Up Line tool<br><br>Use the Line tool to draw stereo-up lines, as shown on the button.");
  QString downLineToolText = tr("Stereo Down Line tool<br><br>Use the Line tool to draw stereo-down lines, as shown on the button.");
  QString arrowToolText = tr("Arrow tool<br><br>Use the Arrow tool to draw straight arrows.<br><br>Click to draw a straight arrow.<br><br>Click and hold to pick from a list of available arrows.");
  QString cArrowToolText = tr("Curved Arrow tool<br><br>Use the Curved Arrow tool to insert curved arrows.<br><br>Click and hold to select from a picture menu of arrows.");
  QString bracketToolText = tr("Bracket tool<br><br>Use the Bracket tool to draw brackets and parentheses.<br><br>Click to draw square brackets.<br><br>Click and hold to select from a picture menu of brackets.");
  QString textToolText = tr("Text tool<br><br>Use the Text tool to add text and label atoms and points.<br>(See manual for info on formatting text)");
  QString ringToolText = tr("Ring tool<br><br>Use the Ring tool to insert ready-made rings and structures.<br><br>Click to open the ring dialog, which allows selection from a list of all built-in rings and structures.<br><br>Click and hold to select from a picture menu of select rings.<br>(See manual for more info on modifying this menu)");
  QString symbolToolText = tr("Symbol tool<br><br>Use the Symbol tool to insert symbols.<br><br>Click and hold to select from a picture menu of symbols.<br>");

  clip = clipin;
  int id;
  QMimeSourceFactory *myfactory = QMimeSourceFactory::defaultFactory();

  printer = new QPrinter;
  QPixmap openIcon, saveIcon, printIcon, superIcon, subIcon;
  QPixmap swatchblack, swatchred, swatchgreen, swatchblue;
  QPixmap selectIcon, drawBoxIcon, drawLineIcon, downLineIcon, upLineIcon,
    textIcon, arrowIcon, bracketIcon, cutIcon, copyIcon, pasteIcon, ringIcon,
    dashIcon, symbolIcon, curveArrowIcon;

  // create scrolling viewport and render widget
  sv = new QScrollView(this);
  r = new Render2D( sv->viewport(), "render2d" );
  sv->addChild(r);

  // top toolbar
  fileTools = new QToolBar( this, "file operations" );
  fileTools->setLabel( tr( "File Operations" ) );

  openIcon = QPixmap( fileopen );
  myfactory->setPixmap("fileopenicon", openIcon );
  QToolButton * fileOpen
    = new QToolButton( openIcon, tr("Open file"), QString::null,
		       this, SLOT(load()), fileTools, "open file" );
  QWhatsThis::add(fileOpen, fileOpenText);

  saveIcon = QPixmap( filesave );
  myfactory->setPixmap("filesaveicon", saveIcon );
  QToolButton * fileSave
    = new QToolButton( saveIcon, tr("Save file"), QString::null,
		       this, SLOT(save()), fileTools, "save file" );
  QWhatsThis::add(fileSave, fileSaveText);

  printIcon = QPixmap( fileprint );
  myfactory->setPixmap("fileprinticon", printIcon );
  QToolButton * filePrint
    = new QToolButton( printIcon, tr("Print file"), QString::null,
		       this, SLOT(print()), fileTools, "print file" );
  QWhatsThis::add(filePrint, filePrintText);

  cutIcon = QPixmap(cuttool);
  myfactory->setPixmap("cuticon", cutIcon );
  QToolButton * editCut
    = new QToolButton( cutIcon, tr("Cut"), QString::null,
		       this, SLOT(Cut()), fileTools, "cut" );
  QWhatsThis::add(editCut, editCutText);

  copyIcon = QPixmap(copytool);
  myfactory->setPixmap("copyicon", copyIcon );
  QToolButton * editCopy
    = new QToolButton( copyIcon, tr("Copy"), QString::null,
		       this, SLOT(Copy()), fileTools, "copy" );
  QWhatsThis::add(editCopy, editCopyText);

  pasteIcon = QPixmap(pastetool);
  myfactory->setPixmap("pasteicon", pasteIcon );
  QToolButton * editPaste
    = new QToolButton( pasteIcon, tr("Paste"), QString::null,
		       this, SLOT(Paste()), fileTools, "paste" );
  QWhatsThis::add(editPaste, editPasteText);

  QPixmap *tmp_pm = new QPixmap(32, 20);
  tmp_pm->fill(QColor(210,210,210));
  QPainter pixpaint(tmp_pm);
  pixpaint.fillRect(2, 3, 14, 14, QColor(0,0,0));
  pixpaint.setPen(QColor(0,0,0));
  pixpaint.drawLine( 24, 2, 24, 16 );
  pixpaint.drawLine( 24, 16, 20, 12 );
  pixpaint.drawLine( 24, 16, 28, 12 );
  pb1 = new QPushButton(fileTools);
  pb1->setPixmap(*tmp_pm);
  QToolTip::add(pb1, tr("Set drawing color"));
  connect(pb1, SIGNAL(pressed()), this, SLOT(NewColor()) );

  ltList = new QComboBox(false, fileTools);
  QToolTip::add(ltList, tr("Set line thickness"));
  QWhatsThis::add(ltList, tr("Set Line Thickness") );
  QPixmap px1;
  QBitmap mask0(12, 12);
  mask0.fill(Qt::color0);
  px1 = QPixmap(line1);
  px1.setMask(mask0);
  ltList->insertItem(line1, "1");
  ltList->insertItem(line2, "2");
  ltList->insertItem(line3, "3");
  ltList->insertItem(line4, "4");
  ltList->insertItem(line5, "5");
  connect(ltList, SIGNAL(activated(int)), this, SLOT(SetThick(int)) );

  fontList = new QComboBox(false, fileTools);
  QToolTip::add(fontList, tr("Set font"));
  QWhatsThis::add(fontList, tr("Set Font") );
  fontList->insertItem( "Courier" );
  fontList->insertItem( "Helvetica" );
  fontList->insertItem( "Times" );
  fontList->setCurrentItem(1);
  connect(fontList, SIGNAL(activated(int)), this, SLOT(SetFont(int)) );

  fontSizeList = new QComboBox(false, fileTools);
  QToolTip::add(fontSizeList, tr("Set font size"));
  QWhatsThis::add(fontSizeList, tr("Set Font Size") );
  fontSizeList->insertItem(QString("8"));
  fontSizeList->insertItem(QString("10"));
  fontSizeList->insertItem(QString("12"));
  fontSizeList->insertItem(QString("14"));
  fontSizeList->insertItem(QString("18"));
  fontSizeList->insertItem(QString("24"));
  fontSizeList->insertItem(QString("32"));
  fontSizeList->setCurrentItem(2);
  connect(fontSizeList, SIGNAL(activated(int)), this, SLOT(SetFont(int)) );

  superIcon = QPixmap( boldtool_xpm );
  myfactory->setPixmap("boldtool", superIcon );
  Bold
    = new QToolButton( superIcon, tr("Make selected text <b>bold</b>"), 
		       QString::null, r, SLOT(Bold()), fileTools, "bold" );
  Bold->hide();

  superIcon = QPixmap( italictool_xpm );
  myfactory->setPixmap("italictool", superIcon );
  Italic
    = new QToolButton( superIcon, tr("<i>Italicize</i> selected text"), 
		       QString::null, r, SLOT(Italic()), fileTools, "italic" );
  Italic->hide();

  superIcon = QPixmap( underlinetool_xpm );
  myfactory->setPixmap("underlinetool", superIcon );
  Underline
    = new QToolButton( superIcon, tr("Underline selected text"), QString::null,
		       r, SLOT(Underline()), fileTools, "underline" );
  Underline->hide();

  superIcon = QPixmap( superscript_xpm );
  myfactory->setPixmap("supericon", superIcon );
  superScript
    = new QToolButton( superIcon, tr("Superscript selected text"), 
		       QString::null, r, SLOT(Superscript()), fileTools, 
		       "superscript" );
  superScript->hide();

  subIcon = QPixmap( subscript_xpm );
  myfactory->setPixmap("subicon", subIcon );
  subScript
    = new QToolButton( subIcon, tr("Subscript selected text"), QString::null,
		       r, SLOT(Subscript()), fileTools, "subscript" );
  subScript->hide();

  QToolButton *wt = QWhatsThis::whatsThisButton( fileTools );
  myfactory->setPixmap( "whatsthisicon", *(wt->pixmap()) );

  // left side toolbar
  drawTools = new QToolBar(this, "draw operations");
  moveToolBar(drawTools, QMainWindow::Left);
  selectIcon = QPixmap( selecttool );
  myfactory->setPixmap("selecttoolicon", selectIcon );
  QToolButton * selectObjects
    = new QToolButton( selectIcon, tr("Select"), QString::null,
		       r, SLOT(setMode_Select()), drawTools, "select" );
  QWhatsThis::add(selectObjects, selectToolText);

  drawBoxIcon = QPixmap( eraseIcon );
  myfactory->setPixmap("erasetoolicon", drawBoxIcon );
  QToolButton * drawBox
    = new QToolButton( drawBoxIcon, tr("Erase"), QString::null,
		       r, SLOT(setMode_Erase()), drawTools, "erase" );
  QWhatsThis::add(drawBox, eraseToolText);

  drawLineIcon = QPixmap( linetool );
  myfactory->setPixmap("linetoolicon", drawLineIcon );
  QToolButton * drawLine
    = new QToolButton( drawLineIcon, tr("Draw line"), QString::null,
		       r, SLOT(setMode_DrawLine()), drawTools, 
		       "draw line" );
  QWhatsThis::add(drawLine, lineToolText);

  dashIcon = QPixmap( dashtool );
  myfactory->setPixmap("dashtoolicon", dashIcon );
  QToolButton * drawDashLine
    = new QToolButton( dashIcon, tr("Draw dashed line"), QString::null,
		       r, SLOT(setMode_DrawDashLine()), drawTools, 
		       "draw dashed line" );
  QWhatsThis::add(drawDashLine, dashLineToolText);

  upLineIcon = QPixmap( uptool );
  myfactory->setPixmap("uplinetoolicon", upLineIcon );
  QToolButton * drawUpLine
    = new QToolButton( upLineIcon, tr("Draw stereo-up line"), QString::null,
		       r, SLOT(setMode_DrawUpLine()), drawTools, 
		       "draw stereo-up line" );
  QWhatsThis::add(drawUpLine, upLineToolText);

  downLineIcon = QPixmap( downtool );
  myfactory->setPixmap("downlinetoolicon", downLineIcon );
  QToolButton * drawDownLine
    = new QToolButton( downLineIcon, tr("Draw stereo-down line"), 
		       QString::null, r, SLOT(setMode_DrawDownLine()), 
		       drawTools, "draw stereo-down line" );
  QWhatsThis::add(drawDownLine, downLineToolText);

  arrowIcon = QPixmap( arrowtool );
  myfactory->setPixmap("arrowtoolicon", arrowIcon );
  QToolButton * drawArrowLine
    = new QToolButton( arrowIcon, tr("Draw arrow"), QString::null,
		       this, SLOT(DrawRegularArrow()), drawTools, 
		       "draw arrow" );
  drawArrowLine->setPopup(BuildArrowMenu());
  drawArrowLine->setPopupDelay(200);
  QWhatsThis::add(drawArrowLine, arrowToolText);

  curveArrowIcon = QPixmap( curvearrowtool_xpm );
  myfactory->setPixmap("curvearrowtoolicon", curveArrowIcon );
  QToolButton * drawCArrow
    = new QToolButton( curveArrowIcon, tr("Draw curved arrow"), QString::null,
		       this, SLOT(Dummy()), drawTools, 
		       "draw curved arrow" );
  drawCArrow->setPopup(BuildCurveArrowMenu());
  drawCArrow->setPopupDelay(1);
  QWhatsThis::add(drawCArrow, cArrowToolText);

  bracketIcon = QPixmap( brackettool );
  myfactory->setPixmap("brackettoolicon", bracketIcon );
  QToolButton * drawBracket
    = new QToolButton( bracketIcon, tr("Draw bracket"), QString::null,
		       this, SLOT(DrawSquareBracket()), drawTools, 
		       "draw bracket" );
  drawBracket->setPopup(BuildBracketMenu());
  drawBracket->setPopupDelay(200);
  QWhatsThis::add(drawBracket, bracketToolText);

  textIcon = QPixmap( texttool );
  myfactory->setPixmap("texttoolicon", textIcon );
  QToolButton * drawText
    = new QToolButton( textIcon, tr("Draw or edit text"), QString::null,
		       r, SLOT(setMode_DrawText()), drawTools, 
		       "draw or edit text" );
  QWhatsThis::add(drawText, textToolText);

  ringIcon = QPixmap( ringtool );
  myfactory->setPixmap("ringtoolicon", ringIcon );
  QToolButton * drawRing
    = new QToolButton( ringIcon, tr("Draw ring"), QString::null,
		       this, SLOT(MakeRingDialog()), drawTools, 
		       "draw ring" );
  drawRing->setPopup(BuildNewRingMenu());
  drawRing->setPopupDelay(150);
  QWhatsThis::add(drawRing, ringToolText);

  symbolIcon = QPixmap( symboltool );
  myfactory->setPixmap("symboltoolicon", symbolIcon );
  QToolButton * drawSymbol
    = new QToolButton( symbolIcon, tr("Draw symbol"), QString::null,
		       this, SLOT(Dummy()), drawTools, "draw symbol" );
  drawSymbol->setPopup(BuildSymbolMenu());
  drawSymbol->setPopupDelay(1);
  QWhatsThis::add(drawSymbol, symbolToolText);

  // second (left? right?) toolbar - predefined rings
  ringTools = new QToolBar( this, "canned structures" );
  ringTools->setLabel( tr( "Canned Structures" ) );
  moveToolBar(ringTools, QMainWindow::Left);

  XDC_ToolButton *b1;
  QBitmap mask1(24, 24);
  mask1.fill(Qt::color1);

  b1 = new XDC_ToolButton( ringTools, "cyclopropane.cml");
  QToolTip::add(b1, tr("Cyclopropane") );
  px1 = QPixmap(n3ring);
  px1.setMask(mask1);
  b1->setPixmap( px1 );
  connect( b1, SIGNAL(pressed()), b1, SLOT(trigger()));
  connect( b1, SIGNAL(IncludeFile(QString)), this, 
	   SLOT(FromRingToolbar(QString)) );
  b1 = new XDC_ToolButton( ringTools, "cyclobutane.cml");
  QToolTip::add(b1, tr("Cyclobutane") );
  px1 = QPixmap(n4ring);
  px1.setMask(mask1);
  b1->setPixmap( px1 );
  connect( b1, SIGNAL(pressed()), b1, SLOT(trigger()));
  connect( b1, SIGNAL(IncludeFile(QString)), this, 
	   SLOT(FromRingToolbar(QString)) );
  b1 = new XDC_ToolButton( ringTools, "cyclopentane.cml");
  QToolTip::add(b1, tr("Cyclopentane") );
  px1 = QPixmap(n5ring);
  px1.setMask(mask1);
  b1->setPixmap( px1 );
  connect( b1, SIGNAL(pressed()), b1, SLOT(trigger()));
  connect( b1, SIGNAL(IncludeFile(QString)), this, 
	   SLOT(FromRingToolbar(QString)) );
  b1 = new XDC_ToolButton( ringTools, "cyclopentadiene.cml");
  QToolTip::add(b1, tr("Cyclopentadiene") );
  px1 = QPixmap(n5ring_diene);
  px1.setMask(mask1);
  b1->setPixmap( px1 );
  connect( b1, SIGNAL(pressed()), b1, SLOT(trigger()));
  connect( b1, SIGNAL(IncludeFile(QString)), this, 
	   SLOT(FromRingToolbar(QString)) );
  b1 = new XDC_ToolButton( ringTools, "cyclohexane.cml");
  QToolTip::add(b1, tr("Cyclohexane") );
  px1 = QPixmap(n6ring);
  px1.setMask(mask1);
  b1->setPixmap( px1 );
  connect( b1, SIGNAL(pressed()), b1, SLOT(trigger()));
  connect( b1, SIGNAL(IncludeFile(QString)), this, 
	   SLOT(FromRingToolbar(QString)) );
  b1 = new XDC_ToolButton( ringTools, "6ring_chair.cml");
  QToolTip::add(b1, tr("Cyclohexane - chair conformation") );
  px1 = QPixmap(n6ring_chair);
  px1.setMask(mask1);
  b1->setPixmap( px1 );
  connect( b1, SIGNAL(pressed()), b1, SLOT(trigger()));
  connect( b1, SIGNAL(IncludeFile(QString)), this, 
	   SLOT(FromRingToolbar(QString)) );
  b1 = new XDC_ToolButton( ringTools, "6ring_boat.cml");
  QToolTip::add(b1, tr("Cyclohexane - boat conformation") );
  px1 = QPixmap(n6ring_boat);
  px1.setMask(mask1);
  b1->setPixmap( px1 );
  connect( b1, SIGNAL(pressed()), b1, SLOT(trigger()));
  connect( b1, SIGNAL(IncludeFile(QString)), this, 
	   SLOT(FromRingToolbar(QString)) );
  b1 = new XDC_ToolButton( ringTools, "benzene.cml");
  QToolTip::add(b1, tr("Benzene") );
  px1 = QPixmap(n6ring_benzene);
  px1.setMask(mask1);
  b1->setPixmap( px1 );
  connect( b1, SIGNAL(pressed()), b1, SLOT(trigger()));
  connect( b1, SIGNAL(IncludeFile(QString)), this, 
	   SLOT(FromRingToolbar(QString)) );

  // menus
  QPopupMenu * file = new QPopupMenu( this );
  menuBar()->insertItem( tr("&File"), file );

  file->insertItem( tr("&New"), this, SLOT(newDoc()), CTRL+Key_N );

  id = file->insertItem( openIcon, tr("&Open"),
			 this, SLOT(load()), CTRL+Key_O );
  file->setWhatsThis( id, fileOpenText );

#if QT_VERSION >= 300
  id = file->insertItem( tr("&Find on Internet"), this,
			 SLOT(MakeNetDialog()), CTRL+Key_F );
#endif
  id = file->insertItem( saveIcon, tr("&Save"), 
			 this, SLOT(save()), CTRL+Key_S );
  file->setWhatsThis( id, fileSaveText );
  id = file->insertItem( tr("Save &as..."), this, SLOT(saveAs()) );
  file->setWhatsThis( id, fileSaveText );
  id = file->insertItem( tr("Save picture..."), this, SLOT(savePicture()) );
  file->insertSeparator();
  id = file->insertItem( tr("Pa&ge setup"), this , SLOT(PageSetup()) );
  id = file->insertItem( printIcon, tr("&Print"),
			 this, SLOT(print()), CTRL+Key_P );
  file->setWhatsThis( id, filePrintText );
  file->insertSeparator();
  file->insertItem( tr("Close"), this, SLOT(close()), CTRL+Key_W );
  file->insertItem( tr("Quit"), qApp, SLOT( closeAllWindows() ), CTRL+Key_Q );

  QPopupMenu * rotateSub = new QPopupMenu(this);
  rotateSub->insertItem( tr("Rotate 90 degrees clockwise"), this, 
			 SLOT(Rotate90()) );
  rotateSub->insertItem( tr("Rotate 180 degrees"), this, SLOT(Rotate180()) );
  rotateSub->insertItem( tr("Rotate 90 degrees counterclockwise"), this, 
			 SLOT(Rotate270()) );

  QPopupMenu * flipSub = new QPopupMenu(this);
  id = flipSub->insertItem( tr("Flip &horizontal"), this, SLOT(FlipH()) );
  id = flipSub->insertItem( tr("Flip &vertical"), this, SLOT(FlipV()) );

  QPopupMenu * edit = new QPopupMenu(this);
  menuBar()->insertItem(tr("&Edit"), edit);

  edit->insertItem(tr("&Undo"), this, SLOT(Undo()), CTRL+Key_Z);
  edit->insertSeparator();
  edit->insertItem(tr("Cu&t"), this, SLOT(Cut()), CTRL+Key_X);
  edit->insertItem(tr("&Copy"), this, SLOT(Copy()), CTRL+Key_C);
  edit->insertItem(tr("&Paste"), this, SLOT(Paste()), CTRL+Key_V);
  edit->insertItem(tr("Clear"), this, SLOT(Clear()), Key_Delete);
  edit->insertSeparator();
  edit->insertItem(tr("Select &All"), this, SLOT(SelectAll()), CTRL+Key_A);
  edit->insertItem(tr("&Rotate"), rotateSub );
  edit->insertItem(tr("&Flip"), flipSub );

  format = new QPopupMenu(this);
  format->setCheckable(true);
  menuBar()->insertItem(tr("Forma&t"), format);

  fixlen_bond = format->insertItem(tr("&Bond - Fixed length and angle"),this,
			      SLOT(setFixed_bond()) );
  format->setItemChecked(fixlen_bond, true);	
  fixlen_arrow = format->insertItem(tr("&Arrow - Fixed length and angle"),this,
			      SLOT(setFixed_arrow()) );
  format->setItemChecked(fixlen_arrow, true);	
  format->insertItem(tr("&Set fixed length and angle"), this, 
		     SLOT(ShowFixedDialog()));
  format->insertSeparator();
  format->insertItem(tr("Set &background color"), this, 
		     SLOT(BackgroundColor()) );

  QPopupMenu * tools = new QPopupMenu(this);
  menuBar()->insertItem(tr("T&ools"), tools);
  tools->insertItem( tr("Clean up molecule"), this, SLOT(CleanUpMolecule()) );
  tools->insertItem(tr("Auto &layout"), this, SLOT(AutoLayout()), CTRL+Key_L );
  tools->insertSeparator();
  tools->insertItem(tr("Calculate empirical formula"), this, SLOT(CalcEF()) );
  tools->insertItem(tr("Calculate molecular weight"), this, SLOT(CalcMW()) );
  tools->insertItem(tr("Elemental analysis"), this, SLOT(CalcEA()) );
  //tools->insertItem("IUPAC name", this, SLOT(CalcName()) );
  //tools->insertItem("Predict 1H NMR", this, SLOT(Calc1HNMR()) );
  tools->insertItem(tr("Predict 13C NMR"), this, SLOT(Calc13CNMR()) );
  tools->insertItem(tr("Predict IR"), this, SLOT(CalcIR()) );
  tools->insertSeparator();
  tools->insertItem(tr("Input SMILES"), this, SLOT(FromSMILES()) );
  if (use_babel)
    tools->insertItem(tr("Output SMILES"), this, SLOT(ToSMILES()) );

  QPopupMenu * help = new QPopupMenu( this );
  menuBar()->insertSeparator();
  menuBar()->insertItem( tr("&Help"), help );

  help->insertItem( tr("&Manual"), this, SLOT(Manual()), Key_F1 );
  help->insertItem( tr("&About..."), this, SLOT(about()) );
  help->insertItem( tr("&References..."), this, SLOT(Refs()) );
  help->insertSeparator();
  help->insertItem( tr("What's &This"),this,SLOT(whatsThis()), SHIFT+Key_F1 );

  // create data system
  c = new ChemData(clip);

  // connect (non-Qt) data center and render widget
  r->setChemData(c);
  c->setRender2D(r);
  // connect renderer to application window
  connect(r, SIGNAL(TextOn(QFont)), this, SLOT(ShowTextButtons(QFont)) );
  connect(r, SIGNAL(TextOff()), this, SLOT(HideTextButtons()) );
  connect( r, SIGNAL(SignalSetStatusBar(QString)),
	   this, SLOT(SetStatusBar(QString)) );
  connect( c, SIGNAL(SignalSetStatusBar(QString)),
	   this, SLOT(SetStatusBar(QString)) );

  setCentralWidget( sv );
  statusBar()->message( "Ready" );
  resize( 640, 640 );
}

QPopupMenu *ApplicationWindow::BuildRingMenu() {
  QPopupMenu * ringSub = new QPopupMenu(this);
  QDir d(RingDir, "*.png");
  ringlist = d.entryList();
  for (int cc = 0; cc < ringlist.count(); cc++) {
    ringSub->insertItem( QPixmap( QString(RingDir + ringlist[cc]) ),
			 this, SLOT(FromRingMenu(int)), 0, cc );
  }
  return ringSub;
}

QPopupMenu *ApplicationWindow::BuildSymbolMenu() {
  QPopupMenu * symbolSub = new QPopupMenu(this);
  QPixmap p1;
  p1 = QPixmap(sym_plus_xpm);
  symbollist.append(QString("sym_plus"));
  symbolSub->insertItem( p1, this, SLOT(FromSymbolMenu(int)), 0, 0);
  p1 = QPixmap(sym_minus_xpm);
  symbollist.append(QString("sym_minus"));
  symbolSub->insertItem( p1, this, SLOT(FromSymbolMenu(int)), 0, 1);
  p1 = QPixmap(sym_delta_plus_xpm);
  symbollist.append(QString("sym_delta_plus"));
  symbolSub->insertItem( p1, this, SLOT(FromSymbolMenu(int)), 0, 2);
  p1 = QPixmap(sym_delta_minus_xpm);
  symbollist.append(QString("sym_delta_minus"));
  symbolSub->insertItem( p1, this, SLOT(FromSymbolMenu(int)), 0, 3);
  p1 = QPixmap(sym_1e_xpm);
  symbollist.append(QString("sym_1e"));
  symbolSub->insertItem( p1, this, SLOT(FromSymbolMenu(int)), 0, 4);
  p1 = QPixmap(sym_2e_xpm);
  symbollist.append(QString("sym_2e"));
  symbolSub->insertItem( p1, this, SLOT(FromSymbolMenu(int)), 0, 5);
  return symbolSub;
}

QPopupMenu *ApplicationWindow::BuildArrowMenu() {
  QPopupMenu * arrowSub = new QPopupMenu(this);
  QPixmap p1;
  p1 = QPixmap(arrow_regular_xpm);
  arrowlist.append(QString("REGULAR"));
  arrowSub->insertItem( p1, this, SLOT(FromArrowMenu(int)), 0, 0);
  p1 = QPixmap(arrow_dash_xpm);
  arrowlist.append(QString("DASH"));
  arrowSub->insertItem( p1, this, SLOT(FromArrowMenu(int)), 0, 1);
  p1 = QPixmap(arrow_bi1_xpm);
  arrowlist.append(QString("BI1"));
  arrowSub->insertItem( p1, this, SLOT(FromArrowMenu(int)), 0, 2);
  p1 = QPixmap(arrow_bi2_xpm);
  arrowlist.append(QString("BI2"));
  arrowSub->insertItem( p1, this, SLOT(FromArrowMenu(int)), 0, 3);
  p1 = QPixmap(arrow_retro_xpm);
  arrowlist.append(QString("RETRO"));
  arrowSub->insertItem( p1, this, SLOT(FromArrowMenu(int)), 0, 4);
  return arrowSub;
}

QPopupMenu *ApplicationWindow::BuildCurveArrowMenu() {
  QPopupMenu * arrowSub = new QPopupMenu(this);
  QPixmap p1;
  p1 = QPixmap(cw90_xpm);
  curvearrowlist.append(QString("CW90"));
  arrowSub->insertItem( p1, this, SLOT(FromCurveArrowMenu(int)), 0, 0);
  p1 = QPixmap(ccw90_xpm);
  curvearrowlist.append(QString("CCW90"));
  arrowSub->insertItem( p1, this, SLOT(FromCurveArrowMenu(int)), 0, 1);
  p1 = QPixmap(cw180_xpm);
  curvearrowlist.append(QString("CW180"));
  arrowSub->insertItem( p1, this, SLOT(FromCurveArrowMenu(int)), 0, 2);
  p1 = QPixmap(ccw180_xpm);
  curvearrowlist.append(QString("CCW180"));
  arrowSub->insertItem( p1, this, SLOT(FromCurveArrowMenu(int)), 0, 3);
  p1 = QPixmap(cw270_xpm);
  curvearrowlist.append(QString("CW270"));
  arrowSub->insertItem( p1, this, SLOT(FromCurveArrowMenu(int)), 0, 4);
  p1 = QPixmap(ccw270_xpm);
  curvearrowlist.append(QString("CCW270"));
  arrowSub->insertItem( p1, this, SLOT(FromCurveArrowMenu(int)), 0, 5);
  return arrowSub;
}

QPopupMenu *ApplicationWindow::BuildBracketMenu() {
  QPopupMenu * bracketSub = new QPopupMenu(this);
  QPixmap p1;
  p1 = QPixmap(squarebracket_xpm);
  bracketlist.append(QString("SQUARE"));
  bracketSub->insertItem( p1, this, SLOT(FromBracketMenu(int)), 0, 0);
  p1 = QPixmap(curvebracket_xpm);
  bracketlist.append(QString("CURVE"));
  bracketSub->insertItem( p1, this, SLOT(FromBracketMenu(int)), 0, 1);
  p1 = QPixmap(bracebracket_xpm);
  bracketlist.append(QString("BRACE"));
  bracketSub->insertItem( p1, this, SLOT(FromBracketMenu(int)), 0, 2);
  return bracketSub;
}

void ApplicationWindow::FromRingMenu(int x) {
  //QString dname(RINGHOME);
  //if (dname.left(1) != QString("/"))
  //  dname.append(QString("/"));
  c->StartUndo(0,0);
  c->DeselectAll();
  c->SetTopLeft(sv->viewportToContents(QPoint(0,0)));
  QString fname( ringlist[x] );
  fname.replace(fname.length() - 3, 3, QString("cml"));
  c->load( RingDir + fname );
  r->Inserted();
}

void ApplicationWindow::FromRingToolbar(QString fi) {
  c->StartUndo(0,0);
  c->DeselectAll();
  c->load( RingDir + fi );
  r->Inserted();
}

void ApplicationWindow::FromSymbolMenu(int x) {
  r->setMode_DrawSymbol( symbollist[x] );
}

void ApplicationWindow::FromArrowMenu(int x) {
  r->setMode_DrawArrow( arrowlist[x] );
}

void ApplicationWindow::FromCurveArrowMenu(int x) {
  r->setMode_DrawCurveArrow( curvearrowlist[x] );
}

void ApplicationWindow::FromBracketMenu(int x) {
  r->setMode_DrawBracket( bracketlist[x] );
}

void ApplicationWindow::setFixed_arrow()
{
  if (format->isItemChecked(fixlen_arrow)) {
    format->setItemChecked(fixlen_arrow, false);
    r->setFixed_arrow(false);
  } else {
    format->setItemChecked(fixlen_arrow, true);	
    r->setFixed_arrow(true);
  }
}

void ApplicationWindow::setFixed_bond()
{
  if (format->isItemChecked(fixlen_bond)) {
    format->setItemChecked(fixlen_bond, false);
    r->setFixed_bond(false);
  } else {
    format->setItemChecked(fixlen_bond, true);	
    r->setFixed_bond(true);
  }
}

ApplicationWindow::~ApplicationWindow()
{
    delete printer;
}

void ApplicationWindow::SetFont(int m) {
  // read new font setting from combo boxes and pass to r  
  QFont f(fontList->currentText(), fontSizeList->currentText().toInt());
  cout << f.family() << f.pointSize() << endl;
  r->SetFont(f);
}

void ApplicationWindow::SetColor(int m) {
  if (m == 0) r->SetColor(QColor(0,0,0));
  if (m == 1) r->SetColor(QColor(127,0,0));
  if (m == 2) r->SetColor(QColor(0,127,0));
  if (m == 3) r->SetColor(QColor(0,0,127));
}

void ApplicationWindow::SetThick(int t) {
  r->SetThick(t + 1);
}

void ApplicationWindow::ShowTextButtons(QFont infont) {
  Bold->show();
  Italic->show();
  Underline->show();
  superScript->show();
  subScript->show();
  // set font combo boxes to object font (passed as infont)
  if (infont.family().lower() == QString("courier"))
    fontList->setCurrentItem(0);
  if (infont.family().lower() == QString("helvetica"))
    fontList->setCurrentItem(1);
  if (infont.family().lower() == QString("times"))
    fontList->setCurrentItem(2);
  if (infont.pointSize() == 8) fontSizeList->setCurrentItem(0);
  if (infont.pointSize() == 10) fontSizeList->setCurrentItem(1);
  if (infont.pointSize() == 12) fontSizeList->setCurrentItem(2);
  if (infont.pointSize() == 14) fontSizeList->setCurrentItem(3);
  if (infont.pointSize() == 18) fontSizeList->setCurrentItem(4);
  if (infont.pointSize() == 24) fontSizeList->setCurrentItem(5);
  if (infont.pointSize() == 32) fontSizeList->setCurrentItem(6);
}

void ApplicationWindow::HideTextButtons() {
  Bold->hide();
  Italic->hide();
  Underline->hide();
  superScript->hide();
  subScript->hide();
  // set font combo boxes to current font
  QFont infont = r->GetFont();
  if (infont.family().lower() == QString("courier"))
    fontList->setCurrentItem(0);
  if (infont.family().lower() == QString("helvetica"))
    fontList->setCurrentItem(1);
  if (infont.family().lower() == QString("times"))
    fontList->setCurrentItem(2);
  if (infont.pointSize() == 8) fontSizeList->setCurrentItem(0);
  if (infont.pointSize() == 10) fontSizeList->setCurrentItem(1);
  if (infont.pointSize() == 12) fontSizeList->setCurrentItem(2);
  if (infont.pointSize() == 14) fontSizeList->setCurrentItem(3);
  if (infont.pointSize() == 18) fontSizeList->setCurrentItem(4);
  if (infont.pointSize() == 24) fontSizeList->setCurrentItem(5);
  if (infont.pointSize() == 32) fontSizeList->setCurrentItem(6);
}

void ApplicationWindow::newDoc()
{
  ApplicationWindow *ed = new ApplicationWindow(clip);
  ed->show();
}

void ApplicationWindow::load()
{
  QFileDialog fd(QString::null, QString::null, 0, 0, TRUE);
  fd.setCaption("Load file");
  fd.setMode(QFileDialog::ExistingFile);
  QStringList filters;
  filters.append("All files (*)");
  filters.append("XDrawChem native (*.xdc)");
  filters.append("MDL Molfile (*.mol)");
  filters.append("CML - Chemical Markup Language (*.cml)");
  if (use_babel) {
    filters.append("Protein Data Bank (*.pdb;*.ent)");
    filters.append("Sybyl Mol2 (*.mol2)");
  }
  fd.setFilters(filters);  
  if ( fd.exec() == QDialog::Accepted )
    load( fd.selectedFile() );
}


void ApplicationWindow::load( QString fileName )
{
  QString realFileName = fileName;

  QFile f(fileName);
  if ( !f.open(IO_ReadOnly) ) {
    QMessageBox::warning(0, tr("Couldn't open file"), tr("Could not open the file: ") + fileName);
    statusBar()->message(tr("Unable to load ") + fileName);
    return;
  }
  f.close();
  SelectAll();
  Clear();

  bool babel_called = false;

  if (fileName.right(4).upper() == ".PDB") {
    fileName = ConvertToMolfile(fileName);
    babel_called = true;
  }
  if (fileName.right(4).upper() == ".ENT") {
    fileName = ConvertToMolfile(fileName);
    babel_called = true;
  }
  if (fileName.right(5).upper() == ".MOL2") {
    fileName = ConvertToMolfile(fileName);
    babel_called = true;
  }

  if ( !c->load(fileName) ) {
    statusBar()->message(tr("Unable to load ") + fileName);
    return;
  }
  
#ifdef UNIX
  if (babel_called) {
    FILE *test1;
    QString cmdl = QString("rm ") + fileName;
    test1 = popen(cmdl.latin1(), "r");
    int rv = pclose(test1);
    cout << "pclose():" << rv << endl;
  }
#endif

  fileName = realFileName;
  setCaption( QString(XDC_VERSION) + QString(" - ") + fileName );
  statusBar()->message( tr("Loaded document ") + fileName );
  filename = fileName;
  c->DeselectAll();
  r->repaint();
}


void ApplicationWindow::save()
{
  if ( filename.isEmpty() ) {
    saveAs();
    return;
  }

  bool call_babel = false;
  QString xdc_out, realFileName = filename;

  if (filename.right(4).upper() == ".PDB") call_babel = true;
  if (filename.right(4).upper() == ".ENT") call_babel = true;
  if (filename.right(5).upper() == ".MOL2") call_babel = true;

  if (use_babel == false) call_babel = false;

#ifdef UNIX
  if (call_babel) {
    srand(time(NULL));

    xdc_out.setNum(rand());
    xdc_out.prepend("/tmp/");
    xdc_out.append(".mol");
    filename = xdc_out;
  }
#endif

  if ( !c->save(filename) ) {
    statusBar()->message( tr("Could not write to ") + filename );
    return;
  }

  filename = realFileName;
  
  if (call_babel) {
    ConvertFromMolfile(xdc_out, filename);
  }

  setCaption( QString(XDC_VERSION) + QString(" - ") + filename );
  
  statusBar()->message( tr( "Saved file ") + filename );
}


void ApplicationWindow::saveAs()
{
 QFileDialog fd(QString::null, QString::null, 0, 0, TRUE);
  fd.setCaption(tr("Save file as..."));
  fd.setMode(QFileDialog::AnyFile);
  QStringList filters;
  filters.append("XDrawChem native (*.xdc)");
  filters.append("MDL Molfile (*.mol)");
  filters.append("CML - Chemical Markup Language (*.cml)");
  //filters.append("ChemDraw binary format (*.cdx)");
  filters.append("ChemDraw XML (*.cdxml)");
  //filters.append("Encapsulated PostScript (*.eps)");
  if (use_babel) {
    filters.append("Protein Data Bank (*.pdb;*.ent)");
    filters.append("Sybyl Mol2 (*.mol2)");
  }
  fd.setFilters(filters);  
  if ( fd.exec() == QDialog::Accepted ) {
    filename = fd.selectedFile();
    QString tmpx = filename.right(4).lower();
    if ( (tmpx != QString(".xdc")) &&
	 (tmpx != QString(".mol")) &&
	 (tmpx != QString(".cdx")) &&
	 (tmpx != QString(".pdb")) &&
	 (tmpx != QString(".ent")) &&
	 (tmpx != QString("mol2")) &&
	 (tmpx != QString("dxml")) &&
	 (tmpx != QString(".cml")) ) {
      if (fd.selectedFilter().left(3) == QString("XDr"))
	filename.append(".xdc");
      if (fd.selectedFilter().left(3) == QString("MDL"))
	filename.append(".mol");
      if (fd.selectedFilter().left(3) == QString("CML"))
	filename.append(".cml");
      if (fd.selectedFilter().left(3) == QString("Pro"))
	filename.append(".pdb");
      if (fd.selectedFilter().left(3) == QString("Syb"))
	filename.append(".mol2");
      if (fd.selectedFilter().left(12) == QString("ChemDraw bin"))
	filename.append(".cdx");
      if (fd.selectedFilter().left(12) == QString("ChemDraw XML"))
	filename.append(".cdxml");
    }
    save();
  }
}

void ApplicationWindow::savePicture()
{
  int pm = 0;
  bool was_saved;
  QString picfile;

  QFileDialog fd(QString::null, QString::null, 0, 0, TRUE);
  fd.setCaption(tr("Save as picture..."));
  fd.setMode(QFileDialog::AnyFile);
  QStringList filters;
  filters.append("Portable Network Graphic (*.png)");
  filters.append("Windows Bitmap (*.bmp)");
  filters.append("Encapsulated PostScript (*.eps)");
  filters.append("Scalable Vector Graphics (*.svg)");
  fd.setFilters(filters);  
  if ( fd.exec() == QDialog::Accepted ) {
    picfile = fd.selectedFile();
    QString tmpx = picfile.right(4).lower();
    if (tmpx == QString(".png")) pm = 1;
    if (tmpx == QString(".bmp")) pm = 2;
    if (tmpx == QString(".svg")) pm = 3;
    if ( (tmpx != QString(".png")) &&
	 (tmpx != QString(".bmp")) &&
	 (tmpx != QString(".svg")) &&
	 (tmpx != QString(".eps")) ) {
      if (fd.selectedFilter().left(3) == QString("Por")) {
	picfile.append(".png"); pm = 1;
      }
      if (fd.selectedFilter().left(3) == QString("Win")) {
	picfile.append(".bmp"); pm = 2;
      }
      if (fd.selectedFilter().left(3) == QString("Enc")) {
	picfile.append(".eps");
      }
      if (fd.selectedFilter().left(3) == QString("Sca")) {
	picfile.append(".svg"); pm = 3;
      }
    }
    if (pm == 3) {
      // save as Scalable Vector Graphics
      was_saved = r->SaveSVG(picfile);
      if (was_saved)
	statusBar()->message( tr("Saved picture file ") + picfile );
      else
	statusBar()->message(tr("Unable to save picture!"));
      return;
    }
    if (pm != 0) {
      QPixmap tosave = r->MakePixmap();
      if (pm == 1) // PNG
	was_saved = tosave.save(picfile, "PNG");
      if (pm == 2) // BMP
	was_saved = tosave.save(picfile, "BMP");
      if (was_saved)
	statusBar()->message( tr("Saved picture file ") + picfile );
      else
	statusBar()->message(tr("Unable to save picture!"));
    } else { // save as EPS
      was_saved = r->SaveEPS(picfile);
      if (was_saved)
	statusBar()->message( tr("Saved picture file ") + picfile );
      else
	statusBar()->message(tr("Unable to save picture!"));
    }
  }
}

void ApplicationWindow::print()
{
  r->Print();
}

void ApplicationWindow::closeEvent( QCloseEvent* ce )
{
    if ( !c->edited() ) {
	ce->accept();
	return;
    }

    switch( QMessageBox::information( this, "XDrawChem question",
				      "The document has been changed since "
				      "the last save.",
				      "Save Now", "Cancel", "Leave Anyway",
				      0, 1 ) ) {
    case 0:
	save();
	ce->accept();
	break;
    case 1:
    default: // just for sanity
	ce->ignore();
	break;
    case 2:
	ce->accept();
	break;
    }
}


void ApplicationWindow::about()
{
    QMessageBox::about( this, XDC_VERSION,
			QString(XDC_VERSION) + tr("\nBryan Herger\nherger@chemistry.gatech.edu\n\nPlease subscribe to the mailing list for information about future releases.\nSend a message to xdrawchem-announce-request@lists.sourceforge.net with 'subscribe' as the subject.\n\nPortions copyright (C) 1997-2000 Dr. Christoph Steinbeck and the JChemPaint project\nSee file LICENSE.txt for more details") );
}

const char * reflist = 
"Krause S, Willighagen E, Steinbeck C, "
"\"JChemPaint - Using the Collaborative Forces of the Internet\nto Develop "
"a Free Editor for 2D Chemical Structures\", Molecules 5:93-98\n\n"
"Bremser W, \"HOSE - A Novel Substructure Code\", Anal. Chim. Acta 103:"
"355-365\n\n"
"Bremser W, \"Expectation Ranges of 13C NMR Chemical Shifts\", "
"Mag. Res. Chem. 23(4):271-275\n\n"
"Weininger D, \"SMILES, a Chemical Language and Information System.  1. Introduction to Methodology and Encoding Rules\", J. Chem. Inf. Comput. Sci. 28:31-36\n\n"
"Figueras J, \"Ring Perception Using Breadth-First Search\", J. Chem. Inf. Comput Sci. 36:986-991\n\n"
"Ugi I et al., Journal of Chemical research (M), 1991, 2601-2689\n\n"
"Steinbeck C, JMDraw (software), http://jmdraw.sourceforge.net/\n\n"
"Molecules in the XDrawChem database are from the NCI Open Database, October 1999 release:  http://cactvs.cit.nih.gov/";

void ApplicationWindow::Refs()
{
  QMessageBox::about( this, "XDrawChem References", reflist);
}

void ApplicationWindow::SetStatusBar(QString s) {
  statusBar()->message(s);
}

void ApplicationWindow::MakeRingDialog() {
  RingDialog t(this, "ring dialog");
  if ( !t.exec() ) return;

  c->StartUndo(0,0);
  c->DeselectAll();
  c->SetTopLeft(sv->viewportToContents(QPoint(0,0)));
  c->load( RingDir + t.getFile() );
  r->Inserted();
}

void ApplicationWindow::ShowFixedDialog(void) {
  double na, nl;
  FixedDialog i(this, QString("fixed_dialog"));
  i.setAngle_arrow( r->getFixedAngle_arrow() );
  i.setLength_arrow( r->getFixedLength_arrow() );
  i.setAngle_bond( r->getFixedAngle_bond() );
  i.setLength_bond( r->getFixedLength_bond() );
  if ( !i.exec() ) return;
  na = i.getAngle_arrow();
  nl = i.getLength_arrow();
  if (na < 0.0) return;
  if (nl < 0.0) return;
  r->setFixedAngleAndLength_arrow(na, nl);
  na = i.getAngle_bond();
  nl = i.getLength_bond();
  if (na < 0.0) return;
  if (nl < 0.0) return;
  r->setFixedAngleAndLength_bond(na, nl);
}

void ApplicationWindow::MakeNetDialog() {
  NetDialog n(this, "net dialog");
  if ( !n.exec() ) return;
  cout << "Server:" << n.getServer() << endl;
  cout << "Key   :" << n.getKey() << endl;
  cout << "Value :" << n.getValue() << endl;
  NetAccess na;
  setCursor(waitCursor);
  r->setWaitCursor();
  QStringList choices = na.getChoices(n.getServer(), n.getKey(), n.getValue(),
				      n.getExact() );
  setCursor(arrowCursor);
  r->setArrowCursor();
  if (choices.count() == 0) {
    QMessageBox::warning( this, tr("Database query failed"), tr("No molecules in the database match the query.") );
    return;
  }
  if (choices.count() == 1) {
    int i1 = choices[0].find("|");
    QString subfile = choices[0].left(i1) + ".mol";
    QString wf = na.getFile(n.getServer(), subfile);
    c->DeselectAll();
    c->SetTopLeft(sv->viewportToContents(QPoint(0,0)));
    c->ProcessMDL(wf);
    r->Inserted();
    return;
  }
  NetChooseDialog nc(this, "net choose dialog", choices);
  if ( !nc.exec() ) return;
  cout << nc.getFile() << endl;
  QString wf = na.getFile(n.getServer(), nc.getFile());
  if (wf.contains("file not found") > 0) {
    QMessageBox::warning( this, tr("Database query failed"), tr("An error occured.  The server cannot find the selected molecule.") );
    return;
  }
  if (nc.getFile().contains(".mol")) {
    c->DeselectAll();
    c->SetTopLeft(sv->viewportToContents(QPoint(0,0)));
    c->ProcessMDL(wf);
    r->Inserted();
    return;
  }
}

void ApplicationWindow::PageSetup() {
  PageSetupDialog p(this, "page dialog");
  p.setPageSize(r->getPageSize());
  p.setOrientation(r->getPageOrientation());
  if ( !p.exec() ) return;
  r->setPageSizeAndOrientation(p.getPageSize(), p.getOrientation());
}

void ApplicationWindow::NewColor() {
  QColor nc1 = QColorDialog::getColor(r->GetColor());
  if (nc1.isValid()) {
    r->SetColor(nc1);
    QPixmap *tmp_pm = new QPixmap(32, 20);
    tmp_pm->fill(QColor(210,210,210));
    QPainter pixpaint(tmp_pm);
    pixpaint.fillRect(2, 3, 14, 14, nc1);
    pixpaint.setPen(QColor(0,0,0));
    pixpaint.drawLine( 24, 2, 24, 16 );
    pixpaint.drawLine( 24, 16, 20, 12 );
    pixpaint.drawLine( 24, 16, 28, 12 );
    pb1->setPixmap(*tmp_pm);    
  }
}

void ApplicationWindow::BackgroundColor() {
  QColor nc1 = QColorDialog::getColor(r->getBGColor());
  if (nc1.isValid()) {
    r->setBGColor(nc1);
    r->repaint();
  }
}

QString ApplicationWindow::ConvertToMolfile(QString babel_in) {
  if (use_babel == false) return QString("");

  QString babel_cmdl, babel_out;

#ifdef UNIX
  srand(time(NULL));
#endif

  babel_out.setNum(rand());
  babel_out.prepend("/tmp/");
  babel_out.append(".mol");

  babel_cmdl = "babel ";
  if (babel_in.right(4).upper() == ".PDB") babel_cmdl.append("-ipdb ");
  if (babel_in.right(4).upper() == ".ENT") babel_cmdl.append("-ipdb ");
  if (babel_in.right(5).upper() == ".MOL2") babel_cmdl.append("-imol2 ");
  babel_cmdl.append(babel_in);
  babel_cmdl.append(" -omol ");
  babel_cmdl.append(babel_out);

  cout << babel_cmdl << endl;

#ifdef UNIX
  FILE *test1;
  test1 = popen(babel_cmdl.latin1(), "r");
  int rv = pclose(test1);
  cout << "pclose():" << rv << endl;
#endif

  return babel_out;
}

void ApplicationWindow::ConvertFromMolfile(QString xdc_out, 
					   QString babel_out) {
  QString babel_cmdl;

#ifdef UNIX
  srand(time(NULL));
#endif

  babel_cmdl = "babel -imol ";
  babel_cmdl.append(xdc_out);
  if (babel_out.right(4).upper() == ".PDB") babel_cmdl.append(" -opdb ");
  if (babel_out.right(4).upper() == ".ENT") babel_cmdl.append(" -opdb ");
  if (babel_out.right(5).upper() == ".MOL2") babel_cmdl.append(" -omol2 ");
  babel_cmdl.append(babel_out);

  cout << babel_cmdl << endl;

#ifdef UNIX
  FILE *test1;
  test1 = popen(babel_cmdl.latin1(), "r");
  int rv = pclose(test1);
  cout << "pclose(babel):" << rv << endl;
  babel_cmdl = QString("rm ") + xdc_out;
  test1 = popen(babel_cmdl.latin1(), "r");
  rv = pclose(test1);
  cout << "pclose(rm):" << rv << endl;
#endif
}

// pass thru to Render2D
void ApplicationWindow::Cut() { r->Cut(); }
void ApplicationWindow::Copy() { r->Copy(); }
void ApplicationWindow::Paste() { r->Paste(); }
void ApplicationWindow::Undo() { r->Undo(); }
void ApplicationWindow::FlipH() { r->Flip(FLIP_H); }
void ApplicationWindow::FlipV() { r->Flip(FLIP_V); }
void ApplicationWindow::Rotate90() { r->Rotate90(); }
void ApplicationWindow::Rotate180() { r->Rotate180(); }
void ApplicationWindow::Rotate270() { r->Rotate270(); }
void ApplicationWindow::Clear() { r->EraseSelected(); }
void ApplicationWindow::CalcEA() { r->Tool(MODE_TOOL_CALCEA); }
void ApplicationWindow::CalcEF() { r->Tool(MODE_TOOL_CALCEF); }
void ApplicationWindow::CalcMW() { r->Tool(MODE_TOOL_CALCMW); }
void ApplicationWindow::Calc13CNMR() { r->Tool(MODE_TOOL_13CNMR); }
void ApplicationWindow::Calc1HNMR() { r->Tool(MODE_TOOL_1HNMR); }
void ApplicationWindow::CalcIR() { r->Tool(MODE_TOOL_IR); }
void ApplicationWindow::CalcName() { r->Tool(MODE_TOOL_NAME); }
void ApplicationWindow::ToSMILES() { r->Tool(MODE_TOOL_TOSMILES); }
void ApplicationWindow::CleanUpMolecule() { r->Tool(MODE_TOOL_CLEANUPMOL); }
void ApplicationWindow::SelectAll() { r->SelectAll(); }
void ApplicationWindow::AutoLayout() { r->AutoLayout(); }
void ApplicationWindow::DrawRegularArrow() {
  r->setMode_DrawArrow( "REGULAR" );
}
void ApplicationWindow::DrawSquareBracket() {
  r->setMode_DrawBracket( "SQUARE" );
}
