// bond.h -- subclass of Drawable for lines/bonds

#ifndef BOND_H
#define BOND_H

#include <qobject.h>
#include <qrect.h>
#include "render2d.h"
#include "drawable.h"
#include "dpoint.h"

class Bond : public Drawable {
  Q_OBJECT
    public:
  Bond(Render2D *, QObject *parent = 0, const char *name = 0);
  void Render();  // draw this object
  void Edit();  // open edit window
  void RenderSide(int w) { wside = w; }
  int Type();  // return type of object
  bool Find(DPoint *); // does this Bond contain this DPoint?
  DPoint * FindNearestPoint(DPoint *, double &);
  Drawable * FindNearestObject(DPoint *, double &);
  void setPoints(DPoint *, DPoint *);
  bool Equals(Bond *);
  bool WithinRect(QRect, bool);
  int Order() { return order; }
  void setOrder(int a) { order = a; }
  int Dash() { return dashed; }
  void setDash(int d) { dashed = d; }
  int Thick() { return thick; }
  void setThick(int t) { thick = t; }
  QRect BoundingBox();
  DPoint *otherPoint(DPoint *);
 private:
  // Renderer
  Render2D *r;
  // order of bond (1-3, or 5 if up, or 7 if down)
  int order;
  // is one or more of the lines dashed
  int dashed;
  // thickness of bond
  int thick;
  // which side to draw double bond on?
  // standing at start and looking at end
  // 0 = left, 1 = right
  int wside;
};

#endif
