/****************************************************************************
** $Id: qt/examples/application/main.cpp   2.2.4   edited 2000-08-31 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#include <qapplication.h>
#include <qnetwork.h>
#include <qstring.h>
#include <qfile.h>
//#include <stdlib.h>
//#include <time.h>
#include <qtranslator.h>
#include <qtextcodec.h>

#include "application.h"
#include "clipboard.h"
#include "defs.h"

QString RingDir;

int main( int argc, char ** argv ) {
  int ae;
#ifdef UNIX
  QString dname(RINGHOME);
  if (dname.right(1) != QString("/"))
    dname.append(QString("/"));
#else
  QString dname("ring\\");
#endif
  RingDir = dname;
  QApplication a( argc, argv );
  qInitNetworkProtocols();

  // translation file for application strings
  QTranslator myapp( 0 );
  myapp.load( QString( "xdrawchem_" ) + QTextCodec::locale(), RingDir );
  a.installTranslator( &myapp );

  Clipboard *cb = new Clipboard;
  ApplicationWindow * mw = new ApplicationWindow(cb);
  mw->setCaption( QString(XDC_VERSION) + QString(" - ") + 
		  mw->tr("untitled") );
  if (argc > 1)
    mw->load(QString(argv[1]));
  mw->show();
  a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
  ae = a.exec();
  return ae;
}
