#include <iostream.h>
#include <math.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qdragobject.h>
#include <qglobal.h>

#include "render2d.h"
#include "chemdata.h"
#include "text.h"
#include "defs.h"

void Render2D::mousePressEvent(QMouseEvent *e1) {  
  DPoint *tmp_pt;
  bool allowedit = false;
  moved = false;

  tmp_pt = new DPoint(e1->x(), e1->y());
  if (mode > 100) c->StartUndo(mode, tmp_pt);
  //cout << "Click" << endl; 
  // update button state
  if (e1->button() == LeftButton) mouse1down = true;
  if (e1->button() == RightButton) {
    mouse3down = true;
  }
  //cout << "start at " << e1->x() << "," << e1->y() << endl;

  // MODE_TEXT: call special function to handle text events
  if (mode == MODE_TEXT) {
    DrawText_mousePressEvent(e1);
    return;
  }

  // MODE_SELECT: start multiple selection
  if ( (mode == MODE_SELECT) && (mouse1down) ) {
    if ( ( highlightpoint == 0) && (highlightobject == 0) ) {
      selectOrigin = e1->pos();
      mode = MODE_SELECT_MULTIPLE;
      return;
    } else {
      cout << "Should move." << endl;
      if (highlightpoint == 0)
	mode = MODE_SELECT_MOVE_OBJECT;
      else
	mode = MODE_SELECT_MOVE_POINT;
    }
    return;
  }

  // set allowedit = true for appropriate modes
  if (mode == MODE_SELECT) allowedit = true;
  // get Drawable of nearest object
  DPoint *e = new DPoint;
  e->x = e1->x(); e->y = e1->y();
  double distobj;
  Drawable *no = c->FindNearestObject(e, distobj);
  if (distobj > 5.0) no = 0;
  if (no != 0) {
    if ( (mode == MODE_DRAWLINE) && 
	 (no->Type() == TYPE_BOND) ) allowedit = true;
    if ( (mode == MODE_DRAWLINE_DASH) && 
	 (no->Type() == TYPE_BOND) ) allowedit = true;
    if ( (mode == MODE_DRAWLINE_UP) && 
	 (no->Type() == TYPE_BOND) ) allowedit = true;
    if ( (mode == MODE_DRAWLINE_DOWN) && 
	 (no->Type() == TYPE_BOND) ) allowedit = true;
  }
  // allowedit and BUTTON3: edit item under mouse
  if ( (allowedit) && (mouse3down) ) {
    if (highlightobject == 0) highlightobject = no;
    if (highlightobject != 0) {
      if (highlightobject->Type() == TYPE_TEXT) {
	setCursor(ibeamCursor);
	mode = MODE_TEXT;
	text_exists = true;
	localtext = (Text *)highlightobject;
	emit TextOn(localtext->getFont());
	repaint();
	return;
      }
      cout << "Will edit" << endl;
      highlightobject->Edit();
      highlightobject->Highlight(false);
      highlightobject = 0;
      if (mode == MODE_SELECT)
	setCursor(arrowCursor);
      else
	setCursor(crossCursor);
      mouse3down = false;
      repaint();
    }
    return;
  }

  // MODE_SELECT_MULTIPLE_SELECTED: either move, or deselect all
  if ( (mode == MODE_SELECT_MULTIPLE_SELECTED) && (mouse1down) ) {
    // check for move
    if (selectionBox.contains( e1->pos() )) {
      c->StartUndo(0,0);
      mode = MODE_SELECT_MOVE_MULTIPLE;
    } else {
      c->DeselectAll();
      mode = MODE_SELECT;
      repaint();
    }
  }

  // MODE_SELECT_MULTIPLE_SELECTED and Button3: Drag and Drop!
  if ( (mode == MODE_SELECT_MULTIPLE_SELECTED) && (mouse3down) ) {
    // check for move
    if (selectionBox.contains( e1->pos() )) {
      dragging = true;
    } else {
      c->DeselectAll();
      mode = MODE_SELECT;
      repaint();
    }
  } 

  // MODE_SELECT_MULTIPLE_RESIZE: resize drawing
  if ( (mode == MODE_SELECT_MULTIPLE_RESIZE) && (mouse1down) ) {
    mode = MODE_SELECT_RESIZE_MULTIPLE;
  }

  // MODE_SELECT_MULTIPLE_ROTATE: rotate drawing
  if ( (mode == MODE_SELECT_MULTIPLE_ROTATE) && (mouse1down) ) {
    mode = MODE_SELECT_ROTATE_MULTIPLE;
    rotateOrigin.setX( (selectionBox.right() + selectionBox.left() - 2) / 2);
    rotateOrigin.setY( (selectionBox.bottom() + selectionBox.top()) / 2);
    prevangle = getAngle( rotateOrigin, e1->pos() );
  }

  // MODE_DRAWLINE (draw line tool selected), and left button.
  // This means we start drawing a line
  if ( (mode == MODE_DRAWLINE) && (mouse1down) ) {
    startpoint = highlightpoint; // both NULL if nothing selected
    highlightpoint = 0; // stop drawing highlight box
    if (startpoint == NULL) {
      startpoint = new DPoint;
      startpoint->set(e1->pos());
      endpoint = NULL;
    }
    mode = MODE_DRAWLINE_DRAWING;
  }

  // MODE_DRAWLINE_DASH (draw dashed line tool selected), and left button.
  // This means we start drawing a dashed line
  if ( (mode == MODE_DRAWLINE_DASH) && (mouse1down) ) {
    startpoint = highlightpoint; // both NULL if nothing selected
    highlightpoint = 0; // stop drawing highlight box
    if (startpoint == NULL) {
      startpoint = new DPoint;
      startpoint->set(e1->pos());
      endpoint = NULL;
    }
    mode = MODE_DRAWLINE_DASH_DRAWING;
  }

  // MODE_DRAWLINE_UP (draw stereo-up line tool selected), and left button.
  // This means we start drawing a line
  if ( (mode == MODE_DRAWLINE_UP) && (mouse1down) ) {
    startpoint = highlightpoint; // both NULL if nothing selected
    highlightpoint = 0; // stop drawing highlight box
    if (startpoint == NULL) {
      startpoint = new DPoint;
      startpoint->set(e1->pos());
      endpoint = NULL;
    }
    mode = MODE_DRAWLINE_UP_DRAWING;
  }

  // MODE_DRAWLINE_DOWN (draw stereo-down line tool selected), and left button.
  // This means we start drawing a line
  if ( (mode == MODE_DRAWLINE_DOWN) && (mouse1down) ) {
    startpoint = highlightpoint; // both NULL if nothing selected
    highlightpoint = 0; // stop drawing highlight box
    if (startpoint == NULL) {
      startpoint = new DPoint;
      startpoint->set(e1->pos());
      endpoint = NULL;
    }
    mode = MODE_DRAWLINE_DOWN_DRAWING;
  }

  // MODE_DRAWARROW (draw arrow tool selected), and left button.
  // This means we start drawing an arrow
  if ( (mode == MODE_DRAWARROW) && (mouse1down) ) {
    startpoint = new DPoint;
    startpoint->set(e1->pos());
    endpoint = NULL;
    mode = MODE_DRAWARROW_DRAWING;
  }

  // MODE_DRAWCURVEARROW (draw curve arrow tool selected), and left button.
  // This means we start drawing an arrow
  if ( (mode == MODE_DRAWCURVEARROW) && (mouse1down) ) {
    startpoint = new DPoint;
    startpoint->set(e1->pos());
    endpoint = NULL;
    mode = MODE_DRAWCURVEARROW_DRAWING;
  }

  // MODE_DRAWBRACKET (draw bracket tool selected), and left button.
  // This means we start drawing an bracket
  if ( (mode == MODE_DRAWBRACKET) && (mouse1down) ) {
    startpoint = new DPoint;
    startpoint->set(e1->pos());
    endpoint = NULL;
    mode = MODE_DRAWBRACKET_DRAWING;
  }

  // MODE_ERASE, and left button.  Erase highlighted object.
  if ( (mode == MODE_ERASE) && (mouse1down) ) {
    if (highlightobject == 0) return;
    c->Erase(highlightobject);
    highlightobject = 0;
    repaint();
  }
}

void Render2D::mouseReleaseEvent(QMouseEvent *e1) { 
  DPoint *tmp_pt;

  //cout << "Unclick" << endl; 
  // update button state
  if (e1->button() == LeftButton) mouse1down = false;
  if (e1->button() == RightButton) mouse3down = false;
  //cout << "end at " << e1->x() << "," << e1->y() << endl;

  // MODE_TEXT: call special function to handle text events
  if (mode == MODE_TEXT) {
    DrawText_mouseReleaseEvent(e1);
    return;
  }

  // MODE_TOOL_*: ChemData handles this, mostly
  if ( (mode > 600) && (mode < 699) ) {
    tmp_pt = new DPoint(e1->pos());
    c->Tool(tmp_pt, mode);
    repaint();
    if (mode == MODE_TOOL_CLEANUPMOL) {
      setMode_Select();
    }
    return;
  }

  // MODE_SELECT_MULTIPLE: finish multiple selection
  if ( (mode == MODE_SELECT_MULTIPLE) && (!mouse1down) ) {
    int tmp1;
    if (selectOrigin.x() > selectPrev.x()) {
      tmp1 = selectOrigin.x();
      selectOrigin.setX(selectPrev.x());
      selectPrev.setX(tmp1);
    }
    if (selectOrigin.y() > selectPrev.y()) {
      tmp1 = selectOrigin.y();
      selectOrigin.setY(selectPrev.y());
      selectPrev.setY(tmp1);
    }
    drawBox(selectOrigin, selectPrev, QColor(255,255,255));
    bool shiftdown = false;
    if ((e1->state() & ShiftButton) == ShiftButton)
      shiftdown = true;
    c->NewSelectRect(QRect(selectOrigin, selectPrev), shiftdown);
    selectionBox = c->selectionBox();
    if (selectionBox.left() < 999)
      mode = MODE_SELECT_MULTIPLE_SELECTED;
    else
      mode = MODE_SELECT;
    repaint();
  }

  // MODE_SELECT_MOVE_MULTIPLE: finish moving
  if ( (mode == MODE_SELECT_MOVE_MULTIPLE) && (!mouse1down) ) {
    mode = MODE_SELECT_MULTIPLE_SELECTED;
    repaint();
  }

  // MODE_SELECT_MOVE_OBJECT: finish moving
  if ( (mode == MODE_SELECT_MOVE_OBJECT) && (!mouse1down) ) {
    mode = MODE_SELECT;
    repaint();
  }

  // MODE_SELECT_MOVE_POINT: finish moving
  if ( (mode == MODE_SELECT_MOVE_POINT) && (!mouse1down) ) {
    mode = MODE_SELECT;
    repaint();
  }

  // MODE_SELECT_RESIZE_MULTIPLE: finish resizing
  if ( (mode == MODE_SELECT_RESIZE_MULTIPLE) && (!mouse1down) ) {
    mode = MODE_SELECT_MULTIPLE_SELECTED;
  }

  // MODE_SELECT_ROTATE_MULTIPLE: finish rotating
  if ( (mode == MODE_SELECT_ROTATE_MULTIPLE) && (!mouse1down) ) {
    mode = MODE_SELECT_MULTIPLE_SELECTED;
  }

  // MODE_DRAWLINE_DRAWING (drawing line), and left button.
  // Finish line
  if ( (mode == MODE_DRAWLINE_DRAWING) && (!mouse1down) ) {
    if (moved) { 
      if (endpoint == NULL) {
	endpoint = new DPoint;
	endpoint->set(e1->pos());
      }
      // submit this line/bond to ChemData
      if (startpoint != endpoint)
	c->addBond(startpoint, endpoint, thick, 1, currentColor);
    }
    startpoint = NULL; endpoint = NULL;
    mode = MODE_DRAWLINE;
    repaint();
    return;
  }

  // MODE_DRAWLINE_DASH_DRAWING (drawing line), and left button.
  // Finish line
  if ( (mode == MODE_DRAWLINE_DASH_DRAWING) && (!mouse1down) ) {
    if (moved) {
      if (endpoint == NULL) {
	endpoint = new DPoint;
	endpoint->set(e1->pos());
      }
      // submit this line/bond to ChemData
      c->addBond(startpoint, endpoint, thick, 99, currentColor);
    }
    startpoint = NULL; endpoint = NULL;
    mode = MODE_DRAWLINE_DASH;
    repaint();
    return;
  }

  // MODE_DRAWLINE_UP_DRAWING (drawing line), and left button.
  // Finish line
  if ( (mode == MODE_DRAWLINE_UP_DRAWING) && (!mouse1down) ) {
    if (moved) {
      if (endpoint == NULL) {
	endpoint = new DPoint;
	endpoint->set(e1->pos());
      }
      // submit this line/bond to ChemData
      c->addBond(startpoint, endpoint, 1, 5, currentColor);
    }
    startpoint = NULL; endpoint = NULL;
    mode = MODE_DRAWLINE_UP;
    repaint();
    return;
  }

  // MODE_DRAWLINE_DOWN_DRAWING (drawing line), and left button.
  // Finish line
  if ( (mode == MODE_DRAWLINE_DOWN_DRAWING) && (!mouse1down) ) {
    if (moved) {
      if (endpoint == NULL) {
	endpoint = new DPoint;
	endpoint->set(e1->pos());
      }
      // submit this line/bond to ChemData
      c->addBond(startpoint, endpoint, 1, 7, currentColor);
    }
    startpoint = NULL; endpoint = NULL;
    mode = MODE_DRAWLINE_DOWN;
    repaint();
    return;
  }

  // MODE_DRAWARROW_DRAWING (drawing arrow), and left button.
  // Finish arrow
  if ( (mode == MODE_DRAWARROW_DRAWING) && (!mouse1down) ) {
    if (moved) {
      if (endpoint == NULL) {
	endpoint = new DPoint;
	endpoint->set(e1->pos());
      }
      // submit this arrow to ChemData
      c->addArrow(startpoint, endpoint, currentColor, bracket_type);
    }
    startpoint = NULL; endpoint = NULL;
    mode = MODE_DRAWARROW;
    repaint();
  }

  // MODE_DRAWCURVEARROW_DRAWING (drawing curved arrow), and left button.
  // Finish arrow
  if ( (mode == MODE_DRAWCURVEARROW_DRAWING) && (!mouse1down) ) {
    endpoint = new DPoint;
    endpoint->set(e1->pos());
    // submit this arrow to ChemData
    c->addCurveArrow(startpoint, endpoint, currentColor, symbolfile);
    startpoint = NULL; endpoint = NULL;
    mode = MODE_DRAWCURVEARROW;
    repaint();
  }

  // MODE_DRAWBRACKET_DRAWING (drawing bracket), and left button.
  // Finish arrow
  if ( (mode == MODE_DRAWBRACKET_DRAWING) && (!mouse1down) ) {
    if (endpoint == NULL) {
      endpoint = new DPoint;
      endpoint->set(e1->pos());
    }
    // submit this bracket to ChemData
    c->addBracket(startpoint, endpoint, currentColor, bracket_type);
    startpoint = NULL; endpoint = NULL;
    mode = MODE_DRAWBRACKET;
    repaint();
  }

  // MODE_SYMBOL: create Symbol
  if ( (mode == MODE_SYMBOL) && (!mouse1down) ) {
    endpoint = new DPoint;
    endpoint->set(e1->pos());
    if (highlightpoint != 0) {
      c->addSymbol(highlightpoint, symbolfile);  // add to existing point
    } else {
      c->addSymbol(endpoint, symbolfile);  // add at current mouse position
    }
    endpoint = NULL;
    repaint();
  }
}

void Render2D::mouseMoveEvent(QMouseEvent *e1) {
  moved = true;
  
  // Dragging
  if (dragging && mouse3down) {
    cout << "Start drag" << endl;
    // make pixmap of selection
    QRect savebox = selectionBox;
    int prevmode = mode;
    mode = MODE_SELECT;
    c->DeselectAll();
    repaint();
    QPixmap pm( savebox.size() );
    bitBlt( &pm, 0, 0, this, savebox.left(), savebox.top(), 
	    savebox.width(), savebox.height() );
    c->NewSelectRect(savebox, false);
    selectionBox = c->selectionBox();
    mode = prevmode;
    drag1 = new QImageDrag( pm.convertToImage(), this );
    drag1->dragCopy();
    dragging = false;
    repaint();
    setCursor(arrowCursor);
    mouse3down = false;
    return;
  }

  // MODE_TEXT: call special function to handle text events
  if (mode == MODE_TEXT) {
    DrawText_mouseMoveEvent(e1);
    prevpos = new DPoint;
    prevpos->x = e1->x(); prevpos->y = e1->y();
    return;
  }
  // MODE_SELECT: call special function to handle select events
  if (mode < 199) {
    Select_mouseMoveEvent(e1);
    prevpos = new DPoint;
    prevpos->x = e1->x(); prevpos->y = e1->y();
    return;
  }

  // MODE_TOOL_*: return
  if ((mode >= 600) && (mode < 699)) return;

  //bool update;
  double ang, len;
  QString sang, slen;
  DPoint *prevhighlight = highlightpoint;
  Drawable *prevhighlightobject = highlightobject;
  // Create DPoint of current pointer position
  DPoint *e = new DPoint;
  DPoint *np = 0;
  e->x = e1->x(); e->y = e1->y();
  double dist, distobj;
  // Get DPoint of nearest point
  np = c->FindNearestPoint(e, dist);
  // get Drawable of nearest object
  Drawable *no = c->FindNearestObject(e, distobj);

  // no buttons down
  if ( (mouse1down == false) && (mouse3down == false) ) {
    if (mode == MODE_DRAWARROW) return;

    // if (no != 0) {
      // highlight object if object close enough
      if ( (no != 0) && (mode == MODE_ERASE) && (distobj < 6.0) ) {
	highlightobject = no;
	if (prevhighlightobject != 0) prevhighlightobject->Highlight(false);
	highlightobject->Highlight(true);
	if (prevhighlightobject != highlightobject) repaint();
      }
      // unhighlight object if no object close
      if ( (mode == MODE_ERASE) && (no == 0 || distobj >= 6.0) ) {
	// Clear highlighted object
	highlightobject = 0;
	if (prevhighlightobject != 0) prevhighlightobject->Highlight(false);
	if (prevhighlightobject != highlightobject) repaint();
	return;
      }
      // highlight text object preferentially when MODE_SELECT...
      if ((no != 0) && (mode == MODE_SELECT) && (no->Type() == TYPE_TEXT) ) {
	highlightpoint = 0;
	highlightobject = no;
	if ( (prevhighlightobject != highlightobject) &&
	     (prevhighlightobject != 0) )
	  prevhighlightobject->Highlight(false);
	highlightobject->Highlight(true);
	if (prevhighlightobject != highlightobject) repaint();
	// return since no need to check points
	return;
      }
      // highlight object if object close enough and no point close
      if ((no != 0) && (mode == MODE_SELECT) && (distobj < 6.0) && (dist >= 8.0) ) {
	highlightobject = no;
	if (prevhighlightobject != 0) prevhighlightobject->Highlight(false);
	highlightobject->Highlight(true);
	if (prevhighlightobject != highlightobject) repaint();
	// return since no need to check points
	return;
      }
      // unhighlight object if no object close
      if ( (mode == MODE_SELECT) && (no == 0 || distobj >= 6.0) ) {
	// Clear highlighted object
	highlightobject = 0;
	if (prevhighlightobject != 0) prevhighlightobject->Highlight(false);
	if (prevhighlightobject != highlightobject) repaint();
	// don't return; go on to check for points
      }
      // unhighlight object if point close
      if ( (mode == MODE_SELECT) && (dist < 8.0) ) {
	// Clear highlighted object
	highlightobject = 0;
	if (prevhighlightobject != 0) prevhighlightobject->Highlight(false);
	if (prevhighlightobject != highlightobject) repaint();
	// don't return; go on to check for points
      }
    // }
    if (np != 0) {
      //cout << dist << " to (" << np->x << "," << np->y << ")" << endl;
      if ( (mode == MODE_TEXT) && (dist < 8.0) ) {
	highlightpoint = np;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_TEXT) && (dist >= 8.0) ) {
	// Clear highlighted point
	highlightpoint = 0;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_SYMBOL) && (dist < 8.0) ) {
	highlightpoint = np;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_SYMBOL) && (dist >= 8.0) ) {
	// Clear highlighted point
	highlightpoint = 0;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_SELECT) && (dist < 8.0) ) {
	highlightpoint = np;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_SELECT) && (dist >= 8.0) ) {
	// Clear highlighted point
	highlightpoint = 0;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_DRAWLINE) && (dist < 6.0) ) {
	highlightpoint = np;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_DRAWLINE) && (dist >= 6.0) ) {
	// Clear highlighted point
	highlightpoint = 0;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_DRAWLINE_DASH) && (dist < 6.0) ) {
	highlightpoint = np;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_DRAWLINE_DASH) && (dist >= 6.0) ) {
	// Clear highlighted point
	highlightpoint = 0;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_DRAWLINE_UP) && (dist < 6.0) ) {
	highlightpoint = np;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_DRAWLINE_UP) && (dist >= 6.0) ) {
	// Clear highlighted point
	highlightpoint = 0;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_DRAWLINE_DOWN) && (dist < 6.0) ) {
	highlightpoint = np;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
      if ( (mode == MODE_DRAWLINE_DOWN) && (dist >= 6.0) ) {
	// Clear highlighted point
	highlightpoint = 0;
	if (prevhighlight != highlightpoint) repaint();
	return;
      }
    }
    return; // rest of function only if mouse button down
  }

  // we're probably going to draw something...
  repaint();

  // MODE_DRAWLINE_DRAWING: draw temporary line
  if ( (mode == MODE_DRAWLINE_DRAWING) && mouse1down ) {
    // if within range of existing point AND the end point is not the same 
    // as the start point, snap to that point
    if ( (dist < 6.0) && (startpoint != np) ) {
      highlightpoint = np;
      endpoint = np;
    } else {
      endpoint = new DPoint;
      endpoint->x = e1->x();
      endpoint->y = e1->y();
      highlightpoint = 0;  // stop highlighting
      if (fixed_bond) { // fix endpoint if fixed set
	CorrectEndpoint_bond();
	np = c->FindNearestPoint(endpoint, dist);
	if (dist < 2.0) {
	  highlightpoint = np;
	  endpoint = np;
	}
      }
    }
    ang = Drawable::getAngle(startpoint, endpoint);
    len = startpoint->distanceTo(endpoint);
    sang.setNum(ang);
    slen.setNum(len);
    emit SignalSetStatusBar("Draw Line - Length = " + slen + ", Angle = " + 
			    sang);
    drawLine( startpoint->toQPoint(), endpoint->toQPoint(), thick, 
	      currentColor );
    return;
  }

  // MODE_DRAWLINE_DASH_DRAWING: draw temporary line
  if ( (mode == MODE_DRAWLINE_DASH_DRAWING) && mouse1down ) {
    // if within range of existing point AND the end point is not the same 
    // as the start point, snap to that point
    if ( (dist < 6.0) && (startpoint != np) ) {
      highlightpoint = np;
      endpoint = np;
    } else {
      endpoint = new DPoint;
      endpoint->x = e1->x();
      endpoint->y = e1->y();
      highlightpoint = 0;  // stop highlighting
      if (fixed_bond) { // fix endpoint if fixed set
	CorrectEndpoint_bond();
	np = c->FindNearestPoint(endpoint, dist);
	if (dist < 2.0) {
	  highlightpoint = np;
	  endpoint = np;
	}
      }
    }
    drawLine( startpoint->toQPoint(), endpoint->toQPoint(), 1, 
	      currentColor, 1 );
    return;
  }

  // MODE_DRAWLINE_UP_DRAWING: draw temporary line
  if ( (mode == MODE_DRAWLINE_UP_DRAWING) && mouse1down ) {
    // if within range of existing point AND the end point is not the same 
    // as the start point, snap to that point
    if ( (dist < 6.0) && (startpoint != np) ) {
      highlightpoint = np;
      endpoint = np;
    } else {
      endpoint = new DPoint;
      endpoint->x = e1->x();
      endpoint->y = e1->y();
      highlightpoint = 0;  // stop highlighting
      if (fixed_bond) { // fix endpoint if fixed set
	CorrectEndpoint_bond();
	np = c->FindNearestPoint(endpoint, dist);
	if (dist < 2.0) {
	  highlightpoint = np;
	  endpoint = np;
	}
      }
    }
    drawUpLine( startpoint->toQPoint(), endpoint->toQPoint(), QColor(0,0,0) );
    return;
  }
  // MODE_DRAWLINE_DOWN_DRAWING: draw temporary line
  if ( (mode == MODE_DRAWLINE_DOWN_DRAWING) && mouse1down ) {
    // if within range of existing point AND the end point is not the same 
    // as the start point, snap to that point
    if ( (dist < 6.0) && (startpoint != np) ) {
      highlightpoint = np;
      endpoint = np;
    } else {
      endpoint = new DPoint;
      endpoint->x = e1->x();
      endpoint->y = e1->y();
      highlightpoint = 0;  // stop highlighting
      if (fixed_bond) { // fix endpoint if fixed set
	CorrectEndpoint_bond();
	np = c->FindNearestPoint(endpoint, dist);
	if (dist < 2.0) {
	  highlightpoint = np;
	  endpoint = np;
	}
      }
    }
    drawDownLine(startpoint->toQPoint(), endpoint->toQPoint(), QColor(0,0,0));
    return;
  }

  // MODE_DRAWARROW_DRAWING: draw temporary line
  if ( (mode == MODE_DRAWARROW_DRAWING) && mouse1down ) {
    endpoint = new DPoint;
    endpoint->x = e1->x();
    endpoint->y = e1->y();
    if (fixed_arrow) { // fix endpoint if fixed set
      CorrectEndpoint_arrow();
    }
    drawArrow( startpoint->toQPoint(), endpoint->toQPoint(), QColor(0,0,0),
	       bracket_type );
    return;
  }

  // MODE_DRAWARROW_DRAWING: draw temporary line
  if ( (mode == MODE_DRAWCURVEARROW_DRAWING) && mouse1down ) {
    endpoint = new DPoint;
    endpoint->x = e1->x();
    endpoint->y = e1->y();
    // should not draw curve arrows fixed, even if selected
    //if (fixed) { // fix endpoint if fixed set
    //  CorrectEndpoint();
    //}
    drawCurveArrow( startpoint->toQPoint(), endpoint->toQPoint(), 
		    QColor(0,0,0), symbolfile );
    return;
  }

  // MODE_DRAWBRACKET_DRAWING: draw temporary bracket
  if ( (mode == MODE_DRAWBRACKET_DRAWING) && mouse1down ) {
    endpoint = new DPoint;
    endpoint->x = e1->x();
    endpoint->y = e1->y();
    drawBracket( startpoint->toQPoint(), endpoint->toQPoint(), QColor(0,0,0),
		 bracket_type );
    return;
  }
}

void Render2D::paintEvent(QPaintEvent *) { 
  // draw background
  //drawFillBox(QPoint(0,0), QPoint(renderWidth, renderHeight), bgcolor);
  // draw all data
  c->drawAll();
  // local/temporary draw operations
  if (highlightpoint != 0) {
    drawBox(QPoint(highlightpoint->x - 2, highlightpoint->y - 2),
	    QPoint(highlightpoint->x + 2, highlightpoint->y + 2),
	    QColor(0,0,0));
  }
  if ( (mode == MODE_TEXT) && (localtext != 0) ) localtext->EditRender();
  // if multiple selection, draw rotate and resize handles
  if ( (mode > 120) && (mode < 129) ) {
    // draw selection box
    drawBox(selectionBox.topLeft(), selectionBox.bottomRight(),
	    QColor(0,0,0));
    // draw rotate handle
    rotateHandle = selectionBox.topRight();
    drawFillBox( QPoint(rotateHandle.x() - 5, rotateHandle.y()),
		 QPoint(rotateHandle.x(), rotateHandle.y() + 5),
		 QColor(0,0,0) );
    // draw resize handle
    resizeHandle = selectionBox.bottomRight();
    drawFillBox( QPoint(resizeHandle.x() - 5, resizeHandle.y() - 5),
		 resizeHandle,
		 QColor(0,0,0) );
  }
  if (mode == 91) {
    // draw selection box
    drawBox(selectionBox.topLeft(), selectionBox.bottomRight(),
	    QColor(0,0,0));
    // draw rotate handle
    rotateHandle = selectionBox.topRight();
    drawFillBox( QPoint(rotateHandle.x() - 5, rotateHandle.y()),
		 QPoint(rotateHandle.x(), rotateHandle.y() + 5),
		 QColor(0,0,0) );
    // draw resize handle
    resizeHandle = selectionBox.bottomRight();
    drawFillBox( QPoint(resizeHandle.x() - 5, resizeHandle.y() - 5),
		 resizeHandle,
		 QColor(0,0,0) );
  }
}

