/*
     Copyright (C) 1996 - 1997  Masahito Yamaga (yamaga@ipc.chiba-u.ac.jp)
*/

#include "xdvi-config.h"
#include <sys/param.h>	/* for MAXPATHLEN */

struct vfontmap *first_ptr = NULL;

#ifdef PTEX
void addfontmap(s1,s2,tate)
	char *s1,*s2;
	int tate;
#else
void addfontmap(s1,s2)
	char *s1,*s2;
#endif
{
	struct vfontmap *new_ptr;

	new_ptr = (struct vfontmap *)
			malloc(sizeof(struct vfontmap));

	new_ptr->jfmname = (char *)xmalloc(strlen(s1)+1);
	new_ptr->vfname  = (char *)xmalloc(strlen(s2)+1);
	(void)strcpy(new_ptr->jfmname, s1);
	(void)strcpy(new_ptr->vfname,  s2);
	new_ptr->flag = -1;
#ifdef PTEX
	new_ptr->tate = tate;
#endif

	new_ptr->next_ptr = first_ptr;
	first_ptr = new_ptr;
}

#define	MAX_VFONTS	255
#define	MAX_VFONTNAME	255

read_VFontmap()
{
	FILE *map;
	char vfontmapf[MAXPATHLEN], line[BUFSIZ];
	char jfmname[MAX_VFONTNAME+1], vfname[MAX_VFONTNAME+1];
	int i, n, tate;
	int min, nmin, tmin, goth, ngoth, tgoth, dm, dg;

	min = nmin = tmin = goth = ngoth = tgoth = dm = dg = 0;

#if defined(USE_ZEIT) && defined(USE_VFONTMAP)

#ifndef	DEFAULT_FONTMAP
#define	DEFAULT_FONTMAP	"/usr/local/share/texmf/xdvi/vfontmap"
#endif

	if (!(map = fopen("vfontmap", "r"))) {
		if (strcmp(resource.vfontmap,DEFAULT_FONTMAP))
			strcpy(vfontmapf, resource.vfontmap);
		else
		if (getenv("VFONTMAP"))
			strcpy(vfontmapf, getenv("VFONTMAP"));
		else
			strcpy(vfontmapf, DEFAULT_FONTMAP);

		if (!(map =  fopen(vfontmapf, "r"))) {
		     Fprintf(stderr,"Warning: Can't open \"%s\"\n",vfontmapf);
		     Fprintf(stderr,"         Default Values are Used.\n");
		}
	}

	if (map) {
		while(fgets(line, BUFSIZ, map)){
		  i = n = tate = 0;

		  while (line[i] == ' '&& line[i] == '\t')
		    i += 1;
		  if (line[i] == '\n' || line[i] == '#')
		    continue;

		  while (line[i] != ' ' && line[i] != '\t' && line[i] != '\n')
		    jfmname[n++] = line[i++];
		  jfmname[n] = '\0';

		  if (line[i] == '\n')
		    {
		      Fprintf(stderr,
			      "No specified Vector Font name for \"%s\"\n",
			      jfmname);
		      continue;
		    }

		  if (debug & DBG_PK)
		    Fprintf(stderr,
			    "JFM name is \"%s\"\n",
			    jfmname);
		  
		  while (line[i] == ' ' || line[i] == '\t')
		    i += 1;
		  if (line[i] == '\n' || line[i] == '#')
		    continue;

		  n = 0;
		  while (line[i] != ' ' && line[i] != '\t' && line[i] != '\n')
		    vfname[n++] = line[i++];
		  vfname[n] = '\0';

		  if (debug & DBG_PK)
		    Fprintf(stderr,
			    "Font name of VFlib is \"%s\"\n",
			    vfname);

#ifdef PTEX
		  while (line[i] == ' ' || line[i] == '\t')
		    i += 1;

		  if (line[i] != '\n' && line[i] != '#')
		    {
		      while (line[i] != ' ' && line[i] != '\t' &&
			     line[i] != '\n')
			i += 1;
		      
		      while (line[i] == ' '&& line[i] == '\t')
			i += 1;
		      
		      if (line[i] != '\n' && line[i] != '#')
			{
fprintf(stderr, "%s\n", line);
			  Fprintf(stderr,
				  "There is too much argument.\n");
			  continue;
			}
		      tate = 1;
		    }
		  if (debug & DBG_PK)
		    Fprintf(stderr,
			    "Font of VFlib is \"%s\"\n",
			    tate ? "TATE font" : "TRANS...font");

		  addfontmap(jfmname,vfname,tate);
#else
			addfontmap(jfmname,vfname);
#endif

			if (!strcmp(jfmname,"dg"   )) dg = 1;
			if (!strcmp(jfmname,"dm"   )) dm = 1;

			if (!strcmp(jfmname,"ngoth")) ngoth = 1;
			if (!strcmp(jfmname,"tgoth")) tgoth = 1;
			if (!strcmp(jfmname,"goth" )) goth  = 1;
			if (!strcmp(jfmname,"nmin" )) nmin  = 1;
			if (!strcmp(jfmname,"tmin" )) tmin  = 1;
			if (!strcmp(jfmname,"min"  )) min   = 1;
		}
	}
#endif /* USE_ZEIT && USE_VFONTMAP */

#ifdef PTEX
	if (!dg)	addfontmap("dg"   ,"goth",0);
	if (!dm)	addfontmap("dm"   ,"min" ,0);

	if (!ngoth)	addfontmap("ngoth","goth",0);
	if (!tgoth)	addfontmap("tgoth","goth",0);
	if (!goth)	addfontmap("goth" ,"goth",0);
	if (!nmin)	addfontmap("nmin" ,"min" ,0);
	if (!tmin)	addfontmap("tmin" ,"min" ,0);
	if (!min) 	addfontmap("min"  ,"min" ,0);
#else
	if (!dg)	addfontmap("dg"   ,"goth");
	if (!dm)	addfontmap("dm"   ,"min" );

	if (!ngoth)	addfontmap("ngoth","goth");
	if (!tgoth)	addfontmap("tgoth","goth");
	if (!goth)	addfontmap("goth" ,"goth");
	if (!nmin)	addfontmap("nmin" ,"min" );
	if (!tmin)	addfontmap("tmin" ,"min" );
	if (!min) 	addfontmap("min"  ,"min" );
#endif
}
