/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.spec;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import java.util.List;
import jde.debugger.spec.ReferenceTypeSpec;

public class SourceNameReferenceTypeSpec
implements ReferenceTypeSpec {
    final String sourceName;
    final int lineNumber;

    public SourceNameReferenceTypeSpec(String src, int line) {
        this.sourceName = src;
        this.lineNumber = line;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public boolean matches(ReferenceType refType) {
        block7: {
            try {
                if (!refType.sourceName().equals(this.sourceName)) break block7;
                try {
                    List<Location> locs = refType.locationsOfLine(this.lineNumber);
                    return locs.size() > 0;
                }
                catch (AbsentInformationException exc) {
                }
                catch (ObjectCollectedException exc) {
                }
                catch (InvalidLineNumberException exc) {
                }
                catch (ClassNotPreparedException exc) {
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        return this.sourceName + " " + this.lineNumber;
    }
}

