/*
 *  Euklides  version 0.3.4
 *  Copyright (c) Christian Obrecht 2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

%x FILTER
%{

#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "parser.tab.h"

int warning(char *);

extern int filter, undefined, lineno;

symrec *sym_table = NULL;

symrec *putsym (char *sym_name)
{
  symrec *ptr;
  ptr = (symrec *)malloc(sizeof(symrec));
  ptr->name = (char *) malloc (strlen (sym_name) + 1);
  strcpy (ptr->name, sym_name);
  ptr->type = VARIABLE;
  ptr->next = sym_table;
  sym_table = ptr;
  return ptr;
}

symrec *getsym (char *sym_name)
{
  symrec *ptr;
  for (ptr = sym_table; ptr != NULL; ptr = ptr->next)
    if (strcmp (ptr->name, sym_name) == 0)
      return ptr;
  return NULL;
}

void clearsym(void)
{
  symrec *ptr, *prev;
  ptr = sym_table;
  while (ptr != NULL) {
    free(ptr->name);
    prev = ptr;
    ptr = ptr->next;
    free(prev);
  }
  sym_table = NULL;
}

saverec *save_table = NULL;

void save(void * s)
{
  saverec *ptr;
  ptr = (saverec *)malloc(sizeof(saverec));
  ptr->s = s;
  ptr->next = save_table;
  save_table = ptr;
}

void clearsave(void)
{
  saverec *ptr, *prev;
  ptr = save_table;
  while (ptr != NULL) {
    free(ptr->s);
    prev = ptr;
    ptr = ptr->next;
    free(prev);
  }
  save_table = NULL;
}

int yywrap(void)
{
  return 1;
}

%}

%%

%{

if (filter) BEGIN FILTER;
else BEGIN INITIAL;

%}

[\t ]+                                                                                  /* Ignore whitespace */

"%--stop"[\t ]*\n		{ 							/* Stop compiling */
				  lineno++;
				  filter = 1;
				  undefined = 1;
				  printf("\\endpspicture\n");
				  printf("%% End of figure\n");
				  BEGIN FILTER;
				}
				  
"%--end"[\t ]*\n		{ 							/* Stop compiling */
				  lineno++;
				  filter = 1;
				  clearsave(); clearsym();				/* and clear memory */
				  sym_table = NULL;
				  undefined = 1;
				  printf("\\endpspicture\n");
				  printf("\\psset{linecolor=black}\n");
				  printf("%% End of figure\n");
				  BEGIN FILTER;
				}
				  
%.*\n                           { lineno++; }                                            /* Comments */
				  
%.*				{ return '\n'; }

-?(([0-9]+)|([0-9]*\.[0-9]+))   {                                                       /* Numbers */
				  yylval.number = atof(yytext);
				  return NUMBER;
				}

\"[^\"\n]*[\"\n]                {                                                       /* Strings */
				  yylval.string = strdup(yytext+1);
				  if (yylval.string[yyleng-2] != '"') {
				    warning("Unterminated character string");
				    lineno++;
				  }
				  else yylval.string[yyleng-2] = '\0';
				  return STRING;
				}

point                           { return POINT; }                                       /* Reserved words */

vector                          { return VECTOR; }

line                            { return LINE; }

segment                         { return SEGMENT; }

circle                          { return CIRCLE; }

translation                     { return TRANSLATION; }

reflection                      { return REFLECTION; }

rotation                        { return ROTATION; }

projection                      { return PROJECTION; }

homothecy                       { return HOMOTHECY; }

intersection                    { return INTERSECTION; }

parallel                        { return PARALLEL; }

perpendicular                   { return PERPENDICULAR; }

midpoint                        { return MIDPOINT; }

begin                           { return TOKBEGIN; }

end                             { return END; }

center                          { return CENTER; }

triangle                        { return TRIANGLE; }

equilateral                     { return EQUILATERAL; }

isosceles                       { return ISOSCELES; }

right                           { return RIGHT; }

barycenter                      { return BARYCENTER; }

median                          { return MEDIAN; }

altitude                        { return ALTITUDE; }

orthocenter                     { return ORTHOCENTER; }

bissector                       { return BISSECTOR; }

incircle                        { return INCIRCLE; }

parallelogram                   { return PARALLELOGRAM; }

rectangle                       { return RECTANGLE; }

square                          { return SQUARE; }

pentagon			{ return PENTAGON; }

hexagon                         { return HEXAGON; }

abscissa                        { return ABSCISSA; }

ordinate                        { return ORDINATE; }

length                          { return LENGTH; }

distance			{ return DISTANCE; }

angle                           { return ANGLE; }

radius                          { return RADIUS; }

heigth				{ return HEIGTH; }

pi				{ return TOKPI; }

sin                             { return SIN; }

cos                             { return COS; }

tan                             { return TAN; }

asin                            { return ASIN; }

acos                            { return ACOS; }

atan                            { return ATAN; }

deg				{ return TOKDEG; }

rad				{ return TOKRAD; }

sqrt                            { return SQRT; }

frame				{ return FRAME; }

color				{ return COLOR; }

black				{ return BLACK; }

darkgray			{ return DARKGRAY; }

gray				{ return GRAY; }

lightgray			{ return LIGHTGRAY; }

red				{ return RED; }

green				{ return GREEN; }

blue				{ return BLUE; }

cyan				{ return CYAN; }

magenta				{ return MAGENTA; }

yellow				{ return YELLOW; }

tricks				{ return TRICKS; }

font				{ return FONT; }

draw				{ return DRAW; }

mark				{ return MARK; }

box				{ return BOX; }

cross				{ return CROSS; }

plus				{ return PLUS; }

arrow				{ return ARROW; }

backarrow			{ return BACKARROW; }

doublearrow			{ return DOUBLEARROW; }

entire				{ return ENTIRE;}

halfline			{ return HALFLINE; }

backhalfline			{ return BACKHALFLINE; }

full				{ return FULL; }

dotted                          { return DOTTED; }

dashed                          { return DASHED; }

simple				{ return SIMPLE; }

double				{ return DOUBLE; }

triple				{ return TRIPLE; }

dash				{ return DASH; }

interactive			{ return INTERACTIVE; }

up				{ return UP; }

[a-zA-Z][a-zA-Z0-9]*            {                                                       /* Variables */
				  symrec *s;
				  s = getsym (yytext);
				  if (s == NULL) 
				    s = putsym (yytext); 
				  yylval.ptr = s;
				  switch (s->type)
				  {
				    case NUMBER         : return NUMBER_VARIABLE;
				    case POINT          : return POINT_VARIABLE;
				    case VECTOR         : return VECTOR_VARIABLE;
				    case LINE           : return LINE_VARIABLE;
				    case SEGMENT        : return SEGMENT_VARIABLE;
				    case CIRCLE         : return CIRCLE_VARIABLE;
				    case VARIABLE       : return VARIABLE;
				  }
				}


\n                              { lineno++; return '\n'; }                              /* New line */

.                               { return yytext[0]; }                                   /* Anything else */

<FILTER>"%--euklides"[\t ]*\n	{ lineno++; filter = 0; BEGIN INITIAL; }		/* Start compiling */

<FILTER>\n                      { lineno++; ECHO; }                              	/* New line */

<FILTER>.			{ ECHO; }						/* Anything else */
%%
