dnl Checks for the --with-ldap option on ./configure
dnl
dnl Taken originally from Mutt (http://www.mutt.org)

AC_DEFUN([OPENSSL], [
AC_MSG_CHECKING(whether to include ssl support)
AC_ARG_WITH(ssl, [  --with-ssl[=PFX]           Compile in SSL support for POP/IMAP],
[
        if test "$with_ssl" != "no"
        then
          if test "$with_ssl" != "yes"
          then
           SSL_LIBS="-L$withval/lib"
           SSL_CFLAGS="-L$withval/include"
          fi

          AC_MSG_RESULT(yes)
          AC_CHECK_LIB(crypto, X509_new,, AC_MSG_ERROR([Unable to find SSL library]))
          AC_CHECK_LIB(ssl, SSL_new,, AC_MSG_ERROR([Unable to find SSL library]), -lcrypto)

          AC_CHECK_FUNCS(RAND_status RAND_egd)

          SSL_LIBS="$SSL_LIBS -lssl -lcrypto"
          SSL_CFLAGS="-DWITH_SSL"
          need_ssl=yes
        fi
],
AC_MSG_RESULT(no)
)
AC_SUBST(SSL_LIBS)
AC_SUBST(SSL_CFLAGS)
])
