<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
                xmlns:xgf="http://www.engl.virginia.edu/OE/xgridfit-data"
                exclude-result-prefixes="xgf">

  <!--
      xgridfit, an XML-based language for instructing TrueType fonts

      version 1.0

      Copyright (c) 2006-7 by Peter S. Baker

      Issued under the GNU Public License, v. 2.

      No warranty here! Back up your fonts!
  -->
  
  <xsl:output method="text" encoding="UTF-8"/>

  <!-- How many points permitted in the twilight zone. This is generous,
       I think. -->
  <xsl:param name="max-twilight-points">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='max-twilight-points']">
        <xsl:value-of select="/xgridfit/default[@type=
			      'max-twilight-points']/@value"/>
      </xsl:when>
      <xsl:when test="/xgridfit/profile/default[@type='max-twilight-points']">
        <xsl:value-of select="/xgridfit/profile/default[@type=
			      'max-twilight-points']/@value"/>
      </xsl:when>
      <xsl:otherwise>25</xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <!-- How many storage spaces to allocate. These are used for variables.
       Increase the number if you use variables a lot. -->
  <xsl:param name="max-storage">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='max-storage']">
        <xsl:value-of select="/xgridfit/default[@type=
			      'max-storage']/@value"/>
      </xsl:when>
      <xsl:when test="/xgridfit/profile/default[@type='max-storage']">
        <xsl:value-of select="/xgridfit/profile/default[@type=
			      'max-storage']/@value"/>
      </xsl:when>
      <xsl:otherwise>64</xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:param name="max-stack">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='max-stack']">
        <xsl:value-of select="/xgridfit/default[@type=
			      'max-stack']/@value"/>
      </xsl:when>
      <xsl:when test="/xgridfit/profile/default[@type='max-stack']">
        <xsl:value-of select="/xgridfit/profile/default[@type=
			      'max-stack']/@value"/>
      </xsl:when>
      <xsl:otherwise>256</xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:param name="delta-break">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='delta-break']">
        <xsl:value-of select="/xgridfit/default[@type=
			      'delta-break']/@value"/>
      </xsl:when>
      <xsl:when test="/xgridfit/profile/default[@type='delta-break']">
        <xsl:value-of select="/xgridfit/profile/default[@type=
			      'delta-break']/@value"/>
      </xsl:when>
      <xsl:otherwise>10</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:param name="infile">
    <xsl:choose>
      <xsl:when test="/xgridfit/infile">
        <xsl:value-of select="/xgridfit/infile"/>
      </xsl:when>
      <xsl:when test="/xgridfit/profile/infile">
        <xsl:value-of select="/xgridfit/profile/infile"/>
      </xsl:when>
      <xsl:when test="/xgridfit/profile/font-file">
        <xsl:value-of select="/xgridfit/profile/font-file"/>
      </xsl:when>
      <xsl:otherwise>!!nofile!!</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:param name="outfile">
    <xsl:choose>
      <xsl:when test="/xgridfit/outfile">
        <xsl:value-of select="/xgridfit/outfile"/>
      </xsl:when>
      <xsl:when test="/xgridfit/profile/outfile">
        <xsl:value-of select="/xgridfit/profile/outfile"/>
      </xsl:when>
      <xsl:when test="/xgridfit/profile/font-file">
        <xsl:value-of select="/xgridfit/profile/font-file"/>
      </xsl:when>
      <xsl:otherwise>!!nofile!!</xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:key name="cvt" match="control-value" use="@name"/>
  <xsl:key name="function-index" match="function" use="@name"/>
  <xsl:key name="macro-index" match="macro" use="@name"/>

  <!-- We'll do our own formatting of all TT instructions, providing all
       line breaks and spacing. So no space or line breaks kept from source
       file. -->
  <xsl:strip-space elements="*"/>

  <xsl:variable name="newline">
    <xsl:text>\n</xsl:text>
  </xsl:variable>

  <xsl:variable name="inst-newline">
    <xsl:text>\n</xsl:text>
  </xsl:variable>

  <xsl:variable name="push-num-separator">
    <xsl:text>\n</xsl:text>
  </xsl:variable>
  
  <xsl:variable name="text-newline">
    <xsl:text>
</xsl:text>
  </xsl:variable>

  <!-- These will be found in func-predef.xsl. -->
  <xsl:variable name="predefined-functions" select="4"/>
  
  <xsl:variable name="auto-function-base">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type = 'function-base']">
        <xsl:value-of select="/xgridfit/default[@type = 'function-base-num']/@value"/>
      </xsl:when>
      <xsl:when test="/xgridfit/profile/default[@type = 'function-base']">
        <xsl:value-of select="/xgridfit/profile/default[@type =
                              'function-base-num']/@value"/>
      </xsl:when>
      <xsl:when test="/xgridfit/function[@num]">
        <xsl:variable name="n">
          <xsl:call-template name="get-highest-function-number">
            <xsl:with-param name="current-function"
                            select="/xgridfit/function[@num][1]"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="number($n) + 1"/>
      </xsl:when>
      <xsl:when test="/xgridfit/functions/function[@num]">
        <xsl:variable name="n">
          <xsl:call-template name="get-highest-function-number">
            <xsl:with-param name="current-function"
                            select="/xgridfit/functions/function[@num][1]"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="number($n) + 1"/>
      </xsl:when>
      <xsl:when test="/xgridfit/legacy-functions/@highest">
	<xsl:value-of select="number(/xgridfit/legacy-functions/@highest) + 1"/>
      </xsl:when>
      <xsl:when test="/xgridfit/functions/legacy-functions/@highest">
	<xsl:value-of select="number(/xgridfit/functions/legacy-functions/@highest) + 1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="var-legacy-storage">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type = 'legacy-storage']">
	<xsl:value-of select="/xgridfit/default[@type = 'legacy-storage']/@value"/>
      </xsl:when>
      <xsl:when test="/xgridfit/profile/default[@type = 'legacy-storage']">
	<xsl:value-of select="/xgridfit/profile/default[@type =
			      'legacy-storage']/@value"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>0</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  
  <xsl:variable name="function-round-restore"
		select="$auto-function-base"/>
  
  <xsl:variable name="function-glyph-prolog"
		select="number($auto-function-base) + 1"/>
  
  <xsl:variable name="function-push-range"
		select="number($auto-function-base) + 2"/>

  <xsl:variable name="function-order-range"
		select="number($auto-function-base) + 3"/>
  
  <!--
      First in the Storage Area is a block of locations used by legacy
      code (defined as the "legacy-storage" default). Next come some
      reserved locations used by Xgridfit to track state
      information. Next is the global variable areas (variables
      declared in the <profile> and assigned values is the
      <pre-program>).  Finally a growable variable frame area.
  -->
  <xsl:variable name="var-round-state"
		select="number($var-legacy-storage)+ 0"/>
  <xsl:variable name="var-sround-info"
		select="number($var-legacy-storage)+ 1"/>
  <xsl:variable name="var-round-state-default"
		select="number($var-legacy-storage)+ 2"/>
  <xsl:variable name="var-sround-info-default"
		select="number($var-legacy-storage)+ 3"/>
  <xsl:variable name="var-return-value"
		select="number($var-legacy-storage)+ 4"/>
  <xsl:variable name="var-minimum-distance"
		select="number($var-legacy-storage)+ 5"/>
  <xsl:variable name="var-minimum-distance-default"
		select="number($var-legacy-storage)+ 6"/>
  <xsl:variable name="var-control-value-cut-in"
		select="number($var-legacy-storage)+ 7"/>
  <xsl:variable name="var-control-value-cut-in-default"
		select="number($var-legacy-storage)+ 8"/>
  <xsl:variable name="var-single-width"
		select="number($var-legacy-storage)+ 9"/>
  <xsl:variable name="var-single-width-cut-in"
		select="number($var-legacy-storage)+ 10"/>
  <xsl:variable name="var-single-width-default"
		select="number($var-legacy-storage)+ 11"/>
  <xsl:variable name="var-single-width-cut-in-default"
		select="number($var-legacy-storage)+ 12"/>
  <xsl:variable name="var-delta-base"
		select="number($var-legacy-storage)+ 13"/>
  <xsl:variable name="var-delta-base-default"
		select="number($var-legacy-storage)+ 14"/>
  <xsl:variable name="var-delta-shift"
		select="number($var-legacy-storage)+ 15"/>
  <xsl:variable name="var-delta-shift-default"
		select="number($var-legacy-storage)+ 16"/>
  <xsl:variable name="var-function-stack-count"
		select="number($var-legacy-storage)+ 17"/>
  <xsl:variable name="var-frame-bottom"
		select="number($var-legacy-storage)+ 18"/>
  <xsl:variable name="var-frame-top"
		select="number($var-legacy-storage)+ 19"/>
  <xsl:variable name="reg0"
		select="number($var-legacy-storage)+ 20"/>
  <xsl:variable name="reg1"
		select="number($var-legacy-storage)+ 21"/>
  <xsl:variable name="reg2"
		select="number($var-legacy-storage)+ 22"/>
  <xsl:variable name="reg3"
		select="number($var-legacy-storage)+ 23"/>

  <!-- This number + 1 is the lowest address of a global variable. -->
  <xsl:variable name="global-variable-base"
		select="number($var-legacy-storage)+ 23"/>
  <!-- This number + 1 is the lowest address of a variable
       in a glyph program or function. -->
  <xsl:variable name="variable-frame-base"
                select="$global-variable-base +
                        count(/xgridfit/variable|/xgridfit/profile/variable)"/>

  <xsl:include href="numbers.xsl"/>
  <xsl:include href="expressions.xsl"/>
  <xsl:include href="arithmetic.xsl"/>
  <xsl:include href="points.xsl"/>
  <xsl:include href="flow.xsl"/>
  <xsl:include href="function.xsl"/>
  <xsl:include href="func-predef.xsl"/>
  <xsl:include href="prep.xsl"/>
  <xsl:include href="graphics.xsl"/>
  <xsl:include href="measure.xsl"/>
  <xsl:include href="primitives.xsl"/>
  <xsl:include href="delta.xsl"/>
  <xsl:include href="move-lib.xsl"/>
  <xsl:include href="move-els.xsl"/>
  <xsl:include href="messages.xsl"/>
  <xsl:include href="misc.xsl"/>
  

  <!--

       simple-command

       A very simple, one-line command, with optional modifier.
  -->
  <xsl:template name="simple-command">
    <xsl:param name="cmd"/>
    <xsl:param name="modifier"/>
    <xsl:param name="with-leading-newline" select="true()"/>
    <xsl:if test="$with-leading-newline">
      <xsl:value-of select="$inst-newline"/>
      <xsl:text>"+\</xsl:text>
      <xsl:value-of select="$text-newline"/>
    </xsl:if>
    <xsl:text>"</xsl:text>
    <xsl:value-of select="$cmd"/>
    <xsl:if test="$modifier">
      <xsl:text>[</xsl:text>
      <xsl:value-of select="$modifier"/>
      <xsl:text>]</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--

       push-command

       Generates the command for a PUSH instruction.
  -->
  <xsl:template name="push-command">
    <xsl:param name="size" select="'B'"/>
    <xsl:param name="count" select="1"/>
    <xsl:param name="with-leading-newline" select="true()"/>
    <xsl:variable name="cmd">
      <xsl:choose>
        <xsl:when test="number($count) &lt;= 8">
          <xsl:value-of select="concat('PUSH',$size,'_',$count)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="number($count) &gt; 255">
            <xsl:call-template name="error-message">
              <xsl:with-param name="msg">
                <xsl:text>You may not push more than 255 numbers at one time.</xsl:text>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:if>
          <xsl:value-of select="concat('NPUSH',$size)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:call-template name="simple-command">
      <xsl:with-param name="cmd" select="$cmd"/>
      <xsl:with-param name="with-leading-newline" select="$with-leading-newline"/>
    </xsl:call-template>
    <xsl:if test="number($count) &gt; 8">
      <xsl:value-of select="$inst-newline"/>
      <xsl:value-of select="$count"/>
    </xsl:if>
  </xsl:template>

  <!-- The following templates are for the bit-flags that accompany
       certain instructions. -->

  <xsl:template name="color-bits">
    <xsl:param name="color"/>
    <xsl:choose>
      <xsl:when test="$color='black'">
        <xsl:text>01</xsl:text>
      </xsl:when>
      <xsl:when test="$color='white'">
        <xsl:text>10</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>00</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="to-line-bit">
    <xsl:param name="tlb"/>
    <xsl:choose>
      <xsl:when test="$tlb='orthogonal'">
        <xsl:text>1</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>0</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="axis-bit">
    <xsl:param name="axis"/>
    <xsl:choose>
      <xsl:when test="$axis='x'">
        <xsl:text>1</xsl:text>
      </xsl:when>
      <xsl:when test="$axis='y'">
        <xsl:text>0</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="error-message">
          <xsl:with-param name="msg">
            <xsl:text>When setting a vector, the "axis" </xsl:text>
            <xsl:text>attribute must be either "x" or "y."</xsl:text>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="round-and-cut-in-bit">
    <xsl:param name="b" select="true()"/>
    <xsl:choose>
      <xsl:when test="$b">
        <xsl:text>1</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>0</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="rp0-bit">
    <xsl:param name="set-rp0"/>
    <xsl:choose>
      <xsl:when test="$set-rp0">
        <xsl:text>1</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>0</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="mirp-mdrp-bits">
    <xsl:param name="set-rp0"/>
    <xsl:param name="min-distance"/>
    <xsl:param name="round-cut-in"/>
    <xsl:param name="color"/>
    <xsl:call-template name="rp0-bit">
      <xsl:with-param name="set-rp0" select="$set-rp0"/>
    </xsl:call-template>
    <xsl:choose>
      <xsl:when test="$min-distance">
        <xsl:text>1</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>0</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="round-and-cut-in-bit">
      <xsl:with-param name="b" select="$round-cut-in"/>
    </xsl:call-template>
    <xsl:call-template name="color-bits">
      <xsl:with-param name="color" select="$color"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="ref-ptr-bit">
    <xsl:param name="ref-ptr"/>
    <xsl:choose>
      <xsl:when test="$ref-ptr='1'">
        <xsl:text>1</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>0</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="grid-fitted-bit">
    <xsl:param name="grid-fitted"/>
    <xsl:choose>
      <xsl:when test="$grid-fitted">
        <xsl:text>0</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>1</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<!-- ========================================================================= -->
<!-- ============== TOP-LEVEL ELEMENTS OF THE INSTRUCTION FILE =============== -->
<!-- ========================================================================= -->
  

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="xgridfit">
    <xsl:param name="all-functions" select="/xgridfit/function|/xgridfit/functions/function"/>
    <xsl:param name="leg"
	       select="/xgridfit/legacy-functions|/xgridfit/functions/legacy-functions"/>
    <xsl:if test="not(pre-program)">
      <xsl:call-template name="error-message">
	<xsl:with-param name="msg">
	  <xsl:text>A &lt;pre-program&gt; element must be present, even if empty.</xsl:text>
	</xsl:with-param>
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="profile/font-file">
      <xsl:call-template name="warning">
        <xsl:with-param name="msg">
          <xsl:text>Note that profile/font-file is now deprecated. </xsl:text>
          <xsl:text>Please use /xgridfit/infile and /xgridfit/outfile instead.</xsl:text>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="$infile != '!!nofile!!'">
        <xsl:text>Open("</xsl:text>
        <xsl:value-of select="$infile"/>
        <xsl:text>")</xsl:text>
        <xsl:value-of select="$text-newline"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="warning">
          <xsl:with-param name="msg">
            <xsl:text>No font file specified. You may have to edit the script or</xsl:text>
            <xsl:text> run it in the FontForge GUI.</xsl:text>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>ClearTable("cvt")</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <xsl:text>i=0</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <xsl:text>while ( i&lt;</xsl:text>
    <xsl:value-of select="count(control-value|control-values/control-value)"/>
    <xsl:text> )</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <xsl:text>    FindOrAddCvtIndex( 2*i )</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <xsl:text>    ++i</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <xsl:text>endloop</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <xsl:for-each select="control-value|control-values/control-value">
      <xsl:text>ReplaceCvtAt(</xsl:text>
      <xsl:value-of select="position() - 1"/>
      <xsl:text>,</xsl:text>
      <xsl:value-of select="@value"/>
      <xsl:text>)</xsl:text>
      <xsl:value-of select="$text-newline"/>
    </xsl:for-each>
    <!-- <xsl:apply-templates select="control-values"/> -->
    <!--
	We need an fpgm table with our predefined functions even if
	user has defined no functions.
    -->
    <xsl:text>AddInstrs("fpgm",1,</xsl:text>
    <xsl:choose>
      <xsl:when test="$all-functions[@num]">
	<xsl:apply-templates select="$all-functions[@num]"/>
      </xsl:when>
      <xsl:when test="$leg[@highest]">
	<xsl:apply-templates select="$leg"/>
      </xsl:when>
    </xsl:choose>
    <xsl:call-template name="function-zero">
      <xsl:with-param name="with-leading-newline"
		      select="boolean($all-functions[@num]) or boolean($leg)"/>
    </xsl:call-template>
    <xsl:call-template name="function-one"/>
    <xsl:call-template name="function-two"/>
    <xsl:call-template name="function-three"/>
    <xsl:apply-templates select="$all-functions[not(@num)]"/>
    <xsl:text>")</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <xsl:apply-templates select="pre-program"/>
    <xsl:apply-templates select="glyph"/>
    <!-- maxTwilightPoints -->
    <xsl:text>SetMaxpValue("TwilightPntCnt",</xsl:text>
    <xsl:value-of select="$max-twilight-points"/>    
    <xsl:text>)</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <!-- maxStorage -->
    <xsl:text>SetMaxpValue("StorageCnt",</xsl:text>
    <xsl:choose>
      <xsl:when test="number($max-storage) &gt;= $global-variable-base + 1">
        <xsl:value-of select="$max-storage"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$global-variable-base + 1"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>)</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <xsl:text>SetMaxpValue("MaxStackDepth",</xsl:text>
    <xsl:value-of select="$max-stack"/>
    <xsl:text>)</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <!-- maxFunctionDefs -->
    <xsl:variable name="v-legacy-functions">
      <xsl:choose>
	<xsl:when test="legacy-functions">
	  <xsl:value-of select="legacy-functions/@count"/>
	</xsl:when>
	<xsl:when test="functions/legacy-functions">
	  <xsl:value-of select="functions/legacy-functions/@count"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:text>0</xsl:text>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:text>SetMaxpValue("FDEFs",</xsl:text>
    <xsl:value-of select="number($v-legacy-functions) +
			  number($predefined-functions) +
			  count(/xgridfit/function|/xgridfit/functions/function)"/>
    <xsl:text>)</xsl:text>
    <xsl:value-of select="$text-newline"/>
    <xsl:if test="$infile != '!!nofile!!'">
      <xsl:variable name="o" select="normalize-space($outfile)"/>
      <xsl:choose>
        <xsl:when test="not($o) or $o = '!!nofile!!'">
          <xsl:text>Save()</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="ext" select="substring($o,string-length($o)-3)"/>
          <xsl:choose>
            <xsl:when test="$ext = '.sfd'">
              <xsl:text>Save("</xsl:text>
              <xsl:value-of select="$o"/>
              <xsl:text>")</xsl:text>
            </xsl:when>
            <xsl:when test="$ext = '.ttf'">
              <xsl:text>Generate("</xsl:text>
              <xsl:value-of select="$o"/>
              <xsl:text>"</xsl:text>
	      <xsl:if test="/xgridfit/outfile/@fmflags">
		<xsl:text>,"",</xsl:text>
		<xsl:value-of select="/xgridfit/outfile/@fmflags"/>
	      </xsl:if>
              <xsl:text>)</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="warning">
                <xsl:with-param name="msg">
                  <xsl:text>Unrecognized file extension </xsl:text>
                  <xsl:value-of select="$ext"/>
                  <xsl:text>. No file will be saved.</xsl:text>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="$text-newline"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="pre-program">
    <xsl:text>AddInstrs("prep",1,</xsl:text>
    <xsl:call-template name="pre-program-instructions"/>
    <xsl:text>")</xsl:text>
    <xsl:value-of select="$text-newline"/>
  </xsl:template>

  <xsl:template match="glyph">
    <xsl:variable name="need-variable-frame"
                  select="boolean(count(variable|variables/variable) > 0 or 
                                  count(descendant::call-function) > 0)"/>
    <xsl:call-template name="display-message">
      <xsl:with-param name="msg">
        <xsl:text>Compiling glyph </xsl:text>
        <xsl:value-of select="@ps-name"/>
      </xsl:with-param>
    </xsl:call-template>
    <xsl:text>AddInstrs("</xsl:text>
    <xsl:value-of select="@ps-name"/>
    <xsl:text>",1,</xsl:text>
    <xsl:if test="$need-variable-frame">
      <xsl:call-template name="set-up-variable-frame">
        <xsl:with-param name="with-leading-newline" select="false()"/>
      </xsl:call-template>
      <xsl:apply-templates select="variable|variables/variable"
			   mode="initialize"/>
    </xsl:if>
    <xsl:call-template name="number-command">
      <xsl:with-param name="num" select="$function-glyph-prolog"/>
      <xsl:with-param name="cmd" select="'CALL'"/>
      <xsl:with-param name="with-leading-newline" select="$need-variable-frame"/>
    </xsl:call-template>
    <xsl:apply-templates/>
    <xsl:text>")</xsl:text>
    <xsl:value-of select="$text-newline"/>
  </xsl:template>

  <!-- The following elements are declarations, read only
       by this script and never converted to code. -->
  <xsl:template match="profile"></xsl:template>

  <xsl:template match="declarations"></xsl:template>

  <xsl:template match="macros"></xsl:template>

</xsl:stylesheet>
