// *************************************************************************
// * Xgsm - mobile phone manager
// *
// * File:    xgsm_multi_editor.cc
// *
// * Purpose: Implements functions that involve two XgsmSingleEditors
// *
// * Author:  Peter Hofmann (software@pxh.de)
// *
// * Created: 8.3.2000
// *************************************************************************

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk--/button.h>
#include <gtk--/frame.h>
#include <gtk--/base.h>
#include <gtk--/main.h>
#include <iostream>

#include "xgsm_multi_editor.h"
#include "xgsm_single_editor.h"
#include "xgsm_pb_single_editor.h"
#include "xgsm_sms_single_editor.h"
#include "xgsm_util.h"
#include "xgsm_pref.h"

extern "C" {
#include "interface.h"
#include "support.h"
}

using namespace std;
using namespace Xgsm;

// MultiEditor members

MultiEditor::MultiEditor(GtkWidget *w, string prefix) :
  Gtk::Widget(w), ToplevelHelper(this),
  _prefix(prefix), _operation(CopySelected),
  _waitingForClose(false),
  _leftSensitivity(false), _rightSensitivity(false),
  _leftCloseSensitivity(true), _rightCloseSensitivity(true)
{
  // set sizes
  int width, height;
  if (prefix == "pb")
  {
    if (config.getPbSizes(width, height))
      ((Gtk::Window*)this)->set_default_size(width, height);
  }
  else
  {
    if (config.getSmsSizes(width, height))
      ((Gtk::Window*)this)->set_default_size(width, height);
  }

  // connect handlers
  destroy.connect(slot(this, &MultiEditor::onDestroy));
  LOOKUP_WIDGET(_close, _prefix + "_close_button",
                GtkButton, GTK_IS_BUTTON, this);
  _close->clicked.connect(slot(this, &MultiEditor::onClose));
  LOOKUP_WIDGET(_executeLeftToRight, _prefix + "_execute_left_to_right",
                GtkButton, GTK_IS_BUTTON, this);
  _executeLeftToRight->clicked.connect(
    slot(this, &MultiEditor::onExecuteLeftToRight));
  LOOKUP_WIDGET(_executeRightToLeft, _prefix + "_execute_right_to_left",
                GtkButton, GTK_IS_BUTTON, this);
  _executeRightToLeft->clicked.connect(
    slot(this, &MultiEditor::onExecuteRightToLeft));
  configure_event.connect(slot(this, &MultiEditor::onConfigureEvent));

  // operation menu
  LOOKUP_WIDGET(_opOptionMenu, _prefix + "_operation", GtkOptionMenu,
                GTK_IS_OPTION_MENU, this);
  _opMenu = _opOptionMenu->get_menu();
  _opMenu->selection_done.connect(slot(this, &MultiEditor::onOpMenu));

  // set initial button sensitivity
  sensitive(NULL, false, true);

  show_all();
}

gint MultiEditor::idle()
{
  if ((! _left->device().isnull() && _left->device()->busy()) ||
      (! _right->device().isnull() && _right->device()->busy()))
    return TRUE;
  delete this;
  return FALSE;
}

void MultiEditor::onClose()
{
  destroy();
}

void MultiEditor::onDestroy()
{
  // close devices FIXME
  _left->close();
  _right->close();

  if ((! _left->device().isnull() && _left->device()->busy()) ||
      (! _right->device().isnull() && _right->device()->busy()))
  {
    _waitingForClose = true;
    _idle = Gtk::Main::timeout.connect(slot(this, &MultiEditor::idle), 10);
  }
  else
    delete this;
}

void MultiEditor::onExecuteLeftToRight()
{
  _right->copyStore(_operation, _left);
}

void MultiEditor::onExecuteRightToLeft()
{
  _left->copyStore(_operation, _right);
}

void MultiEditor::onOpMenu()
{
  _operation = 0;
  for (Gtk::Menu_Helpers::MenuList::iterator i = _opMenu->items().begin();
       i != _opMenu->items().end(); ++i, ++_operation)
    if (_opMenu->get_active() == *i)
      break;
}

void MultiEditor::sensitive(SingleEditor *singleEditor, bool sensitivity,
                            bool closeSensitivity)
{
  if (! _left.isnull() && singleEditor == _left.getptr())
  {
    DEBUG_START(1);
    cout << "MultiEditor::sensitive(left, " << sensitivity << "," 
         << closeSensitivity << ")" << endl;
    DEBUG_END;
    _leftSensitivity = sensitivity;
    _leftCloseSensitivity = closeSensitivity;
  }
  else
    if (! _right.isnull())
    {
      DEBUG_START(1);
      cout << "MultiEditor::sensitive(right, " << sensitivity << "," 
           << closeSensitivity << ")" << endl;
      DEBUG_END;
      assert(singleEditor == _right.getptr());
      _rightSensitivity = sensitivity;
      _rightCloseSensitivity = closeSensitivity;
    }
  _opOptionMenu->set_sensitive(_leftSensitivity && _rightSensitivity);
  _executeLeftToRight->set_sensitive(_leftSensitivity && _rightSensitivity);
  _executeRightToLeft->set_sensitive(_leftSensitivity && _rightSensitivity);
}

void MultiEditor::setPanedPosition(SingleEditor *caller, int position)
{
  // avoid recursion
  if (caller != _left.getptr())
    _left->setPanedPosition(position);
  if (caller != _right.getptr())
    _right->setPanedPosition(position);
}

MultiEditor::~MultiEditor()
{
  _idle.disconnect();
}

// PbMultiEditor members

PbMultiEditor::PbMultiEditor() :
  MultiEditor(create_phonebook_window(), "pb")
{
  Gtk::Frame *f;
  LOOKUP_WIDGET(f, "pb_left_frame", GtkFrame, GTK_IS_FRAME, this);
  _left = new PbSingleEditor(this, f, true);
  LOOKUP_WIDGET(f, "pb_right_frame", GtkFrame, GTK_IS_FRAME, this);
  _right = new PbSingleEditor(this, f, false);
}

gint PbMultiEditor::onConfigureEvent(GdkEventConfigure* event)
{
  config.setPbSizes(event->width, event->height);
  return TRUE;
}

// SmsMultiEditor members

SmsMultiEditor::SmsMultiEditor() :
  MultiEditor(create_sms_store_window(), "sms")
{
  Gtk::Frame *f;
  LOOKUP_WIDGET(f, "sms_left_frame", GtkFrame, GTK_IS_FRAME, this);
  _left = new SMSSingleEditor(this, f, true);
  LOOKUP_WIDGET(f, "sms_right_frame", GtkFrame, GTK_IS_FRAME, this);
  _right = new SMSSingleEditor(this, f, false);
}

gint SmsMultiEditor::onConfigureEvent(GdkEventConfigure* event)
{
  config.setSmsSizes(event->width, event->height);
  return TRUE;
}
