%{
/*
    $Id: xkeysw-lex.l,v 1.3 2001/06/21 21:14:35 dima Exp $

    xkeysw - window bound/multi code keyboard switch
    Copyright (C) 2000  Dima Barsky <dima@debian.org>,
                        Igor Belyi  <ibelyi@yahoo.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "xkeyswrc.h"
#include "xkeysw-yacc.h"

/* define environment variable pointing to where include files can be found */
#define DATADIR_PATH "XKEYSW_DATAPATH"

static char* newStr(char* src, int len);

typedef struct stateStack_t {
    YY_BUFFER_STATE state;
    FILE* fid;
    struct stateStack_t* next;
} stateStack_t;

stateStack_t *stateStack = NULL;

/* turn off output */
#define ECHO

%}

%s nl

qstring	      \"[^\"\n]*\"
name	      [A-Za-z0-9_\-]+
pattern	      [A-Za-z0-9_\-\*]+

%%

group		return GROUP;
keymap		return KEYMAP;
include		return INCLUDE;
keysym		return KEYSYM;
except		return EXCEPT;

[=,(),\{\}/]	{return yytext[0];}

{name}		{yylval.name=newStr(yytext,strlen(yytext)); return NAME;}

{qstring}	{yylval.name=newStr(yytext+1,strlen(yytext)-2); return STRING;}

{pattern}	{yylval.name=newStr(yytext,strlen(yytext)); return PATTERN;}

<nl>\n		{return NL;}

[!#].*\n	{ unput('\n'); /* Comments. Put '\n' back for <nl> state */ }

.		/* eat all others */

%%

static char* getFullName(char* filename) {
    char *paths[4];
    static char *file;
    int i;

    if(filename == NULL || *filename == '\0')
	return NULL;

    if(strchr(filename, '/'))
	return filename;

    paths[0] = getenv(DATADIR_PATH);
    paths[1] = getenv("HOME");
    paths[2] = PKGDATADIR;

    for(i=0; i<3; i++)
	if(paths[i] != NULL) {
	    file = malloc(strlen(paths[i]) + strlen(filename) + 2);
	    if(file == NULL) {
		fprintf(stderr, "Cannot allocat string for full path name.\n");
		return NULL;
	    }
	    strcpy(file, paths[i]);
	    strcat(file, "/");
	    strcat(file, filename);
	    
	    if(!access(file, R_OK))
		return file;

	    free(file);
	}

    return filename;
}

/* Start to parse a file */
int includeFile(char* filename)
{
    FILE *fid;
    char* fullFilename;

    if((fullFilename = getFullName(filename)) == NULL)
	return 1;

    if((fid = fopen(fullFilename, "r")) == NULL)
	perror(fullFilename);

    if(fullFilename != filename)
	free(fullFilename);
    
    if(yyin) {
	stateStack_t *state;
	state = (stateStack_t*)malloc(sizeof(stateStack_t));
	state->state = YY_CURRENT_BUFFER;
	state->fid = yyin;
	state->next = stateStack;
	stateStack = state;
	yyin = fid;
	yy_switch_to_buffer(yy_create_buffer(fid, YY_BUF_SIZE));
    } else {
	yyin = fid;
	yyparse();
    }

    return 0;
}

int yywrap()
{
    stateStack_t* curr;

    if(stateStack == NULL)
	return 1;

    curr = stateStack;
    stateStack = curr->next;
    yy_delete_buffer( YY_CURRENT_BUFFER );
    yy_switch_to_buffer(curr->state);
    yyin = curr->fid;
    free(curr);

    return 0;
}

/* Made a copy of a string with memory allocation */
static char* newStr(char* src, int len)
{
    char* result;

    if((result = malloc(len+1)) != NULL) {
	strncpy(result, src, len);
	result[len] = '\0';
    }
    return result;
}

/* Switch parser to <nl> state */
void beginNLmatch()
{
    BEGIN(nl);
}

/* Switch parser back to initial state */
void beginInitial()
{
    BEGIN(INITIAL);
}
