/* ,file-id archive://[lord]/379/vu/./ar.h/1998-05-18
*/
#ifndef ARH
#define ARH

/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



/* 
 * These functions, which are a higher-level interface to "xmalloc"
 * and "xrealloc", manipulated "dynamically resizable arrays".
 *
 * A dynamically resizable array is a region allocated from the heap,
 * which has a hidden header that remembers the size of the region
 * expressed as a number of "elements" of unspecified size.
 *
 * The function "asize" returns that number for a given array.
 *
 * The function "aref" is used to compute the address of some element
 * of an array; as an important side effect, it will resize the array 
 * to create that element if it does not already exist.
 *
 * The null pointer counts as an array of 0 elements, so the standard
 * idiom for initializing an array of K elements is:
 *
 *	T * the_array;		/ * Keep only one copy of this pointer,
 *				   since the array may change location. * /
 *
 *	the_array = 0;		/ * Start with an array of 0 elements. * /
 *	aref ((void **)&the_array, K);	/ * Expand it to K elements. * /
 *
 *	/ * storage for the_array[0 .. K-1] has been allocated. * /
 *
 * The function "asetsize" is an alternative way to change the size of 
 * an array.  Unlike "aref", "asetsize" can be used to make an array smaller.
 * 
 * The functions "apush" and "apop" present a stack-style interface
 * to these arrays.
 *
 * "afree" is used to de-allocate an array.
 */


/* automatically generated __STDC__ prototypes */
extern int asize (void * base);
extern void * aref (void ** base, int n, int szof);
extern void * apush (void ** base, int szof);
extern void * apop (void ** base, int szof);
extern void asetsize (void ** base, int n, int szof);
extern void afree (void ** base);
#endif  /* ARH */
