/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xcolgbc.c                                                     *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : color corrections                                        *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : XMdcColGbcCorrectExpose()       - Expose wrapper Update  * 
 *                XMdcColGbcCorrectUpdate()       - Update GBC image       *
 *                XMdcColGbcCorrectMakeIcons()    - Make slider icons      *
 *                XMdcColGbcCorrectAddImg()       - Add example image      *
 *                XMdcColGbcCorrectModValue()     - Modify slider values   *
 *                XMdcColGbcCorrectResetValue()   - Reset  slider values   *
 *                XMdcColGbcCorrectAddOneSlider() - Add one slider         * 
 *                XMdcColGbcCorrectAddSliders();  - Add all sliders        *
 *                XMdcColGbcCorrectApply();       - Apply  callback        *
 *                XMdcColGbcCorrectCancel();      - Cancel callback        *
 *                XMdcColGbcCorrectSel();         - GBC selection          *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xcolgbc.c,v 1.14 2004/10/21 23:48:39 enlf Exp $
 */

/*
   Copyright (C) 1997-2004 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */


/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "m-depend.h"

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#ifndef _WIN32
#include <strings.h>
#endif
#endif

#include "xmedcon.h"

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

static GtkWidget *wgbc=NULL;
static ColorModifier modtmp;
static SliderValueStruct svgamma, svbrightness, svcontrast;

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/
gboolean XMdcColGbcCorrectExpose(GtkWidget *widget, 
		         GdkEventExpose *event, gpointer data)
{

  XMdcColGbcCorrectUpdate();

  return(TRUE);

}

void XMdcColGbcCorrectUpdate(void)
{
  GtkWidget *area;
  GdkPixbuf *imtmp, *imnew;
  GdkGC *gc;
  int w, h;

  area = sGbc.area;
  gc = area->style->white_gc;

  XMdcSetGbcCorrection(&modtmp);

  imtmp = XMdcBuildGdkPixbuf(sGbc.img8,sGbc.w,sGbc.h,sGbc.t,modtmp.vgbc);

  w = gdk_pixbuf_get_width(sGbc.im);
  h = gdk_pixbuf_get_height(sGbc.im);

  gdk_pixbuf_unref(sGbc.im);

  imnew = gdk_pixbuf_scale_simple(imtmp,w,h,sRenderSelection.Interp);
  gdk_pixbuf_unref(imtmp); sGbc.im = imnew;

  gdk_pixbuf_render_to_drawable(sGbc.im,area->window,gc,0,0,0,0,w,h,
                                sRenderSelection.Dither,0,0);

}

void XMdcColGbcCorrectMakeIcons(void)
{

  GdkPixbuf *im0, *im;
  
  im0=gdk_pixbuf_new_from_data(xmdc_brightness_icon, GDK_COLORSPACE_RGB, FALSE,                                8, 12, 12, 3*12, (void(*)())NULL, NULL);
  im = gdk_pixbuf_add_alpha(im0,TRUE,0xff,0x00,0xff);
  gdk_pixbuf_render_pixmap_and_mask(im,&sGbc.brightness_pmap
                                      ,&sGbc.brightness_mask,254);
  gdk_pixbuf_unref(im); gdk_pixbuf_unref(im0);

  im0=gdk_pixbuf_new_from_data(xmdc_contrast_icon,   GDK_COLORSPACE_RGB, FALSE,
                               8, 12, 12, 3*12, (void(*)())NULL, NULL);
  im = gdk_pixbuf_add_alpha(im0,TRUE,0xff,0x00,0xff);
  gdk_pixbuf_render_pixmap_and_mask(im,&sGbc.contrast_pmap
                                      ,&sGbc.contrast_mask,254);
  gdk_pixbuf_unref(im); gdk_pixbuf_unref(im0);

  im0=gdk_pixbuf_new_from_data(xmdc_gamma_icon,      GDK_COLORSPACE_RGB, FALSE,
                               8, 12, 12, 3*12, (void(*)())NULL, NULL);
  im = gdk_pixbuf_add_alpha(im0,TRUE,0xff,0x00,0xff);
  gdk_pixbuf_render_pixmap_and_mask(im,&sGbc.gamma_pmap
                                      ,&sGbc.gamma_mask,254);
  gdk_pixbuf_unref(im); gdk_pixbuf_unref(im0);

}

void XMdcColGbcCorrectAddImg(GtkWidget *w)
{
  GtkWidget *box, *area, *imgbox;
  int rw, rh;

  rw = (signed)XMdcScaleW(sGbc.w);
  rh = (signed)XMdcScaleH(sGbc.h);

  box = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(w), box, FALSE, FALSE, 0);
  gtk_widget_show(box);

  imgbox = gtk_hbox_new(FALSE,2);
  gtk_box_pack_start(GTK_BOX(box), imgbox, TRUE, TRUE, 0);
  gtk_widget_show(imgbox);

  area = gtk_drawing_area_new();

  gtk_widget_set_events(area, GDK_EXPOSURE_MASK);
  gtk_drawing_area_size(GTK_DRAWING_AREA(area), rw, rh); 
  gtk_box_pack_start(GTK_BOX(imgbox), area, FALSE, FALSE, 0);
  gtk_widget_show(area);
  gtk_signal_connect(GTK_OBJECT(area),"expose_event",
                     GTK_SIGNAL_FUNC(XMdcColGbcCorrectExpose), NULL);
  sGbc.area = area;
}

void XMdcColGbcCorrectModValue(GtkWidget *widget, SliderValueStruct *v)
{
  (*(v->value)) = (int)GTK_ADJUSTMENT(v->adj)->value;
  XMdcColGbcCorrectUpdate();
}

void XMdcColGbcCorrectResetValue(GtkWidget *widget, SliderValueStruct *v)
{
  (*(v->value)) = 255;
  GTK_ADJUSTMENT(v->adj)->value = (gfloat)(*(v->value));
  gtk_range_set_adjustment(GTK_RANGE(v->range), GTK_ADJUSTMENT(v->adj));
  gtk_range_slider_update(GTK_RANGE(v->range));
  XMdcColGbcCorrectUpdate();
}

void XMdcColGbcCorrectAddOneSlider(GtkWidget *w, int *value, GtkWidget *ic, SliderValueStruct *sv)
{
  GtkObject  *adj;
  GtkWidget  *range, *button, *box;

  box = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(w), box, FALSE, FALSE, 0);
  gtk_widget_show(box);
  adj = gtk_adjustment_new((gfloat)(*value), 0.0, 1024.0, 1.0, 8.0, 0.0);
  range = gtk_hscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_set_usize(range, 200, 12);
  gtk_range_set_update_policy(GTK_RANGE(range), GTK_UPDATE_CONTINUOUS);
  gtk_scale_set_draw_value(GTK_SCALE(range), FALSE);

  sv->adj = adj;
  sv->range = range;
  sv->value = value;
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed", 
                     GTK_SIGNAL_FUNC(XMdcColGbcCorrectModValue), sv);
  gtk_box_pack_start(GTK_BOX(box), range, FALSE, FALSE, 0);
  gtk_widget_show(range);
  button = gtk_button_new();
  gtk_container_add(GTK_CONTAINER(button), ic);
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
                     GTK_SIGNAL_FUNC(XMdcColGbcCorrectResetValue), sv);
  gtk_widget_show(button);
  gtk_box_pack_start(GTK_BOX(box), button, FALSE, FALSE, 0);

}

void XMdcColGbcCorrectAddSliders(GtkWidget *w)
{
  GtkWidget *frame, *box, *box0, *box1, *i1, *i2, *i3;

  XMdcColGbcCorrectMakeIcons();

  box0 = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(w), box0);
  gtk_widget_show(box0);

  box1 = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(box0), box1);
  gtk_widget_show(box1);

  i1 = gtk_pixmap_new(sGbc.gamma_pmap, sGbc.gamma_mask);
  gtk_widget_show(i1);
  i2 = gtk_pixmap_new(sGbc.brightness_pmap, sGbc.brightness_mask);
  gtk_widget_show(i2);
  i3 = gtk_pixmap_new(sGbc.contrast_pmap, sGbc.contrast_mask);
  gtk_widget_show(i3);

  frame = gtk_aspect_frame_new("Base Levels", 0.5, 0.5, 0.0, TRUE);
  gtk_box_pack_start(GTK_BOX(box1), frame, FALSE, FALSE, 4);
  gtk_widget_show(frame);
  box = gtk_vbox_new(TRUE, 0);
  gtk_container_add(GTK_CONTAINER(frame), box);
  gtk_widget_show(box);
  XMdcColGbcCorrectAddOneSlider(box,(int *)&modtmp.gamma,i1,&svgamma);
  XMdcColGbcCorrectAddOneSlider(box,(int *)&modtmp.brightness,i2,&svbrightness);
  XMdcColGbcCorrectAddOneSlider(box,(int *)&modtmp.contrast,i3,&svcontrast);

  XMdcColGbcCorrectAddImg(box0);

  gdk_pixmap_unref(sGbc.gamma_pmap);
  gdk_pixmap_unref(sGbc.brightness_pmap);
  gdk_pixmap_unref(sGbc.contrast_pmap);

}

void XMdcColGbcCorrectApply(GtkWidget *widget, gpointer data)
{
  sGbc.mod.gamma = modtmp.gamma;
  sGbc.mod.brightness = modtmp.brightness;
  sGbc.mod.contrast = modtmp.contrast;
  memcpy(sGbc.mod.vgbc,modtmp.vgbc,256);

  if (XMDC_FILE_OPEN == MDC_YES) {

    gtk_widget_set_sensitive(my.viewwindow,FALSE);

    XMdcRemovePreviousColorMap();
    XMdcRemovePreviousImages();

    XMdcBuildColorMap();
    XMdcBuildCurrentImages();

    gtk_widget_set_sensitive(my.viewwindow,TRUE);

  }

}

void XMdcColGbcCorrectSel(GtkWidget *widget, Uint32 nr)
{
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *button;
  GtkWidget *separator;
  GdkPixbuf *im;
  int rw, rh;

  sGbc.nr = nr;
  sGbc.i = my.realnumber[nr];
  sGbc.w = my.fi->image[sGbc.i].width;
  sGbc.h = my.fi->image[sGbc.i].height;
  sGbc.t = my.fi->image[sGbc.i].type;
  modtmp.gamma = sGbc.mod.gamma;
  modtmp.brightness = sGbc.mod.brightness;
  modtmp.contrast = sGbc.mod.contrast;
  XMdcSetGbcCorrection(&modtmp);
  rw = (signed)XMdcScaleW(sGbc.w);
  rh = (signed)XMdcScaleH(sGbc.h);

  MdcFree(sGbc.img8);

  sGbc.img8 = MdcGetDisplayImage(my.fi,sGbc.i);
  if (sGbc.img8 == NULL) {
    XMdcDisplayErr("Couldn't alloc byte buffer");
    return;
  }

  im = XMdcBuildGdkPixbuf(sGbc.img8,sGbc.w,sGbc.h,sGbc.t,modtmp.vgbc);
  if (im == NULL) {
    MdcFree(sGbc.img8);
    XMdcDisplayErr("Couldn't create GdkPixbuf");
    return;
  }

  if ( wgbc == NULL ) {

    sGbc.im = im;

    wgbc = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_policy(GTK_WINDOW(wgbc), TRUE, TRUE, TRUE);

    gtk_signal_connect(GTK_OBJECT(wgbc),"destroy",
                       GTK_SIGNAL_FUNC(XMdcMedconQuit), NULL);
    gtk_signal_connect(GTK_OBJECT(wgbc),"delete_event",
              GTK_SIGNAL_FUNC(XMdcHandlerToHide), NULL);

    gtk_window_set_title(GTK_WINDOW(wgbc),"Color Correction");
    gtk_container_set_border_width(GTK_CONTAINER(wgbc), 1);

    box1 = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(wgbc), box1);
    gtk_widget_show(box1);

    /* create sliders for correction */
    XMdcColGbcCorrectAddSliders(box1);

    /* create horizontal separator */
    separator = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(box1), separator, FALSE, FALSE, 0);
    gtk_widget_show(separator);

    /* create bottom button box */
    box2 = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(box1), box2, TRUE, TRUE, 2);
    gtk_widget_show(box2);

    button = gtk_button_new_with_label("Apply");
    gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 2);
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(gtk_widget_hide),GTK_OBJECT(wgbc));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(XMdcColGbcCorrectApply), NULL);
    gtk_widget_show(button);

    button = gtk_button_new_with_label("Cancel");
    gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 2);
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
              GTK_SIGNAL_FUNC(gtk_widget_hide),GTK_OBJECT(wgbc));
    gtk_widget_show(button);

  }else{

    /* replace image / update sliders */

    gtk_window_set_policy(GTK_WINDOW(wgbc), TRUE, TRUE, TRUE);

    gdk_pixbuf_unref(sGbc.im);

    sGbc.im = im;

    gdk_window_clear(sGbc.area->window);

    gtk_drawing_area_size(GTK_DRAWING_AREA(sGbc.area), rw, rh);

    GTK_ADJUSTMENT(svgamma.adj)->value      = sGbc.mod.gamma;
    GTK_ADJUSTMENT(svbrightness.adj)->value = sGbc.mod.brightness;
    GTK_ADJUSTMENT(svcontrast.adj)->value   = sGbc.mod.contrast;
    
    XMdcColGbcCorrectUpdate();


  }

  gtk_window_set_policy(GTK_WINDOW(wgbc), FALSE, FALSE, TRUE);

  XMdcShowWidget(wgbc);

}

