/*
 * Xmmsfind - A small plugin similar to the built-in "Jump to file" util. 
 * Copyright (C) 2001 Isak Savo <iso01001@student.mdh.se>
 * 
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public Licensse as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This program is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.  You
 * should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <glib.h>
#include <xmms/xmmsctrl.h>
#include <argp.h>


#define SEARCH_CMD "search"

/* Usable arguments: */
static struct argp_option options[] = {
  {"session",  'n', "ID",      0,  "Select XMMS session (Default: first found)" },
  { 0 }
};

struct arguments
{
  char *args[5];	/* just one valid arg, increase if more are added */
  int session;
};

/* Parse a single option. */
static error_t
parse_opt (int key, char *arg, struct argp_state *state)
{
  /* Get the input argument from argp_parse, which we
     know is a pointer to our arguments structure. */
  struct arguments *arguments = state->input;

  switch (key)
    {
    case 'n':
      arguments->session = atoi(arg);
      break;

    default:
      return ARGP_ERR_UNKNOWN;
    }
  return 0;
}

/* Our argp parser. */
static struct argp argp = { options, parse_opt };


/*
 * Get the sessionnumber that xmms is running at. (Checks all sessions
 * ranging from 0 to 16) ("Borrowed" from Alexandre David's
 * <adavid@docs.uu.se> xmms-ctrl plugin. Thanx man!) 
 */
gint get_xmms_session ()
{
    gint query;
    
    for (query = 0; query < 16; query++)
      if (xmms_remote_is_running (query))
	return query;
    return -1;
}


/* Opens the fifo locate in ~/.xmms/ and writes the searchcommand to it
 * the xmmsfind general plugin will then launch the searchbox */
int main (int argc, char **argv)
{
    FILE *fifo;
    char fifo_path[_POSIX_PATH_MAX];
    int	session;
    struct arguments arguments;

    if (0 > (session = get_xmms_session()))
    {
	printf ("Xmms not running\n");
	return 0;
    }

    arguments.session = session; /* default to first session */
    argp_parse (&argp, argc, argv, 0, 0, &arguments);
    session = arguments.session;

    if (!xmms_remote_is_running(session)) {
	    printf ("%d is not a valid Xmms session number\n", session);
	    return 0;
    }

    snprintf (fifo_path, _POSIX_PATH_MAX, "%s/.xmms/xmmsfind_fifo-%d", getenv ("HOME"), session);
    if ((fifo = fopen (fifo_path, "w")) == NULL)
    {
	fprintf (stderr, "Unable to open fifo '%s'\nAborting\n", fifo_path);
	return 0;
    }
    fputs (SEARCH_CMD, fifo);
    return 0;
}
