/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  FM Radio plug-in v1.2
 *  Copyright (C) 1999 Julien Viard <Julien.Viard@enst.fr>
 *  
 *  Radio acces routines from Keith Wesolowski (wesolows@cs.unr.edu)
 *  GRadio 1.0.0
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef RADIO_H
#define RADIO_H

//#include "config.h"

/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/* As config.h is no longer used, you may have to change one of the 
     following lines. these lines come from my config.h*/

/* Define if you have the <machine/soundcard.h> header file.  */
/* #undef HAVE_MACHINE_SOUNDCARD_H */
/* Define if you have the <sys/soundcard.h> header file.  */
#define HAVE_SYS_SOUNDCARD_H 1

/* end of config.h partial copy */
/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <math.h>

#ifdef HAVE_SYS_SOUNDCARD_H
#ifdef __OpenBSD__
#include <sys/audioio.h>
#else
#include <sys/soundcard.h>
#endif /* __OpenBSD__ */
#else
#ifdef HAVE_MACHINE_SOUNDCARD_H
#include <machine/soundcard.h>
#endif
#endif

#ifdef linux
#include <linux/videodev.h>
#elif defined __OpenBSD__
#include <sys/radioio.h>
#endif /* linux  || __OpenBSD__ */

#include <fcntl.h>

#ifdef HAVE_MNTENT_H
#include <mntent.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#ifdef linux
#include <gtk/gtk.h>
#elif defined __OpenBSD__
#include <gtk-1.2/gtk/gtk.h>
#endif /* linux || __OpenBSD__ */

//#include "xmms/plugin.h"
//#include "libxmms/configfile.h"
#include <xmms/plugin.h>
#include <xmms/configfile.h>
#include <xmms/util.h>

/* FIXME: These should be replaced with values from a query */
#define FMR_FREQ_MIN 87800
#define FMR_FREQ_MAX 108100
#define FMR_FREQ_DEFAULT 98200
#define FMR_VOL_MIN 0
#define FMR_VOL_MAX 255
#define FMR_VOL_DEFAULT 128

#define STR_LEN_MAX 80

#ifdef __OpenBSD__
#define GET_INFO	0
#define SET_INFO	1
#endif /* __OpenBSD__ */

typedef struct
{
	gchar *device;
	gchar *directory;
	gboolean use_oss_mixer;
}
RadioConfig;

extern RadioConfig radio_cfg;
#ifdef __OpenBSD__
extern struct radio_info ri;
#endif /* __OpenBSD__ */

extern gint radio_fd;
extern gint freq,volume;
extern gboolean is_paused,tuned;
double fmradio_get_freq_fact (void);

void radio_configure(void);

void radio_file_info_box(char *filename);

#ifdef __OpenBSD__
int SetGetRadioInfo(int);
#endif /* __OpenBSD__ */

#endif /* RADIO_H */
