dnl AM_PATH_SMPEG([MINIMUM-VERSION, [ACTION-IF-FOUND [,ACTION-IF-NOT-FOUND]]])
dnl Test for SMPEG, and define SMPEG_CFLAGS and SMPEG_LIBS
dnl
AC_DEFUN(AM_PATH_SMPEG,
[dnl
dnl Get the cflags and libraries from the smpeg-config script
dnl
AC_ARG_WITH(smpeg-prefix,[  --with-smpeg-prefix=PFX   Prefix where SMPEG is installed (optional)],
            smpeg_prefix="$withval", smpeg_prefix="")
AC_ARG_WITH(smpeg-exec-prefix,[  --with-smpeg-exec-prefix=PFX Exec prefix where SMPEG is installed (optional)],
            smpeg_exec_prefix="$withval", smpeg_exec_prefix="")
AC_ARG_ENABLE(smpegtest, [  --disable-smpegtest       Do not try to compile and run a test SMPEG program], 
	, enable_smpegtest=yes)

  if test x$smpeg_exec_prefix != x ; then
     smpeg_args="$smpeg_args --exec-prefix=$smpeg_exec_prefix"
     if test x${SMPEG_CONFIG+set} != xset ; then
        SMPEG_CONFIG=$smpeg_exec_prefix/bin/smpeg-config
     fi
  fi
  if test x$smpeg_prefix != x ; then
     smpeg_args="$smpeg_args --prefix=$smpeg_prefix"
     if test x${SMPEG_CONFIG+set} != xset ; then
        SMPEG_CONFIG=$smpeg_prefix/bin/smpeg-config
     fi
  fi

  AC_PATH_PROG(SMPEG_CONFIG, smpeg-config, no)
  min_smpeg_version=ifelse([$1], ,0.2.7,$1)
  AC_MSG_CHECKING(for SMPEG - version >= $min_smpeg_version)
  no_smpeg=""
  if test "$SMPEG_CONFIG" = "no" ; then
    no_smpeg=yes
  else
    SMPEG_CFLAGS=`$SMPEG_CONFIG $smpegconf_args --cflags`
    SMPEG_LIBS=`$SMPEG_CONFIG $smpegconf_args --libs`

    smpeg_major_version=`$SMPEG_CONFIG $smpeg_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    smpeg_minor_version=`$SMPEG_CONFIG $smpeg_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    smpeg_micro_version=`$SMPEG_CONFIG $smpeg_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_smpegtest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $SMPEG_CFLAGS $SDL_CFLAGS"
      LIBS="$LIBS $SMPEG_LIBS $SDL_LIBS"
dnl
dnl Now check if the installed SMPEG is sufficiently new. (Also sanity
dnl checks the results of smpeg-config to some extent
dnl
      rm -f conf.smpegtest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "smpeg.h"

char*
my_strdup (char *str)
{
  char *new_str;

  if (str)
    {
      new_str = (char *)malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;

  return new_str;
}

int main (int argc, char *argv[])
{
  int major, minor, micro;
  char *tmp_version;

  /* This hangs on some systems (?)
  system ("touch conf.smpegtest");
  */
  { FILE *fp = fopen("conf.smpegtest", "a"); if ( fp ) fclose(fp); }

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_smpeg_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_smpeg_version");
     exit(1);
   }

   if (($smpeg_major_version > major) ||
      (($smpeg_major_version == major) && ($smpeg_minor_version > minor)) ||
      (($smpeg_major_version == major) && ($smpeg_minor_version == minor) 
&& ($smpeg_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'smpeg-config --version' returned %d.%d.%d, but the 
minimum version\n", $smpeg_major_version, $smpeg_minor_version,
$smpeg_micro_version);
      printf("*** of SMPEG required is %d.%d.%d. If smpeg-config is
correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If smpeg-config was wrong, set the environment variable
SMPEG_CONFIG\n");
      printf("*** to point to the correct copy of smpeg-config, and remove 
the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],, no_smpeg=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_smpeg" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])
  else
     AC_MSG_RESULT(no)
     if test "$SMPEG_CONFIG" = "no" ; then
       echo "*** The smpeg-config script installed by SMPEG could not be found"
       echo "*** If SMPEG was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the SMPEG_CONFIG environment variable to the"
       echo "*** full path to smpeg-config."
     else
       if test -f conf.smpegtest ; then
        :
       else
          echo "*** Could not run SMPEG test program, checking why..."
          CFLAGS="$CFLAGS $SMPEG_CFLAGS $SDL_CFLAGS"
          LIBS="$LIBS $SMPEG_LIBS $SDL_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include "smpeg.h"
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding SMPEG or finding the wrong"
          echo "*** version of SMPEG. If it is not finding SMPEG, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
          echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means SMPEG was incorrectly installed"
          echo "*** or that you have moved SMPEG since it was installed. In the latter case, you"
          echo "*** may want to edit the smpeg-config script: $SMPEG_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     SMPEG_CFLAGS=""
     SMPEG_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(SMPEG_CFLAGS)
  AC_SUBST(SMPEG_LIBS)
  rm -f conf.smpegtest
])

dnl Usage:
dnl AM_PATH_XMMS([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl
dnl Example:
dnl AM_PATH_XMMS(0.9.5.1, , AC_MSG_ERROR([*** XMMS >= 0.9.5.1 not installed - please install first ***]))
dnl
dnl Defines XMMS_CFLAGS, XMMS_LIBS, XMMS_DATA_DIR, XMMS_PLUGIN_DIR, 
dnl XMMS_VISUALIZATION_PLUGIN_DIR, XMMS_INPUT_PLUGIN_DIR, 
dnl XMMS_OUTPUT_PLUGIN_DIR, XMMS_GENERAL_PLUGIN_DIR, XMMS_EFFECT_PLUGIN_DIR,
dnl and XMMS_VERSION for your plugin pleasure.
dnl

dnl XMMS_TEST_VERSION(AVAILABLE-VERSION, NEEDED-VERSION [, ACTION-IF-OKAY [, ACTION-IF-NOT-OKAY]])
AC_DEFUN(XMMS_TEST_VERSION, [

# Determine which version number is greater. Prints 2 to stdout if	
# the second number is greater, 1 if the first number is greater,	
# 0 if the numbers are equal.						
									
# Written 15 December 1999 by Ben Gertzfield <che@debian.org>		
# Revised 15 December 1999 by Jim Monty <monty@primenet.com>		
									
    AC_PROG_AWK
    xmms_got_version=[` $AWK '						\
BEGIN {									\
    print vercmp(ARGV[1], ARGV[2]);					\
}									\
									\
function vercmp(ver1, ver2,    ver1arr, ver2arr,			\
                               ver1len, ver2len,			\
                               ver1int, ver2int, len, i, p) {		\
									\
    ver1len = split(ver1, ver1arr, /\./);				\
    ver2len = split(ver2, ver2arr, /\./);				\
									\
    len = ver1len > ver2len ? ver1len : ver2len;			\
									\
    for (i = 1; i <= len; i++) {					\
        p = 1000 ^ (len - i);						\
        ver1int += ver1arr[i] * p;					\
        ver2int += ver2arr[i] * p;					\
    }									\
									\
    if (ver1int < ver2int)						\
        return 2;							\
    else if (ver1int > ver2int)						\
        return 1;							\
    else								\
        return 0;							\
}' $1 $2`]								

    if test $xmms_got_version -eq 2; then 	# failure
	ifelse([$4], , :, $4)			
    else  					# success!
	ifelse([$3], , :, $3)
    fi
])

# Configure paths for GTK+
# Owen Taylor     97-11-3

dnl AM_PATH_GTK([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for GTK, and define GTK_CFLAGS and GTK_LIBS
dnl
AC_DEFUN(AM_PATH_GTK,
[dnl 
dnl Get the cflags and libraries from the gtk-config script
dnl
AC_ARG_WITH(gtk-prefix,[  --with-gtk-prefix=PFX   Prefix where GTK is installed (optional)],
            gtk_config_prefix="$withval", gtk_config_prefix="")
AC_ARG_WITH(gtk-exec-prefix,[  --with-gtk-exec-prefix=PFX Exec prefix where GTK is installed (optional)],
            gtk_config_exec_prefix="$withval", gtk_config_exec_prefix="")
AC_ARG_ENABLE(gtktest, [  --disable-gtktest       Do not try to compile and run a test GTK program],
		    , enable_gtktest=yes)

  for module in . $4
  do
      case "$module" in
         gthread) 
             gtk_config_args="$gtk_config_args gthread"
         ;;
      esac
  done

  if test x$gtk_config_exec_prefix != x ; then
     gtk_config_args="$gtk_config_args --exec-prefix=$gtk_config_exec_prefix"
     if test x${GTK_CONFIG+set} != xset ; then
        GTK_CONFIG=$gtk_config_exec_prefix/bin/gtk-config
     fi
  fi
  if test x$gtk_config_prefix != x ; then
     gtk_config_args="$gtk_config_args --prefix=$gtk_config_prefix"
     if test x${GTK_CONFIG+set} != xset ; then
        GTK_CONFIG=$gtk_config_prefix/bin/gtk-config
     fi
  fi

  AC_PATH_PROG(GTK_CONFIG, gtk-config, no)
  min_gtk_version=ifelse([$1], ,0.99.7,$1)
  AC_MSG_CHECKING(for GTK - version >= $min_gtk_version)
  no_gtk=""
  if test "$GTK_CONFIG" = "no" ; then
    no_gtk=yes
  else
    GTK_CFLAGS=`$GTK_CONFIG $gtk_config_args --cflags`
    GTK_LIBS=`$GTK_CONFIG $gtk_config_args --libs`
    gtk_config_major_version=`$GTK_CONFIG $gtk_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    gtk_config_minor_version=`$GTK_CONFIG $gtk_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    gtk_config_micro_version=`$GTK_CONFIG $gtk_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_gtktest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $GTK_CFLAGS"
      LIBS="$GTK_LIBS $LIBS"
dnl
dnl Now check if the installed GTK is sufficiently new. (Also sanity
dnl checks the results of gtk-config to some extent
dnl
      rm -f conf.gtktest
      AC_TRY_RUN([
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.gtktest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_gtk_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_gtk_version");
     exit(1);
   }

  if ((gtk_major_version != $gtk_config_major_version) ||
      (gtk_minor_version != $gtk_config_minor_version) ||
      (gtk_micro_version != $gtk_config_micro_version))
    {
      printf("\n*** 'gtk-config --version' returned %d.%d.%d, but GTK+ (%d.%d.%d)\n", 
             $gtk_config_major_version, $gtk_config_minor_version, $gtk_config_micro_version,
             gtk_major_version, gtk_minor_version, gtk_micro_version);
      printf ("*** was found! If gtk-config was correct, then it is best\n");
      printf ("*** to remove the old version of GTK+. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If gtk-config was wrong, set the environment variable GTK_CONFIG\n");
      printf("*** to point to the correct copy of gtk-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
#if defined (GTK_MAJOR_VERSION) && defined (GTK_MINOR_VERSION) && defined (GTK_MICRO_VERSION)
  else if ((gtk_major_version != GTK_MAJOR_VERSION) ||
	   (gtk_minor_version != GTK_MINOR_VERSION) ||
           (gtk_micro_version != GTK_MICRO_VERSION))
    {
      printf("*** GTK+ header files (version %d.%d.%d) do not match\n",
	     GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     gtk_major_version, gtk_minor_version, gtk_micro_version);
    }
#endif /* defined (GTK_MAJOR_VERSION) ... */
  else
    {
      if ((gtk_major_version > major) ||
        ((gtk_major_version == major) && (gtk_minor_version > minor)) ||
        ((gtk_major_version == major) && (gtk_minor_version == minor) && (gtk_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of GTK+ (%d.%d.%d) was found.\n",
               gtk_major_version, gtk_minor_version, gtk_micro_version);
        printf("*** You need a version of GTK+ newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** GTK+ is always available from ftp://ftp.gtk.org.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the gtk-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of GTK+, but you can also set the GTK_CONFIG environment to point to the\n");
        printf("*** correct copy of gtk-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_gtk=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_gtk" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$GTK_CONFIG" = "no" ; then
       echo "*** The gtk-config script installed by GTK could not be found"
       echo "*** If GTK was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the GTK_CONFIG environment variable to the"
       echo "*** full path to gtk-config."
     else
       if test -f conf.gtktest ; then
        :
       else
          echo "*** Could not run GTK test program, checking why..."
          CFLAGS="$CFLAGS $GTK_CFLAGS"
          LIBS="$LIBS $GTK_LIBS"
          AC_TRY_LINK([
#include <gtk/gtk.h>
#include <stdio.h>
],      [ return ((gtk_major_version) || (gtk_minor_version) || (gtk_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding GTK or finding the wrong"
          echo "*** version of GTK. If it is not finding GTK, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"
          echo "*** If you have a RedHat 5.0 system, you should remove the GTK package that"
          echo "*** came with the system with the command"
          echo "***"
          echo "***    rpm --erase --nodeps gtk gtk-devel" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means GTK was incorrectly installed"
          echo "*** or that you have moved GTK since it was installed. In the latter case, you"
          echo "*** may want to edit the gtk-config script: $GTK_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     GTK_CFLAGS=""
     GTK_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(GTK_CFLAGS)
  AC_SUBST(GTK_LIBS)
  rm -f conf.gtktest
])


AC_DEFUN(AM_PATH_XMMS,
[
AC_ARG_WITH(xmms-prefix,[  --with-xmms-prefix=PFX  Prefix where XMMS is installed (optional)],
	xmms_config_prefix="$withval", xmms_config_prefix="")
AC_ARG_WITH(xmms-exec-prefix,[  --with-xmms-exec-prefix=PFX Exec prefix where XMMS is installed (optional)],
	xmms_config_exec_prefix="$withval", xmms_config_exec_prefix="")

if test x$xmms_config_exec_prefix != x; then
    xmms_config_args="$xmms_config_args --exec-prefix=$xmms_config_exec_prefix"
    if test x${XMMS_CONFIG+set} != xset; then
	XMMS_CONFIG=$xmms_config_exec_prefix/bin/xmms-config
    fi
fi

if test x$xmms_config_prefix != x; then
    xmms_config_args="$xmms_config_args --prefix=$xmms_config_prefix"
    if test x${XMMS_CONFIG+set} != xset; then
  	XMMS_CONFIG=$xmms_config_prefix/bin/xmms-config
    fi
fi

AC_PATH_PROG(XMMS_CONFIG, xmms-config, no)
min_xmms_version=ifelse([$1], ,0.9.5.1, $1)

if test "$XMMS_CONFIG" = "no"; then
    no_xmms=yes
else
    XMMS_CFLAGS=`$XMMS_CONFIG $xmms_config_args --cflags`
    XMMS_LIBS=`$XMMS_CONFIG $xmms_config_args --libs`
    XMMS_VERSION=`$XMMS_CONFIG $xmms_config_args --version`
    XMMS_DATA_DIR=`$XMMS_CONFIG $xmms_config_args --data-dir`
    XMMS_PLUGIN_DIR=`$XMMS_CONFIG $xmms_config_args --plugin-dir`
    XMMS_VISUALIZATION_PLUGIN_DIR=`$XMMS_CONFIG $xmms_config_args \
					--visualization-plugin-dir`
    XMMS_INPUT_PLUGIN_DIR=`$XMMS_CONFIG $xmms_config_args --input-plugin-dir`
    XMMS_OUTPUT_PLUGIN_DIR=`$XMMS_CONFIG $xmms_config_args --output-plugin-dir`
    XMMS_EFFECT_PLUGIN_DIR=`$XMMS_CONFIG $xmms_config_args --effect-plugin-dir`
    XMMS_GENERAL_PLUGIN_DIR=`$XMMS_CONFIG $xmms_config_args --general-plugin-dir`

    XMMS_TEST_VERSION($XMMS_VERSION, $min_xmms_version, ,no_xmms=version)
fi

AC_MSG_CHECKING(for XMMS - version >= $min_xmms_version)

if test "x$no_xmms" = x; then
    AC_MSG_RESULT(yes)
    ifelse([$2], , :, [$2])
else
    AC_MSG_RESULT(no)

    if test "$XMMS_CONFIG" = "no" ; then
	echo "*** The xmms-config script installed by XMMS could not be found."
      	echo "*** If XMMS was installed in PREFIX, make sure PREFIX/bin is in"
	echo "*** your path, or set the XMMS_CONFIG environment variable to the"
	echo "*** full path to xmms-config."
    else
	if test "$no_xmms" = "version"; then
	    echo "*** An old version of XMMS, $XMMS_VERSION, was found."
	    echo "*** You need a version of XMMS newer than $min_xmms_version."
	    echo "*** The latest version of XMMS is always available from"
	    echo "*** http://www.xmms.org/"
	    echo "***"

            echo "*** If you have already installed a sufficiently new version, this error"
            echo "*** probably means that the wrong copy of the xmms-config shell script is"
            echo "*** being found. The easiest way to fix this is to remove the old version"
            echo "*** of XMMS, but you can also set the XMMS_CONFIG environment to point to the"
            echo "*** correct copy of xmms-config. (In this case, you will have to"
            echo "*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf"
            echo "*** so that the correct libraries are found at run-time)"
	fi
    fi
    XMMS_CFLAGS=""
    XMMS_LIBS=""
    ifelse([$3], , :, [$3])
fi
AC_SUBST(XMMS_CFLAGS)
AC_SUBST(XMMS_LIBS)
AC_SUBST(XMMS_VERSION)
AC_SUBST(XMMS_DATA_DIR)
AC_SUBST(XMMS_PLUGIN_DIR)
AC_SUBST(XMMS_VISUALIZATION_PLUGIN_DIR)
AC_SUBST(XMMS_INPUT_PLUGIN_DIR)
AC_SUBST(XMMS_OUTPUT_PLUGIN_DIR)
AC_SUBST(XMMS_GENERAL_PLUGIN_DIR)
AC_SUBST(XMMS_EFFECT_PLUGIN_DIR)
])
