/*
 * Copyright (C) 2003 the xmms-kde team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef __AMAROK_PLAYER__
#define __AMAROK_PLAYER__

#include <kapp.h>
#include <dcopclient.h>
#include "playerinterface.h"

#ifdef HAVE_AMAROK

//! A PlayerInterface to Amarok (the KDE media player).
/*!
  AmarokPlayer can communicate with Amarok via DCOP
*/
class AmarokPlayer:public PlayerInterface {  
  
 public:
  AmarokPlayer();
  ~AmarokPlayer();

  virtual void startPlayer();
  virtual void exitPlayer();
  
  virtual void previous();
  virtual void play();
  virtual void pause();
  virtual void stop();
  virtual void next();

  virtual void setVolume(int volume);
  virtual void setCurrentTime(int time);  
  virtual void toggleRepeat();
  virtual void toggleShuffle();
  
  virtual int getVolume();
  virtual int getCurrentTime();
  virtual int getTrackTime();
  virtual QString getTitle();
  virtual bool getRepeat();
  virtual bool getShuffle();
  virtual bool isPlaying();
  virtual bool isPlayerRunning();

  virtual void openFileSelector();
  virtual void playlistClear();
  virtual void playlistAdd(QString filename);
  virtual void playlistAdd(QStringList filenames);

  virtual Player is() { return AMAROK; }

 private:

  void sendNoParam(QString);
  void sendIntParam(QString, int);
  int callGetInt(QString);
  int callGetBool(QString);

  int getCurrentTimePercent();

  DCOPClient *client;
  bool running;
  int vol;

  QCString amarokId;
};

#else

class AmarokPlayer:public PlayerInterface {  
  
 public:
  AmarokPlayer() {}
  ~AmarokPlayer() {}
};

#endif

#endif
