#include "parser.h"

Parser::Parser() {

}

Parser::~Parser() {

}

ResultParser::ResultParser(QString a, QString t) {

  result = 0;
  artist = QString(a);
  title = QString(t);

  QString are = QString(artist);
  QString tre = QString(title);

  are.replace(QRegExp("[\\s\\*\\+\\?-]"), ".*");
  tre.replace(QRegExp("[\\s\\*\\+\\?-]"), ".*");

  are.replace(QRegExp("\\(.*\\)"), "");   // remove all parantheses
  tre.replace(QRegExp("\\(.*\\)"), "");

  are.replace(QRegExp(","), ".*");
  tre.replace(QRegExp(","), ".*");

  are.replace(QRegExp("[]"), ".");     // help matching umlauts
  tre.replace(QRegExp("[]"), ".");     // help Bjrk and Motrhead

  ar = QRegExp(are, false);
  tr = QRegExp(tre, false);
};

ResultParser::~ResultParser() {

};

bool ResultParser::startDocument() {

  mode = NONE;

  return true;
}

bool ResultParser::endDocument() {

  return true;
}

bool ResultParser::startElement(const QString & ns, const QString & local,
				const QString & qName, const QXmlAttributes & a) {

  if (qName == "result") {

    entry = new Entry(artist, title);
    mode = NONE;

    for (int i = 0; i < a.count(); i++) {

      if (a.localName(i) == "id")
	entry->id = new QString(a.value(i));
      else if (a.localName(i) == "hid")
        entry->hid = new QString(a.value(i));
      else if (a.localName(i) == "exactMatch")
	entry->exact = (a.value(i) == "true");
    }
  }

  else if (qName == "title")
    mode = TITLE;

  else if (qName == "name")
    mode = NAME;
  
  else
    mode = NONE;

  return true;
}

bool ResultParser::endElement(const QString & ns, const QString & local,
			      const QString & qName) {

  if (qName == "result") {

    qDebug("found: [%s] [%s]", entry->dbArtist->latin1(), entry->dbTitle->latin1());
    if ((ar.search(*entry->dbArtist) != -1) &&
	(tr.search(*entry->dbTitle) != -1)) {
      qDebug("----> [%s] [%s]", entry->dbArtist->latin1(), entry->dbTitle->latin1()); 
      
      result = entry;
    } else {
      delete entry;
    }
    entry = 0;
  }

  return true;
}

bool ResultParser::characters(const QString & ch) {

  if ((mode == TITLE) || (mode == NAME)) {
    
    if (ch.stripWhiteSpace() != "") {
      
      if (mode == TITLE)
	entry->dbTitle = new QString(ch);
      
      if (mode == NAME)
	entry->dbArtist = new QString(ch);
    }
  }

  return true;
}

Entry * ResultParser::getEntry() {

  return result;
}


SongParser::SongParser(QString a, QString t) : artist(a), title(t) {

  text = 0;
};

bool SongParser::startDocument() {

  mode = NONE;
  
  if (text)
    delete text;

  text = new QString();

  return true;
}

bool SongParser::endDocument() {

  return true;
}

bool SongParser::startElement(const QString & ns, const QString & local,
			      const QString & qName, const QXmlAttributes & a){

  if (qName == "text")
    mode = TEXT;
  else 
    mode = NONE;

  return true;
}

bool SongParser::endElement(const QString & ns, const QString & local,
			    const QString & qName) {
  return true;
}

bool SongParser::characters(const QString & ch) {


  if (mode == TEXT) {
    
    if (ch.stripWhiteSpace() != "")
      text->append(ch);
  }
  
  return true;
}

QString* SongParser::getText() {

  return text;
}
