/* MSA spectrum analyzer
 * Copyright (C) 2000 Michal Kunikowski <kunik@poczta.onet.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MSA__
#define __MSA__

//#define DEBUGMODE

#define MSA_VERSION_STRING "XMMS MSA v0.5.5"
#define MSA_MAX_PATH_SIZE 1024

typedef struct {
	gint bar_falloff;

	gint peak_mode; // 0-off 1-normal 2-away
	gint peak_delay;
	gint peak_falloff;
	
	gint color[4][4];

	gboolean reverse_mode;
	gboolean mirror_mode;

	gint window_x, window_y;

	gint snap_distance;

	char skindir[MSA_MAX_PATH_SIZE];

	gint screen_width, screen_height;
	
	gboolean isplaying;
	gboolean hasfocus;
} msaconfig;

typedef struct {
	gint ver;
	gint num_bands;
	gint peak_height;
	gint logo_no, bands_on_no, bands_off_no, bands_on_rev_no, bands_off_rev_no;
	gint window_width, window_height;
	gint titlebar_width, titlebar_height, titlebar_x, titlebar_y;
	gint exitbutton_width, exitbutton_height, exitbutton_x, exitbutton_y;
	gint menubutton_width, menubutton_height, menubutton_x, menubutton_y;
	gint analyzer_width, analyzer_height, analyzer_x, analyzer_y;
	struct { GdkColor bg, low, med, high; } defaultcolor;
} msaskinconfig;

extern msaconfig msacfg;
extern msaskinconfig msaskincfg;

void set_peak_mode(int mode);
void set_reverse_mode(gboolean state);
void set_mirror_mode(gboolean state);

void msa_about();
void setdefaultcfg(msaconfig *cfg);
void setskin(gboolean setlogo);
void save_msa_config();
void unrefpixmap(GdkPixmap **pixmap);

#endif
