/* MSA spectrum analyzer
 * Copyright (C) 2000 Michal Kunikowski <kunik@poczta.onet.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <gtk/gtk.h>
#include "msa.h"

static GtkWidget *msa_about_win=NULL;

void msa_about(void)
{
	GtkWidget *vbox, *frame_info, *frame_keys, *label_info, *label_keys, *box, *button;

	if (msa_about_win) return;
	msa_about_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(msa_about_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &msa_about_win);
	gtk_window_set_title(GTK_WINDOW(msa_about_win), "XMMS MSA About");
	gtk_window_set_policy(GTK_WINDOW(msa_about_win), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(msa_about_win), GTK_WIN_POS_MOUSE);
	gtk_container_border_width(GTK_CONTAINER(msa_about_win), 10);

	vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(msa_about_win), vbox);

	frame_info = gtk_frame_new(MSA_VERSION_STRING);
//	gtk_container_border_width(GTK_CONTAINER(frame_info), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame_info, FALSE, FALSE, 0);

	label_info = gtk_label_new("\nCreated by Michal Kunikowski\nEmail: kunik@friko3.onet.pl\nHomepage: http://republika.pl/kunik/msa\n");
	gtk_container_add(GTK_CONTAINER(frame_info), label_info);

	frame_keys = gtk_frame_new("Keys");
//	gtk_container_border_width(GTK_CONTAINER(frame_keys), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame_keys, FALSE, FALSE, 0);

	label_keys = gtk_label_new("\n  q/a - increase/decrease bar speed  \n\
  w/s - increase/decrease peak speed  \n\
  e/d - increase/decrease peak timeout  \n\
  r/f - change bar/peak mode  \n\
  z,x,c,v,b - prev, play, pause, stop, next  \n");
	gtk_label_set_justify(GTK_LABEL(label_keys), GTK_JUSTIFY_LEFT);
	gtk_container_add(GTK_CONTAINER(frame_keys), label_keys);

	box = gtk_hbutton_box_new();
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(box), 5);
	gtk_box_pack_start(GTK_BOX(vbox), box, FALSE, FALSE, 0);

	button = gtk_button_new_with_label("Ok");
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(msa_about_win));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 0);
	gtk_widget_grab_default(button);

	gtk_widget_show(button);
	gtk_widget_show(box);
	gtk_widget_show(frame_info);
	gtk_widget_show(frame_keys);
	gtk_widget_show(label_info);
	gtk_widget_show(label_keys);
	gtk_widget_show(vbox);
	gtk_widget_show(msa_about_win);
}
