#!/bin/sh

echo ""
echo "This Makefile (re-)creates the configure-stack and builds the application"
echo ""

nbr=1

if test -e Makefile; then
	echo "${nbr}. Clean source tree for distribution"
	make distclean 2&> /dev/null
	let "nbr=${nbr}+1"
fi

echo "${nbr}. aclocal"
aclocal -I m4
let "nbr=${nbr}+1"

echo "${nbr}. autoheader"
autoheader
let "nbr=${nbr}+1"

echo "${nbr}. automake"
automake
let "nbr=${nbr}+1"

echo "${nbr}. autoconf"
autoconf
let "nbr=${nbr}+1"

echo "${nbr}. Running default ./configure"
./configure > /dev/null
let "nbr=${nbr}+1"

echo "${nbr}. Running default make all"
make all > /dev/null
let "nbr=${nbr}+1"

echo ""
echo "Done"
echo ""
