/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include <xmms/configfile.h>

#include "singit_macros.h"
#include "singit_macros_private.h"
#include "singit_config_private.h"

#include "singit_dialogs.h"
#include "singit_plugin_scanner.h"

#include "singit_main.h"

#include "dlg_singit_config.h"

#include "singit_wgt_colorbutton.h"
#include "singit_tools.h"
#include "dlg_multiline.h"

static GtkWidget *singit_config_win = NULL;
static GtkWidget
	*config_vbox,
		*config_notebook,
		*config_displayer_vbox, *config_displayer_label,
			*config_filefound_frame, *config_filefound_table,
				*config_filefound_basepath_label,
				*config_filefound_basepath_entry,
				*config_filefound_basepath_button,
				*config_filefound_hsep1,
				*config_filefound_construct_filename_label,
				*config_filefound_construct_filename_entry,
				*config_filefound_construct_filename_button,
				*config_filefound_extension_label,
				*config_filefound_extension_entry,
				*config_filefound_extension_button,
			*config_font_frame,
				*config_font_hbox,
				*config_font_entry,
				*config_font_browse,
				*config_fontsel,
			*config_color_frame,
				*config_color_vbox,
				*config_color_active_hbox_widget,
				*config_color_active_label,
				*config_color_active_button,
				*config_color_background_hbox_widget,
				*config_color_background_label,
				*config_color_background_button,
				*config_color_text_hbox_widget,
				*config_color_text_label,
				*config_color_text_button,
		*config_displayer_toggle_vbox, *config_displayer_toggle_label,
			*config_toggle_yz_check_button,
			*config_show_empty_check_button,
			*config_auto_resize_check_button,
			*config_hide_if_not_found_check_button,
			*config_show_ball_check_button,
			*config_guess_sync_lyrics_check_button,
#ifdef CODEDEBUG
			*config_enable_debug_check_button,
#endif
			*config_find_optimal_font_check_button,
			*config_use_xmms_usleep_check_button,
		*config_editor_hbox, *config_editor_label,
			*config_editor_vbox,
				*config_editor_start_button,
				*config_editor_1_hseparator,
				*config_editor_multi_select_check_button,
				*config_show_hints_check_button,
				*config_extended_lyrics_check_button,
				*config_check_sync_before_save_check_button,
				*config_editor_2_hseparator,
				*config_uwt_frame, *config_uwt_vbox,
					*config_uwt_no_transform_radiobutton,
					*config_uwt_under_to_white_radiobutton,
					*config_uwt_white_to_under_radiobutton,
				*config_editor_3_hseparator,
				*config_reaction_hbox,
					*config_reaction_label,
					*config_reaction_spinbutton,
		*config_dis_plugin_vbox, *config_dis_plugin_label,
				*config_dis_plugin_clist,
				*config_dis_plugin_scrolled_window,
			*config_dis_plugin_hbox,
				*config_dis_plugin_configure_button,
				*config_dis_plugin_about_button,
				*config_dis_plugin_use_check_button,
		*bottom_button_hbox,
			*bottom_button_ok,
			*bottom_button_cancel,
			*bottom_button_apply;

static GtkObject *config_reaction_spinbutton_adj = NULL;
static GSList	 *uwt_modes_group = NULL;

// static GtkWidget *font_select_dialog = NULL;
/*
static GtkTooltips
		*plugin_clist_tooltips = NULL;
*/
typedef struct {

	guchar *color_array;
	guint exporter_selection;

	gboolean updating_displayer_list;

} ConfigStatus;

ConfigStatus config_status;
extern SingitStatus singit_status;

void config_font_browse_ok(GtkWidget * w, gpointer data)
{
        gtk_entry_set_text(GTK_ENTRY(config_font_entry),
		gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(config_fontsel)));
        gtk_widget_destroy(config_fontsel);
}

void config_font_browse_cb(GtkWidget * w, gpointer data)
{
        if (!config_fontsel)
        {
                config_fontsel = gtk_font_selection_dialog_new(_("Select lyric font:"));
		gtk_window_set_modal(GTK_WINDOW(config_fontsel), TRUE);
                gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(config_fontsel),
			getSCD(singit_config)->lyricFontName);
                gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(config_fontsel)->ok_button), "clicked",
			GTK_SIGNAL_FUNC(config_font_browse_ok), NULL);
                gtk_signal_connect_object(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(config_fontsel)->cancel_button),
			"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(config_fontsel));
                gtk_signal_connect(GTK_OBJECT(config_fontsel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			&config_fontsel);
                gtk_widget_show(config_fontsel);
        }
}

// gtk_signal_connect(GTK_OBJECT(config_color_text_button), "color_changed", GTK_SIGNAL_FUNC(color_button_color_changed), NULL);
void color_button_color_changed (ColorButton *gcb)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [color_button_color_changed]\n"), 9);
	#endif
}

void start_singit_editor(GtkWidget *button, gpointer config)
{
	singit_config_save_editor();
	singit_editor_show();
}

void multi_line_dialog_new_text_event(MultiLineDialog *mldlg, gpointer user_data)
{
	gchar *text = NULL, *new_text;
	SingitConfigData *scd = getSCD(singit_config);

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [multi_line_dialog_new_text_event]\n"), 9);
#	endif

	text = multi_line_dialog_get_text(mldlg);
	new_text = tools_replace_string(text, "/,", ",");
	g_free(text);
	text = tools_replace_string(new_text, ",", "/,");
	g_free(new_text);
	if (text[strlen(text)-1] != '/') {
		new_text = text;
		text = g_strconcat(new_text, "/", 0);
		g_free(new_text);
	}

	switch ((gint) user_data) {
	case 0:
		if (scd->basePath) { g_free(scd->basePath); }
		scd->basePath = text;
		gtk_entry_set_text(GTK_ENTRY(config_filefound_basepath_entry),
			scd->basePath);
		break;
	case 1:
		if (scd->basePath) { g_free(scd->constructFilename); }
		scd->constructFilename = text;
		gtk_entry_set_text(GTK_ENTRY(config_filefound_construct_filename_entry),
			scd->constructFilename);
		break;
	case 2:
		if (scd->basePath) { g_free(scd->lyricExtension); }
		scd->lyricExtension = text;
		gtk_entry_set_text(GTK_ENTRY(config_filefound_extension_entry),
			scd->lyricExtension);
		break;
	default:
		if (text) { g_free(text); }
	}
}

void config_open_multiline_editor_ok(GtkWidget *button, gpointer user_data)
{
	GtkWidget * dialog;

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [config_open_multiline_editor_ok]\n"), 9);
#	endif

	dialog = multi_line_dialog_new("Editor", 150, 150);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	gtk_signal_connect(GTK_OBJECT(dialog),
		"new_text", GTK_SIGNAL_FUNC(multi_line_dialog_new_text_event), user_data);
	gtk_signal_connect(GTK_OBJECT(dialog),
		"button_pressed", GTK_SIGNAL_FUNC(multi_line_dialog_hide), user_data);

	switch ((gint) user_data) {
	case 0: multi_line_dialog_set_text(MULTI_LINE_DIALOG(dialog),
			g_strstrip(gtk_entry_get_text(GTK_ENTRY(config_filefound_basepath_entry)))
		);
		break;
	case 1: multi_line_dialog_set_text(MULTI_LINE_DIALOG(dialog),
			gtk_entry_get_text(GTK_ENTRY(config_filefound_construct_filename_entry))
		);
		break;
	case 2: multi_line_dialog_set_text(MULTI_LINE_DIALOG(dialog),
			g_strstrip(gtk_entry_get_text(GTK_ENTRY(config_filefound_extension_entry)))
		);
		break;
	}

	multi_line_dialog_show(MULTI_LINE_DIALOG(dialog), GTK_WINDOW(singit_config_win));
}


void uwt_mode_changed_button_clicked_event (GtkButton *button, gpointer user_data)
{
}

/*********************************************
	displayer plugin funtions
*********************************************/

void config_dis_plugins_plugins(void)
{
	GList *glist;
	gchar *description[2] = { 0 }, *tooltip, *enabled_str;
	DisplayerPlugin *dp;
	gint i = 0, column;

	glist = get_dis_plugin_list();

	gtk_clist_clear(GTK_CLIST(config_dis_plugin_clist));

	while (glist)
	{
		dp = (DisplayerPlugin *) glist->data;
		if (is_dis_plugin_enabled(i)) {
			enabled_str =  _("enabled");
			description[1] = g_strconcat(dp->description, "   (",
				enabled_str, ")", NULL);
			tooltip = g_strdup_printf("%s   [%s] (%s)", dp->description,
				g_basename(dp->filename), enabled_str);
		}
		else {
			description[1] = g_strdup(dp->description);
			tooltip = g_strdup_printf("%s  [%s]", dp->description,
				g_basename(dp->filename));
		}

		if (i < 10) {
			description[0] = g_strdup_printf("[%i]", (i + 1) % 10);
		}
		column = gtk_clist_append(GTK_CLIST(config_dis_plugin_clist), description);
/*		gtk_tooltips_set_tip(plugin_clist_tooltips,
			gtk_clist_get_column_widget(GTK_CLIST(config_dis_plugin_clist), column),
			tooltip, NULL); */
		g_free(description[0]);
		g_free(description[1]);
		g_free(tooltip);
		glist = glist->next;
		i++;
	}
	gtk_widget_set_sensitive(config_dis_plugin_use_check_button, FALSE);
	gtk_widget_set_sensitive(config_dis_plugin_configure_button, FALSE);
	gtk_widget_set_sensitive(config_dis_plugin_about_button, FALSE);
}

void config_dis_plugins_rescan(void)
{
	gint sel;
	GtkAdjustment *adj;
	gfloat pos;

	if (!singit_config_win) { return; }

	if(GTK_CLIST(config_dis_plugin_clist)->selection)
		sel = (gint) GTK_CLIST(config_dis_plugin_clist)->selection->data;
	else
		sel = -1;
	adj = gtk_clist_get_vadjustment(GTK_CLIST(config_dis_plugin_clist));
	pos = adj->value;
	config_dis_plugins_plugins();
	gtk_adjustment_set_value(adj, pos);
	gtk_clist_set_vadjustment(GTK_CLIST(config_dis_plugin_clist), adj);
	if(sel != -1)
		gtk_clist_select_row(GTK_CLIST(config_dis_plugin_clist), sel, 0);
}

void config_dis_plugins_use_cb(GtkWidget * w, gpointer data)
{
	gint sel;
	SingitConfigData *scd = getSCD(singit_config);

	if (!(GTK_CLIST(config_dis_plugin_clist)->selection) ||
		config_status.updating_displayer_list) { return; }

	sel = (gint) GTK_CLIST(config_dis_plugin_clist)->selection->data;

	set_dis_plugin_status_by_number(sel, GTK_TOGGLE_BUTTON(w)->active);
	if (singit_config && scd && scd->song && l_song_lyrics_found(scd->song) && GTK_TOGGLE_BUTTON(w)->active)
		{ dis_plugin_show(sel); }
	g_free(scd->enabled_dplugins);
	scd->enabled_dplugins = dis_plugin_stringify_enabled_list();

	config_dis_plugins_rescan();
}

void config_dis_plugins_configure(GtkWidget * w, gpointer data)
{
	gint sel = (gint) GTK_CLIST(config_dis_plugin_clist)->selection->data;

	dis_plugin_configure(sel);
}

void config_dis_plugins_about(GtkWidget * w, gpointer data)
{
	gint sel = (gint) GTK_CLIST(config_dis_plugin_clist)->selection->data;

	dis_plugin_about(sel);
}

void config_dis_plugins_clist_clicked(GtkWidget * w, gint row, gint column, GdkEvent *event)
{
	DisplayerPlugin *dp;
	gint index;
	GList *dplist;

	if (GTK_CLIST(config_dis_plugin_clist)->selection)
	{
		dplist = get_dis_plugin_list();
		index = (gint) GTK_CLIST(config_dis_plugin_clist)->selection->data;
		dp = g_list_nth(dplist, index)->data;

		gtk_widget_set_sensitive(config_dis_plugin_use_check_button, TRUE);
		config_status.updating_displayer_list = TRUE;
		gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON(config_dis_plugin_use_check_button), is_dis_plugin_enabled(index));
		config_status.updating_displayer_list = FALSE;

		gtk_widget_set_sensitive(config_dis_plugin_configure_button, (dp && dp->configure));
		gtk_widget_set_sensitive(config_dis_plugin_about_button, (dp && dp->about));

		if (event && event->type == GDK_2BUTTON_PRESS)
			gtk_signal_emit_by_name(GTK_OBJECT(config_dis_plugin_configure_button), "clicked");
	}
	else
	{
		gtk_widget_set_sensitive(config_dis_plugin_configure_button, FALSE);
		gtk_widget_set_sensitive(config_dis_plugin_about_button, FALSE);
	}
}

/* -------------------------------------------------------------------------------- */


static void singit_config_cleanup()
{
	SingitConfigData *scd = getSCD(singit_config);

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [singit_config_cleanup]\n"), 9);
#	endif

	if (singit_config_win && singit_config_win->window && scd) {
		gdk_window_get_position(singit_config_win->window,
			&(scd->configWinPosX), &(scd->configWinPosY));
		singit_config_save_positions();
	}

	g_free(config_status.color_array);

	singit_config_detach(TRUE);
}

void singit_config_apply_clicked(GtkButton *button, gpointer user_data)
{
	gchar tmp[13], *temp;
	SingitConfigData *scd = getSCD(singit_config);

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [singit_config_apply_clicked] : "), 9);
#	endif

	if (!(singit_config_win && singit_config_win->window && singit_config_attach())) {
#		ifdef CODEDEBUG
		DEBUG(("failed\n"), 9);
#		endif
		return;
	}

	tmp[12] = '\0';

	pthread_mutex_lock(&singit_status.config_rw_mutex);

	g_free(scd->basePath);
	g_free(scd->constructFilename);
	g_free(scd->lyricExtension);
	g_free(scd->lyricFontName);
	g_free(scd->activeColor);
	g_free(scd->backgroundColor);
	g_free(scd->textColor);
/*	g_free(scd->htmlHeader);
	g_free(scd->htmlTail);
	g_free(scd->lyricLine);*/
	g_free(scd->enabled_dplugins);

	/* set new values */

	scd->basePath = temp = gtk_editable_get_chars(GTK_EDITABLE(config_filefound_basepath_entry), 0, -1);
	if (temp) {
		scd->basePath = g_strdup(g_strstrip(temp));
		g_free(temp);
		if ((scd->basePath[strlen(scd->basePath)-1]) != '/') {
			temp = scd->basePath;
			scd->basePath = g_strconcat(temp, "/", NULL);
			g_free(temp);
		}
	}
	scd->constructFilename = gtk_editable_get_chars(GTK_EDITABLE(config_filefound_construct_filename_entry), 0, -1);
	scd->lyricExtension = gtk_editable_get_chars(GTK_EDITABLE(config_filefound_extension_entry), 0, -1);
	scd->lyricFontName = gtk_editable_get_chars(GTK_EDITABLE(config_font_entry), 0, -1);
	scd->toggleYZ = GTK_TOGGLE_BUTTON(config_toggle_yz_check_button)->active;
	scd->showEmpty = GTK_TOGGLE_BUTTON(config_show_empty_check_button)->active;
	scd->autoResize = GTK_TOGGLE_BUTTON(config_auto_resize_check_button)->active;
	scd->hideIfNotFound = GTK_TOGGLE_BUTTON(config_hide_if_not_found_check_button)->active;
	scd->showJumpingBall = GTK_TOGGLE_BUTTON(config_show_ball_check_button)->active;
	scd->guessSyncLyrics = GTK_TOGGLE_BUTTON(config_guess_sync_lyrics_check_button)->active;
#	ifdef CODEDEBUG
	scd->debugEnable = GTK_TOGGLE_BUTTON(config_enable_debug_check_button)->active;
#	endif
	scd->findOptimalFont = GTK_TOGGLE_BUTTON(config_find_optimal_font_check_button)->active;
	scd->useXMMSuSleep =  GTK_TOGGLE_BUTTON(config_use_xmms_usleep_check_button)->active;
	scd->enabled_dplugins = dis_plugin_stringify_enabled_list();

	sprintf(tmp, "rgb:%.2x/%.2x/%.2x", (gushort) ((guchar *) (COLOR_BUTTON(config_color_active_button)->color))[0],
		(gushort) ((guchar *) (COLOR_BUTTON(config_color_active_button)->color))[1],
		(gushort) ((guchar *) (COLOR_BUTTON(config_color_active_button)->color))[2]);
	scd->activeColor = g_strdup(tmp);
	sprintf(tmp, "rgb:%.2x/%.2x/%.2x", (gushort) ((guchar *) (COLOR_BUTTON(config_color_background_button)->color))[0],
		(gushort) ((guchar *) (COLOR_BUTTON(config_color_background_button)->color))[1],
		(gushort) ((guchar *) (COLOR_BUTTON(config_color_background_button)->color))[2]);
	scd->backgroundColor = g_strdup(tmp);
	sprintf(tmp, "rgb:%.2x/%.2x/%.2x", (gushort) ((guchar *) (COLOR_BUTTON(config_color_text_button)->color))[0],
		(gushort) ((guchar *) (COLOR_BUTTON(config_color_text_button)->color))[1],
		(gushort) ((guchar *) (COLOR_BUTTON(config_color_text_button)->color))[2]);
	scd->textColor = g_strdup(tmp);

	scd->reactionTime =
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(config_reaction_spinbutton));

	pthread_mutex_unlock(&singit_status.config_rw_mutex);

	singit_config_gen_emit_update(SINGIT_CONFIG_GEN(singit_config));

#	ifdef CODEDEBUG
	DEBUG(("Ok\n"), 9);
#	endif

	singit_config_gen_save(SINGIT_CONFIG_GEN(singit_config));

	singit_config_detach();
}

void singit_config_ok_clicked(GtkButton *button, gpointer user_data)
{
	/* apply and save config */
	singit_config_apply_clicked(NULL, NULL);
	singit_config_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(singit_config_win);

	singit_main_finish(FALSE);
}

void singit_config_cancel_clicked(GtkButton *button, gpointer user_data)
{
	singit_config_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(singit_config_win);

	singit_main_finish(FALSE);
}

gint dlg_singit_config_delete_event( GtkWidget *widget, GdkEvent  *event, gpointer data )
{
	singit_config_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(singit_config_win);

	singit_main_finish(FALSE);

	return (FALSE);
}

void add_new_widget(GtkWidget *widget, gchar *name, gboolean show, GSList **group)
{
	if (group != NULL)
		(*group) = gtk_radio_button_group(GTK_RADIO_BUTTON(widget));
//	gtk_widget_set_name(widget, name);
//	gtk_widget_ref(widget);
//	gtk_object_set_data_full(GTK_OBJECT(singit_config_win), name,
//		widget, (GtkDestroyNotify) gtk_widget_unref);
	if (show)
		gtk_widget_show(widget);
}

void singit_config_displayer_page(SingitConfigData *scd)
{
	GdkColor *color;

	config_displayer_vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(config_displayer_vbox), 2);
	gtk_widget_show (config_displayer_vbox);
	config_displayer_label = gtk_label_new(_("Lyrics displayer"));
	gtk_widget_show(config_displayer_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(config_notebook), config_displayer_vbox, config_displayer_label);

	config_filefound_frame = gtk_frame_new(_("Lyric file constructor"));
	gtk_box_pack_start(GTK_BOX(config_displayer_vbox), config_filefound_frame, FALSE, FALSE, 0);
	gtk_widget_show(config_filefound_frame);

	config_filefound_table = gtk_table_new (3, 4, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (config_filefound_table), 3);
	gtk_table_set_col_spacings (GTK_TABLE (config_filefound_table), 3);
	gtk_container_set_border_width(GTK_CONTAINER(config_filefound_table), 2);
	gtk_container_add(GTK_CONTAINER(config_filefound_frame), config_filefound_table);
	gtk_widget_show(config_filefound_table);

/* lyric basepath */
	config_filefound_basepath_label = gtk_label_new(_("Lyrics dir"));
	gtk_table_attach (GTK_TABLE (config_filefound_table), config_filefound_basepath_label, 0, 1, 0, 1,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_filefound_basepath_label);

	config_filefound_basepath_entry = gtk_entry_new();
	gtk_table_attach (GTK_TABLE (config_filefound_table), config_filefound_basepath_entry, 1, 2, 0, 1,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_entry_set_text(GTK_ENTRY(config_filefound_basepath_entry),
		scd->basePath);
	gtk_widget_show(config_filefound_basepath_entry);

	config_filefound_basepath_button = gtk_button_new_with_label ("...");
	gtk_table_attach (GTK_TABLE (config_filefound_table), config_filefound_basepath_button, 2, 3, 0, 1,
		GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_signal_connect(GTK_OBJECT(config_filefound_basepath_button), "clicked",
		GTK_SIGNAL_FUNC(config_open_multiline_editor_ok), (gpointer) 0);
	gtk_widget_show (config_filefound_basepath_button);

	config_filefound_hsep1 = gtk_hseparator_new();
	gtk_table_attach (GTK_TABLE (config_filefound_table), config_filefound_hsep1, 0, 3, 1, 2,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_filefound_hsep1);

	/* lyric filename constructor */
	config_filefound_construct_filename_label = gtk_label_new(_("%1 = filename"));
	gtk_table_attach (GTK_TABLE (config_filefound_table), config_filefound_construct_filename_label, 0, 1, 2, 3,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
//	gtk_widget_show(config_filefound_construct_filename_label);

        config_filefound_construct_filename_entry = gtk_entry_new();
	gtk_table_attach (GTK_TABLE (config_filefound_table), config_filefound_construct_filename_entry, 1, 2, 2, 3,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_entry_set_text(GTK_ENTRY(config_filefound_construct_filename_entry),
		scd->constructFilename);
//	gtk_widget_show(config_filefound_construct_filename_entry);

	config_filefound_construct_filename_button = gtk_button_new_with_label ("...");
	gtk_table_attach (GTK_TABLE (config_filefound_table), config_filefound_construct_filename_button, 2, 3, 2, 3,
		GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_signal_connect(GTK_OBJECT(config_filefound_construct_filename_button), "clicked",
		GTK_SIGNAL_FUNC(config_open_multiline_editor_ok), (gpointer) 1);
//	gtk_widget_show (config_filefound_construct_filename_button);

/* lyric extension */
	config_filefound_extension_label = gtk_label_new(_("Lyric extension"));
	gtk_table_attach (GTK_TABLE (config_filefound_table), config_filefound_extension_label, 0, 1, 3, 4,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_filefound_extension_label);

        config_filefound_extension_entry = gtk_entry_new();
	gtk_table_attach (GTK_TABLE (config_filefound_table), config_filefound_extension_entry, 1, 2, 3, 4,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_entry_set_text(GTK_ENTRY(config_filefound_extension_entry),
		scd->lyricExtension);
	gtk_widget_show(config_filefound_extension_entry);

	config_filefound_extension_button = gtk_button_new_with_label ("...");
	gtk_table_attach (GTK_TABLE (config_filefound_table), config_filefound_extension_button, 2, 3, 3, 4,
		GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_signal_connect(GTK_OBJECT(config_filefound_extension_button), "clicked",
		GTK_SIGNAL_FUNC(config_open_multiline_editor_ok), (gpointer) 2);
	gtk_widget_show (config_filefound_extension_button);

	/* font selection box (from XMMS) */
        config_font_frame = gtk_frame_new(_("Lyrics font"));
        gtk_box_pack_start(GTK_BOX(config_displayer_vbox), config_font_frame, FALSE, FALSE, 2);
	gtk_widget_show(config_font_frame);

        config_font_hbox = gtk_hbox_new(FALSE, 5);
        gtk_container_border_width(GTK_CONTAINER(config_font_hbox), 5);
        gtk_container_add(GTK_CONTAINER(config_font_frame), config_font_hbox);
	gtk_widget_show(config_font_hbox);

        config_font_entry = gtk_entry_new();
        gtk_box_pack_start(GTK_BOX(config_font_hbox), config_font_entry, TRUE, TRUE, 0);
	gtk_entry_set_text(GTK_ENTRY(config_font_entry),
		scd->lyricFontName);
	gtk_widget_show(config_font_entry);

        config_font_browse = gtk_button_new_with_label(_("Browse"));
        gtk_signal_connect(GTK_OBJECT(config_font_browse), "clicked", GTK_SIGNAL_FUNC(config_font_browse_cb), NULL);
        gtk_widget_set_usize(config_font_browse, 85, 17);
        gtk_box_pack_start(GTK_BOX(config_font_hbox), config_font_browse, FALSE, TRUE, 0);
	gtk_widget_show(config_font_browse);

/* color selection frame */
	config_color_frame = gtk_frame_new(_("Colors"));
	gtk_box_pack_start(GTK_BOX(config_displayer_vbox), config_color_frame, TRUE, TRUE, 0);
	gtk_widget_show(config_color_frame);

	config_color_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(config_color_frame), config_color_vbox);
	gtk_container_set_border_width(GTK_CONTAINER(config_color_vbox), 5);
	gtk_widget_show(config_color_vbox);

	color = g_malloc(sizeof(GdkColor));
	gdk_color_parse(scd->activeColor, color);
	config_status.color_array[0] = color->red;
	config_status.color_array[1] = color->green;
	config_status.color_array[2] = color->blue;

	config_color_active_hbox_widget = gtk_hbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(config_color_vbox), config_color_active_hbox_widget);
	config_color_active_label = gtk_label_new(_("Active Color"));
	gtk_box_pack_start(GTK_BOX(config_color_active_hbox_widget), config_color_active_label, TRUE, TRUE, 0);
	config_color_active_button = color_button_new (NULL, 60, 20, &config_status.color_array[0], 3);
	gtk_box_pack_start(GTK_BOX(config_color_active_hbox_widget), config_color_active_button, FALSE, TRUE, 0);
	gtk_widget_show(config_color_active_hbox_widget);
	gtk_widget_show(config_color_active_label);
	gtk_widget_show(config_color_active_button);

	gdk_color_parse(scd->backgroundColor, color);
	config_status.color_array[3] = color->red;
	config_status.color_array[4] = color->green;
	config_status.color_array[5] = color->blue;

	config_color_background_hbox_widget = gtk_hbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(config_color_vbox), config_color_background_hbox_widget);
	config_color_background_label = gtk_label_new(_("Background Color"));
	gtk_box_pack_start(GTK_BOX(config_color_background_hbox_widget), config_color_background_label, TRUE, TRUE, 0);
	config_color_background_button = color_button_new (NULL, 60, 20, &config_status.color_array[3], 3);
	gtk_box_pack_start(GTK_BOX(config_color_background_hbox_widget), config_color_background_button, FALSE, TRUE, 0);
	gtk_widget_show(config_color_background_hbox_widget);
	gtk_widget_show(config_color_background_label);
	gtk_widget_show(config_color_background_button);

	gdk_color_parse(scd->textColor, color);
	config_status.color_array[6] = color->red;
	config_status.color_array[7] = color->green;
	config_status.color_array[8] = color->blue;
	g_free(color);

	config_color_text_hbox_widget = gtk_hbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(config_color_vbox), config_color_text_hbox_widget);
	config_color_text_label = gtk_label_new(_("Text Color"));
	gtk_box_pack_start(GTK_BOX(config_color_text_hbox_widget), config_color_text_label, TRUE, TRUE, 0);
	config_color_text_button = color_button_new (NULL, 60, 20, &config_status.color_array[6], 3);
	gtk_box_pack_start(GTK_BOX(config_color_text_hbox_widget), config_color_text_button, FALSE, TRUE, 0);
	gtk_widget_show(config_color_text_hbox_widget);
	gtk_widget_show(config_color_text_label);
	gtk_widget_show(config_color_text_button);
}

void singit_config_options_page(SingitConfigData *scd)
{
	config_displayer_toggle_vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(config_displayer_toggle_vbox), 2);
	gtk_widget_show (config_displayer_toggle_vbox);
	config_displayer_toggle_label = gtk_label_new(_("Options"));
	gtk_widget_show(config_displayer_toggle_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(config_notebook),
		config_displayer_toggle_vbox, config_displayer_toggle_label);

	config_toggle_yz_check_button = gtk_check_button_new_with_label(_("Toggle y/z-key"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox), config_toggle_yz_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_toggle_yz_check_button),
		scd->toggleYZ);
	gtk_widget_show(config_toggle_yz_check_button);

	config_show_empty_check_button = gtk_check_button_new_with_label(_("Show empty lines"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox), config_show_empty_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_show_empty_check_button),
		scd->showEmpty);
	gtk_widget_show(config_show_empty_check_button);

	config_auto_resize_check_button = gtk_check_button_new_with_label(_("Automagically resize lyric displayer"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox), config_auto_resize_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_auto_resize_check_button),
		scd->autoResize);
	gtk_widget_show(config_auto_resize_check_button);

	config_hide_if_not_found_check_button = gtk_check_button_new_with_label(_("Hide displayer if no lyrics were found"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox), config_hide_if_not_found_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_hide_if_not_found_check_button),
		scd->hideIfNotFound);
	gtk_widget_show(config_hide_if_not_found_check_button);

	config_show_ball_check_button = gtk_check_button_new_with_label(_("Show the jumping ball"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox), config_show_ball_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_show_ball_check_button),
		scd->showJumpingBall);
	gtk_widget_show(config_show_ball_check_button);

	config_guess_sync_lyrics_check_button = gtk_check_button_new_with_label(_("Guess if we have synced lyrics and set ball"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox), config_guess_sync_lyrics_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_guess_sync_lyrics_check_button),
		scd->guessSyncLyrics);
	gtk_widget_show(config_guess_sync_lyrics_check_button);

#	ifdef CODEDEBUG
	config_enable_debug_check_button = gtk_check_button_new_with_label(_("Enable console debug output"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox), config_enable_debug_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_enable_debug_check_button),
		scd->debugEnable);
	gtk_widget_show(config_enable_debug_check_button);
#	endif

	config_find_optimal_font_check_button = gtk_check_button_new_with_label(_("Find the optimal font size (slow fullscreen start)"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox), config_find_optimal_font_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_find_optimal_font_check_button),
		scd->findOptimalFont);
	gtk_widget_show(config_find_optimal_font_check_button);

	config_use_xmms_usleep_check_button = gtk_check_button_new_with_label(_("Use XMMS usleep to save CPU time"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox), config_use_xmms_usleep_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_use_xmms_usleep_check_button),
		scd->useXMMSuSleep);
	gtk_widget_show(config_use_xmms_usleep_check_button);
}

void singit_config_editor_page(SingitConfigData *scd)
{
	gchar *tmp_text = NULL;

	config_editor_hbox = gtk_hbox_new(FALSE, 1);
	gtk_container_set_border_width(GTK_CONTAINER(config_editor_hbox), 2);
	gtk_widget_show(config_editor_hbox);

	config_editor_label = gtk_label_new(_("Lyrics editor"));
	gtk_notebook_append_page(GTK_NOTEBOOK(config_notebook), config_editor_hbox, config_editor_label);
	gtk_widget_show(config_editor_label);

	config_editor_vbox = gtk_vbox_new(FALSE, 1);
	gtk_box_pack_start(GTK_BOX(config_editor_hbox), config_editor_vbox, TRUE, FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(config_editor_vbox), 2);
	gtk_widget_show(config_editor_vbox);

	config_editor_start_button = gtk_button_new_with_label(_("Start lyrics editor ..."));
	gtk_signal_connect(GTK_OBJECT(config_editor_start_button), "clicked", GTK_SIGNAL_FUNC(start_singit_editor), NULL);
	gtk_container_set_border_width(GTK_CONTAINER(config_editor_start_button), 5);
	gtk_box_pack_start(GTK_BOX(config_editor_vbox), config_editor_start_button, TRUE, FALSE, 0);
	gtk_widget_show(config_editor_start_button);

	config_editor_1_hseparator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(config_editor_vbox), config_editor_1_hseparator, TRUE, FALSE, 4);
	gtk_widget_show(config_editor_1_hseparator);

	config_editor_multi_select_check_button = gtk_check_button_new_with_label(_("Allow multiple lyric selections"));
	gtk_box_pack_start(GTK_BOX(config_editor_vbox), config_editor_multi_select_check_button, TRUE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_editor_multi_select_check_button),
		scd->multiSelect);
	gtk_widget_show(config_editor_multi_select_check_button);

	config_show_hints_check_button = gtk_check_button_new_with_label(_("Show editors toolbar tooltips"));
	gtk_box_pack_start(GTK_BOX(config_editor_vbox), config_show_hints_check_button, TRUE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_show_hints_check_button),
		scd->showHints);
	gtk_widget_show(config_show_hints_check_button);

	config_extended_lyrics_check_button = gtk_check_button_new_with_label(_("Use extended tag format"));
	gtk_box_pack_start(GTK_BOX(config_editor_vbox), config_extended_lyrics_check_button, TRUE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_extended_lyrics_check_button),
		scd->extendedLyrics);
	gtk_widget_show(config_extended_lyrics_check_button);

	config_check_sync_before_save_check_button = gtk_check_button_new_with_label(_("Check sync before save"));
	gtk_box_pack_start(GTK_BOX(config_editor_vbox), config_check_sync_before_save_check_button, TRUE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_check_sync_before_save_check_button),
		scd->checkSyncBeforeSave);
	gtk_widget_show(config_check_sync_before_save_check_button);

	config_editor_2_hseparator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(config_editor_vbox), config_editor_2_hseparator, TRUE, FALSE, 4);
	gtk_widget_show(config_editor_2_hseparator);

/* Underscore <--> white transformation frame */
	config_uwt_frame = gtk_frame_new(_("Transform underscores <--> whitespaces"));
	gtk_box_pack_start(GTK_BOX(config_editor_vbox), config_uwt_frame, TRUE, FALSE, 2);
	gtk_widget_show(config_uwt_frame);

	config_uwt_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(config_uwt_frame), config_uwt_vbox);
	gtk_container_set_border_width(GTK_CONTAINER(config_uwt_vbox), 3);
	gtk_widget_show(config_uwt_vbox);

	config_uwt_no_transform_radiobutton = gtk_radio_button_new_with_label (uwt_modes_group, _("Disabled"));
	gtk_box_pack_start(GTK_BOX(config_uwt_vbox), config_uwt_no_transform_radiobutton, TRUE, TRUE, 0);
	add_new_widget(config_uwt_no_transform_radiobutton, "config_uwt_no_transform_radiobutton", TRUE, &uwt_modes_group);
	if (scd->underscoreWhiteTransform == 0)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(config_uwt_no_transform_radiobutton), TRUE);
  	gtk_signal_connect(GTK_OBJECT (config_uwt_no_transform_radiobutton), "clicked",
		GTK_SIGNAL_FUNC(uwt_mode_changed_button_clicked_event), (gpointer) 0);

	config_uwt_under_to_white_radiobutton = gtk_radio_button_new_with_label(uwt_modes_group, _("'_' -> ' '"));
	gtk_box_pack_start(GTK_BOX(config_uwt_vbox), config_uwt_under_to_white_radiobutton, TRUE, TRUE, 0);
	add_new_widget(config_uwt_under_to_white_radiobutton, "config_uwt_under_to_white_radiobutton", TRUE, &uwt_modes_group);
	if (scd->underscoreWhiteTransform == 1)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(config_uwt_under_to_white_radiobutton), TRUE);
  	gtk_signal_connect(GTK_OBJECT (config_uwt_under_to_white_radiobutton), "clicked",
		GTK_SIGNAL_FUNC(uwt_mode_changed_button_clicked_event), (gpointer) 1);
	gtk_widget_set_sensitive(config_uwt_under_to_white_radiobutton, FALSE);

	config_uwt_white_to_under_radiobutton = gtk_radio_button_new_with_label(uwt_modes_group, _("' ' -> '_'"));
	gtk_box_pack_start(GTK_BOX(config_uwt_vbox), config_uwt_white_to_under_radiobutton, TRUE, TRUE, 0);
	add_new_widget(config_uwt_white_to_under_radiobutton, "config_uwt_white_to_under_radiobutton", TRUE, &uwt_modes_group);
	if (scd->underscoreWhiteTransform == 2)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(config_uwt_white_to_under_radiobutton), TRUE);
  	gtk_signal_connect(GTK_OBJECT (config_uwt_white_to_under_radiobutton), "clicked",
		GTK_SIGNAL_FUNC(uwt_mode_changed_button_clicked_event), (gpointer) 2);
	gtk_widget_set_sensitive(config_uwt_white_to_under_radiobutton, FALSE);

	config_editor_3_hseparator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(config_editor_vbox), config_editor_3_hseparator, TRUE, FALSE, 4);
	gtk_widget_show(config_editor_3_hseparator);

/* Reaction spin button */
	config_reaction_hbox = gtk_hbox_new(FALSE, 2);
	gtk_container_add(GTK_CONTAINER(config_editor_vbox), config_reaction_hbox);
	gtk_container_border_width(GTK_CONTAINER(config_reaction_hbox), 2);
	gtk_widget_show(config_reaction_hbox);

	tmp_text = g_strconcat("(!) ", _("Reaction time [ms] (> slower)"), " (!)", 0);
	config_reaction_label = gtk_label_new (tmp_text);
	g_free(tmp_text);
	gtk_box_pack_start(GTK_BOX(config_reaction_hbox), config_reaction_label, FALSE, FALSE, 2);
	gtk_widget_show(config_reaction_label);

	config_reaction_spinbutton_adj = gtk_adjustment_new
		(scd->reactionTime, 0, 9999, 10, 50, 50);
	config_reaction_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (config_reaction_spinbutton_adj), 1, 0);
	gtk_box_pack_start(GTK_BOX(config_reaction_hbox), config_reaction_spinbutton, TRUE, TRUE, 2);
	gtk_widget_show (config_reaction_spinbutton);
}

void singit_config_plugins_page(SingitConfigData *scd)
{
	gchar *displayer_titles[] = { N_(" K "), N_(" displayer plugins ") };

	config_dis_plugin_vbox = gtk_vbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(config_dis_plugin_vbox), 2);
	gtk_widget_show(config_dis_plugin_vbox);

	config_dis_plugin_label = gtk_label_new(_("Plugins"));
	gtk_notebook_append_page(GTK_NOTEBOOK(config_notebook), config_dis_plugin_vbox, config_dis_plugin_label);
	gtk_widget_show(config_dis_plugin_label);

	config_dis_plugin_clist = gtk_clist_new_with_titles(2, displayer_titles);
        gtk_clist_column_titles_passive(GTK_CLIST(config_dis_plugin_clist));
        gtk_clist_set_selection_mode(GTK_CLIST(config_dis_plugin_clist), GTK_SELECTION_SINGLE);
	gtk_clist_set_column_resizeable(GTK_CLIST(config_dis_plugin_clist), 0, FALSE);
	gtk_clist_set_column_resizeable(GTK_CLIST(config_dis_plugin_clist), 1, FALSE);
	gtk_signal_connect(GTK_OBJECT(config_dis_plugin_clist), "select_row", GTK_SIGNAL_FUNC(config_dis_plugins_clist_clicked), NULL);
	gtk_signal_connect(GTK_OBJECT(config_dis_plugin_clist), "unselect_row", GTK_SIGNAL_FUNC(config_dis_plugins_clist_clicked), NULL);
	gtk_widget_show(config_dis_plugin_clist);

        config_dis_plugin_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
        gtk_container_add(GTK_CONTAINER(config_dis_plugin_scrolled_window), config_dis_plugin_clist);
        gtk_container_border_width(GTK_CONTAINER(config_dis_plugin_scrolled_window), 5);
        gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(config_dis_plugin_scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
        gtk_box_pack_start(GTK_BOX(config_dis_plugin_vbox), config_dis_plugin_scrolled_window, TRUE, TRUE, 0);
	gtk_widget_show(config_dis_plugin_scrolled_window);

	config_dis_plugin_hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(config_dis_plugin_hbox), 2);
	gtk_box_pack_start(GTK_BOX(config_dis_plugin_vbox), config_dis_plugin_hbox, FALSE, FALSE, 0);
	gtk_widget_show(config_dis_plugin_hbox);

	config_dis_plugin_configure_button = gtk_button_new_with_label(_("Configure"));
	gtk_signal_connect(GTK_OBJECT(config_dis_plugin_configure_button), "clicked", GTK_SIGNAL_FUNC(config_dis_plugins_configure), NULL);
	gtk_box_pack_start(GTK_BOX(config_dis_plugin_hbox), config_dis_plugin_configure_button, TRUE, TRUE, 5);
	gtk_widget_set_sensitive(config_dis_plugin_configure_button, FALSE);
	gtk_widget_show(config_dis_plugin_configure_button);

	config_dis_plugin_about_button = gtk_button_new_with_label(_("About"));
	gtk_signal_connect(GTK_OBJECT(config_dis_plugin_about_button), "clicked", GTK_SIGNAL_FUNC(config_dis_plugins_about), NULL);
	gtk_box_pack_start(GTK_BOX(config_dis_plugin_hbox), config_dis_plugin_about_button, TRUE, TRUE, 5);
	gtk_widget_set_sensitive(config_dis_plugin_about_button, FALSE);
	gtk_widget_show(config_dis_plugin_about_button);

	config_dis_plugin_use_check_button = gtk_check_button_new_with_label(_("Enable displayer"));
	gtk_box_pack_start(GTK_BOX(config_dis_plugin_hbox), config_dis_plugin_use_check_button, TRUE, TRUE, 5);
	gtk_signal_connect(GTK_OBJECT(config_dis_plugin_use_check_button), "toggled", GTK_SIGNAL_FUNC(config_dis_plugins_use_cb), NULL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_dis_plugin_use_check_button), FALSE);
	gtk_widget_set_sensitive(config_dis_plugin_use_check_button, FALSE);
	gtk_widget_show(config_dis_plugin_use_check_button);
}

void singit_config_show()
{
//	GdkColor *color;
//	gchar *tmp_text = NULL;
	SingitConfigData *scd;

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [singit_config_show]\n"), 9);
#	endif

	if (singit_config_win) {
		gdk_window_raise(singit_config_win->window);
		return;
	}

	if (!singit_config_attach()) {
		singit_config_new();
		singit_config_load();
	}
	scd = getSCD(singit_config);
	if (!scd) { return; }

	singit_main_init(FALSE);

#	ifdef ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, SINGIT_LOCALE_DIR);
#	endif

	config_status.color_array = g_malloc(sizeof(guchar) * 9);
	config_status.updating_displayer_list = FALSE;

//	plugin_clist_tooltips = gtk_tooltips_new ();

	singit_config_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(singit_config_win), "delete_event",
		GTK_SIGNAL_FUNC(dlg_singit_config_delete_event), NULL);

	/* update singit_config_win when window is destroyed */
	gtk_signal_connect(GTK_OBJECT(singit_config_win), "destroy",
		       GTK_SIGNAL_FUNC(gtk_widget_destroyed), &singit_config_win);

	gtk_window_set_title(GTK_WINDOW(singit_config_win), SINGIT_VERSION_STRING " Config");
	gtk_window_set_policy(GTK_WINDOW(singit_config_win), FALSE, FALSE, FALSE);
	gtk_container_border_width(GTK_CONTAINER(singit_config_win), 5);
//	gtk_object_set_data (GTK_OBJECT(singit_config_win), "tooltips", plugin_clist_tooltips);

	config_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(singit_config_win), config_vbox);
	gtk_widget_show(config_vbox);

	config_notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(config_notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(config_vbox), config_notebook, FALSE, FALSE, 0);
	gtk_widget_show(config_notebook);

/*
	Generate all notebook pages
*/
	singit_config_displayer_page(scd);
	singit_config_options_page(scd);
	singit_config_editor_page(scd);
	singit_config_plugins_page(scd);

/*
	Bottom button row ([Ok] [Cancel] [Apply])
*/
	bottom_button_hbox = gtk_hbutton_box_new();
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bottom_button_hbox), 5);
	gtk_box_pack_start(GTK_BOX(config_vbox), bottom_button_hbox, FALSE, FALSE, 0);
	gtk_widget_show(bottom_button_hbox);

	bottom_button_ok = gtk_button_new_with_label(_("Ok"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_ok), "clicked", GTK_SIGNAL_FUNC(singit_config_ok_clicked), (GtkObject*) TRUE);
	GTK_WIDGET_SET_FLAGS(bottom_button_ok, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_ok, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_ok);

	bottom_button_cancel = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_cancel), "clicked", GTK_SIGNAL_FUNC(singit_config_cancel_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_cancel, TRUE, TRUE, 0);
	gtk_widget_grab_default(bottom_button_cancel);
	gtk_widget_show(bottom_button_cancel);

	bottom_button_apply = gtk_button_new_with_label(_("Apply"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_apply), "clicked", GTK_SIGNAL_FUNC(singit_config_apply_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_apply, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_apply, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_apply);

	gtk_widget_show(singit_config_win);

	config_dis_plugins_plugins();

	if ((scd->configWinPosX < 0) || (scd->configWinPosY < 0)) {
		gtk_window_set_position(GTK_WINDOW(singit_config_win), GTK_WIN_POS_MOUSE);
	}
	else {
		gtk_widget_set_uposition(singit_config_win, scd->configWinPosX, scd->configWinPosY);
	}
}

void singit_config_hide()
{
#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [singit_config_hide]\n"), 9);
#	endif

	if (singit_config_win) {
		singit_config_cancel_clicked(NULL, NULL);
	}
}
